/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.base;

import com.metamatrix.jdbc.base.BaseLocalMessages;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class BaseMessages {
    private static final String footprint = "$Revision:   3.5.4.0  $";
    private static BaseLocalMessages baseLocalMessages;
    private BaseLocalMessages implLocalMessages;
    private String driverName;

    public BaseMessages(String string) throws SQLException {
        this.driverName = string;
        this.loadImplLocalMessages();
    }

    private void loadImplLocalMessages() throws SQLException {
        String string = "com.metamatrix.jdbc." + this.driverName.toLowerCase() + "." + this.driverName + "Local";
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string);
            this.implLocalMessages = (BaseLocalMessages)((Object)Class.forName(string + "Messages").newInstance());
            this.implLocalMessages.setResourceBundle(resourceBundle);
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public final BaseLocalMessages getImplLocalMessages() {
        return this.implLocalMessages;
    }

    public final BaseLocalMessages getBaseLocalMessages() {
        return baseLocalMessages;
    }

    public String getMessage(int n, String[] stringArray, boolean bl) {
        String string;
        block5: {
            string = null;
            if (this.implLocalMessages != null) {
                try {
                    string = this.implLocalMessages.getString(n, stringArray);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            if (string != null) break block5;
            try {
                string = baseLocalMessages.getString(n, stringArray);
            }
            catch (MissingResourceException missingResourceException) {
                string = "(Internal Error) Message " + n + " not found.";
                stringArray = null;
            }
        }
        return this.formatMessage(string, stringArray, bl);
    }

    protected String formatMessage(String string, String[] stringArray, boolean bl) {
        String string2 = "[MetaMatrix][" + this.driverName + " JDBC Driver]";
        if (bl) {
            string2 = string2 + "[" + this.driverName + "]";
        }
        string2 = string2 + string;
        if (stringArray != null) {
            string2 = MessageFormat.format(string2, stringArray);
        }
        return string2;
    }

    static {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com.metamatrix.jdbc.base.BaseLocal");
        baseLocalMessages = new BaseLocalMessages();
        baseLocalMessages.setResourceBundle(resourceBundle);
    }
}

