/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.util;

import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilTransliterator;
import java.util.Vector;

public class UtilTransliteratorPool {
    private static String footprint = "$Revision:   3.1.2.0  $";
    Vector transliterators;

    public UtilTransliteratorPool(int n) {
        this.transliterators = new Vector(n);
    }

    public UtilTransliterator getTransliteratorForCodePage(String string) throws UtilException {
        Object object;
        int n = 0;
        while (n < this.transliterators.size()) {
            object = (TransliteratorForLCID)this.transliterators.elementAt(n);
            if (string.compareTo(((TransliteratorForLCID)object).codePage) == 0) {
                return ((TransliteratorForLCID)object).transliterator;
            }
            ++n;
        }
        object = UtilTransliterator.GetNewTransliterator(string);
        if (object != null) {
            TransliteratorForLCID transliteratorForLCID = new TransliteratorForLCID();
            transliteratorForLCID.codePage = string;
            transliteratorForLCID.transliterator = object;
            this.transliterators.addElement(transliteratorForLCID);
        }
        return object;
    }

    public void reset() {
        int n = 0;
        while (n < this.transliterators.size()) {
            TransliteratorForLCID transliteratorForLCID = (TransliteratorForLCID)this.transliterators.elementAt(n);
            transliteratorForLCID.transliterator.setDefaultCacheSize();
            ++n;
        }
    }

    private class TransliteratorForLCID {
        String codePage;
        UtilTransliterator transliterator;

        private TransliteratorForLCID() {
        }
    }
}

