/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.api.exception.query.ProcedureErrorInstructionException;
import com.metamatrix.api.exception.security.InvalidSessionException;
import com.metamatrix.api.exception.security.LogonException;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.exception.ConnectionException;
import com.metamatrix.core.MetaMatrixCoreException;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.util.MetaMatrixExceptionUtil;
import com.metamatrix.core.util.MetaMatrixNestedException;
import com.metamatrix.jdbc.api.SQLException;
import com.metamatrix.jdbc.api.SQLStates;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;

public class MMSQLException
extends java.sql.SQLException
implements SQLException,
MetaMatrixNestedException {
    private Throwable nonSqlExceptionCause;

    public MMSQLException() {
    }

    public static MMSQLException create(Throwable exception) {
        return MMSQLException.create(exception, exception.getMessage());
    }

    public static MMSQLException create(Throwable exception, String message) {
        message = MMSQLException.getMessage(exception, message);
        Throwable origException = exception;
        if (exception instanceof MMSQLException && message.equals(exception.getMessage())) {
            return (MMSQLException)exception;
        }
        if (exception instanceof java.sql.SQLException) {
            return new MMSQLException((java.sql.SQLException)exception, message, true);
        }
        String sqlState = "38000";
        if (exception instanceof MetaMatrixRuntimeException) {
            while (exception.getCause() != exception && exception.getCause() != null && exception instanceof MetaMatrixRuntimeException) {
                exception = exception.getCause();
            }
            if (exception instanceof MetaMatrixRuntimeException) {
                MetaMatrixRuntimeException runtimeException = (MetaMatrixRuntimeException)exception;
                while (runtimeException.getChild() != exception && runtimeException.getChild() != null && runtimeException instanceof MetaMatrixRuntimeException) {
                    if (runtimeException.getChild() instanceof MetaMatrixRuntimeException) {
                        runtimeException = (MetaMatrixRuntimeException)runtimeException.getChild();
                        continue;
                    }
                    exception = runtimeException.getChild();
                }
            }
        }
        if (exception instanceof InvalidSessionException) {
            sqlState = "08S01";
        } else if (exception instanceof LogonException) {
            sqlState = "28000";
        } else if (exception instanceof ProcedureErrorInstructionException) {
            sqlState = "50001";
        } else if (exception instanceof MetaMatrixProcessingException) {
            sqlState = "50000";
        } else if (exception instanceof UnknownHostException || exception instanceof ConnectException || exception instanceof MalformedURLException || exception instanceof NoRouteToHostException || exception instanceof ConnectionException) {
            sqlState = "08001";
        } else if (exception instanceof IOException || exception instanceof CommunicationException) {
            sqlState = "08S01";
        }
        if (exception instanceof MetaMatrixCoreException) {
            MetaMatrixCoreException coreException = (MetaMatrixCoreException)exception;
            IStatus status = null;
            if (coreException != null) {
                status = coreException.getStatus();
            }
            if (status != null) {
                exception = status.getException();
            }
            if (exception instanceof MetaMatrixRuntimeException) {
                while (exception.getCause() != exception && exception.getCause() != null) {
                    exception = exception.getCause();
                }
                if (exception instanceof MetaMatrixRuntimeException) {
                    MetaMatrixRuntimeException runtimeException = (MetaMatrixRuntimeException)exception;
                    while (runtimeException.getChild() != exception && runtimeException.getChild() != null) {
                        exception = runtimeException.getChild();
                    }
                }
            }
            if (exception instanceof InvalidSessionException) {
                sqlState = "08S01";
            } else if (exception instanceof LogonException) {
                sqlState = "28000";
            } else if (exception instanceof ProcedureErrorInstructionException) {
                sqlState = "50001";
            } else if (exception instanceof MetaMatrixProcessingException) {
                sqlState = "50000";
            } else if (exception instanceof CommunicationException) {
                sqlState = "50000";
                exception = exception.getCause();
            }
            if (exception instanceof UnknownHostException || exception instanceof ConnectException || exception instanceof MalformedURLException || exception instanceof NoRouteToHostException || exception instanceof ConnectionException) {
                sqlState = "08001";
            } else if (exception instanceof IOException) {
                sqlState = "08S01";
            }
        }
        return new MMSQLException(message, origException, sqlState);
    }

    private static String getMessage(Throwable exception, String message) {
        if (message == null && (message = exception.getMessage()) == null) {
            message = exception.getClass().getName();
        }
        return message;
    }

    private MMSQLException(String reason, Throwable ex, String sqlState) {
        super(reason, sqlState);
        this.nonSqlExceptionCause = ex;
    }

    private MMSQLException(java.sql.SQLException ex, String message, boolean addChildren) {
        super(message, ex.getSQLState() == null ? "38000" : ex.getSQLState(), ex.getErrorCode());
        if (addChildren) {
            Throwable childException = ex;
            while (childException != null) {
                if (childException instanceof MetaMatrixException) {
                    super.setNextException(new MMSQLException(childException.getMessage()));
                    childException = ((MetaMatrixException)childException).getChild();
                    continue;
                }
                if (childException instanceof java.sql.SQLException) {
                    super.setNextException(new MMSQLException((java.sql.SQLException)childException, MMSQLException.getMessage(childException, null), false));
                    childException = ((java.sql.SQLException)childException).getNextException();
                    continue;
                }
                super.setNextException(new MMSQLException(childException.getMessage()));
                childException = null;
            }
        }
    }

    MMSQLException(String reason) {
        super(reason, "38000");
    }

    public String getFullMessage() {
        return MetaMatrixExceptionUtil.getFullMessage((MetaMatrixNestedException)this);
    }

    public void printStackTrace() {
        MetaMatrixExceptionUtil.printStackTrace((MetaMatrixNestedException)this);
    }

    public Throwable getCause() {
        Iterator i = MetaMatrixExceptionUtil.getChildrenIterator((Throwable)this);
        if (i.hasNext()) {
            return (Throwable)i.next();
        }
        return null;
    }

    public void printStackTrace(PrintStream output) {
        MetaMatrixExceptionUtil.printStackTrace((MetaMatrixNestedException)this, (PrintStream)output);
    }

    public void printStackTrace(PrintWriter output) {
        MetaMatrixExceptionUtil.printStackTrace((MetaMatrixNestedException)this, (PrintWriter)output);
    }

    public Throwable getNestedException() {
        if (this.nonSqlExceptionCause == null) {
            return this.getNextException();
        }
        return this.nonSqlExceptionCause;
    }

    public void superPrintStackTrace(PrintStream output) {
        super.printStackTrace(output);
    }

    public void superPrintStackTrace(PrintWriter output) {
        super.printStackTrace(output);
    }

    public boolean isSystemErrorState() {
        return SQLStates.isSystemErrorState(this.getSQLState());
    }

    public boolean isUsageErrorState() {
        return SQLStates.isUsageErrorState(this.getSQLState());
    }
}

