/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xmlsource.soap;

import com.metamatrix.connector.xmlsource.XMLSourceConnection;
import com.metamatrix.connector.xmlsource.XMLSourcePlugin;
import com.metamatrix.connector.xmlsource.soap.ServiceOperation;
import com.metamatrix.connector.xmlsource.soap.SoapExecution;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.ConnectorLogger;
import com.metamatrix.data.api.Execution;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.metadata.runtime.RuntimeMetadata;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Call;
import org.apache.axis.wsdl.gen.Parser;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.Parameters;
import org.apache.axis.wsdl.symbolTable.ServiceEntry;
import org.apache.axis.wsdl.symbolTable.SymTabEntry;
import org.apache.axis.wsdl.symbolTable.SymbolTable;

public class SoapConnection
extends XMLSourceConnection {
    private static final String END_POINT = "EndPoint";
    private static final String WSDL = "wsdl";
    private static final String PORT_NAME = "PortName";
    private static final String QUERY_TIMEOUT = "QueryTimeout";
    boolean connected = false;
    org.apache.axis.client.Service service = null;
    Map operationsMap = new HashMap();
    static /* synthetic */ Class class$org$apache$axis$wsdl$symbolTable$ServiceEntry;

    public SoapConnection(ConnectorEnvironment env) throws ConnectorException {
        super(env);
        this.connect();
    }

    protected Execution createExecution(ExecutionContext executionContext, RuntimeMetadata metadata) throws ConnectorException {
        return new SoapExecution(this.env, metadata, this);
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void release() {
        this.disconnect();
        super.release();
    }

    void connect() throws ConnectorException {
        Properties props = this.env.getProperties();
        String wsdl = props.getProperty(WSDL);
        String portName = props.getProperty(PORT_NAME);
        String endpoint = props.getProperty(END_POINT);
        String timeout = props.getProperty(QUERY_TIMEOUT);
        if (wsdl == null || wsdl.trim().length() == 0) {
            throw new ConnectorException(XMLSourcePlugin.Util.getString("wsdl_not_set"));
        }
        try {
            XMLSourcePlugin.logInfo((ConnectorLogger)this.env.getLogger(), (String)"loading_wsdl", (Object[])new Object[]{wsdl});
            Parser wsdlParser = new Parser();
            wsdlParser.run(wsdl);
            Service wsdlService = this.getService(wsdlParser.getSymbolTable());
            this.service = new org.apache.axis.client.Service(wsdlParser, wsdlService.getQName());
            Port port = this.selectPort(wsdlService.getPorts(), portName);
            this.operationsMap = this.buildOperations(wsdlParser.getSymbolTable(), port, endpoint, timeout);
            this.connected = true;
        }
        catch (Exception e) {
            throw new ConnectorException((Throwable)e, XMLSourcePlugin.Util.getString("failed_loading_wsdl", new Object[]{wsdl}));
        }
    }

    private Map buildOperations(SymbolTable symbolTable, Port usePort, String endPoint, String timeout) {
        BindingOperation operation;
        HashMap<String, ServiceOperation> map = new HashMap<String, ServiceOperation>();
        Binding binding = usePort.getBinding();
        BindingEntry bEntry = symbolTable.getBindingEntry(binding.getQName());
        String style = null;
        Iterator i = binding.getExtensibilityElements().iterator();
        while (i.hasNext()) {
            ExtensibilityElement extElement = (ExtensibilityElement)i.next();
            if (!(extElement instanceof SOAPBinding)) continue;
            style = ((SOAPBinding)extElement).getStyle();
        }
        if (style == null) {
            i = binding.getBindingOperations().iterator();
            while (i.hasNext()) {
                operation = (BindingOperation)i.next();
                List extElements = operation.getExtensibilityElements();
                Iterator extIter = extElements.iterator();
                while (extIter.hasNext()) {
                    ExtensibilityElement extElement = (ExtensibilityElement)extIter.next();
                    if (!(extElement instanceof SOAPOperation)) continue;
                    style = ((SOAPOperation)extElement).getStyle();
                }
            }
        }
        i = bEntry.getOperations().iterator();
        while (i.hasNext()) {
            operation = (Operation)i.next();
            Parameters parameters = bEntry.getParameters((Operation)operation);
            ServiceOperation so = new ServiceOperation(operation.getName(), parameters, usePort.getName(), style);
            so.setEndpoint(endPoint);
            if (timeout != null && timeout.length() > 0) {
                so.setQueryTimeput(Integer.parseInt(timeout));
            }
            map.put(operation.getName(), so);
        }
        return map;
    }

    void disconnect() {
        this.connected = false;
        this.operationsMap.clear();
    }

    private Service getService(SymbolTable table) throws ServiceNotFoundException {
        Class serviceClazz = class$org$apache$axis$wsdl$symbolTable$ServiceEntry == null ? (class$org$apache$axis$wsdl$symbolTable$ServiceEntry = SoapConnection.class$("org.apache.axis.wsdl.symbolTable.ServiceEntry")) : class$org$apache$axis$wsdl$symbolTable$ServiceEntry;
        HashMap map = table.getHashMap();
        Iterator iter = map.values().iterator();
        while (iter.hasNext()) {
            Vector v = (Vector)iter.next();
            for (int i = 0; i < v.size(); ++i) {
                SymTabEntry tabEntry = (SymTabEntry)v.elementAt(i);
                if (!serviceClazz.isInstance(tabEntry)) continue;
                ServiceEntry serviceEntry = (ServiceEntry)tabEntry;
                return serviceEntry.getService();
            }
        }
        throw new ServiceNotFoundException();
    }

    private Port selectPort(Map ports, String portName) throws Exception {
        Iterator valueIterator = ports.keySet().iterator();
        while (valueIterator.hasNext()) {
            String name = (String)valueIterator.next();
            if (portName == null || portName.length() == 0) {
                Port port = (Port)ports.get(name);
                List list = port.getExtensibilityElements();
                for (int i = 0; list != null && i < list.size(); ++i) {
                    Object obj = list.get(i);
                    if (!(obj instanceof SOAPAddress)) continue;
                    return port;
                }
                continue;
            }
            if (name == null || !name.equals(portName)) continue;
            return (Port)ports.get(name);
        }
        return null;
    }

    public ServiceOperation findOperation(String procedureName) throws OperationNotFoundException {
        ServiceOperation operation = (ServiceOperation)this.operationsMap.get(procedureName);
        if (operation == null) {
            throw new OperationNotFoundException(procedureName);
        }
        try {
            Call call = (Call)this.service.createCall(QName.valueOf(operation.portName), QName.valueOf(procedureName));
            operation.setStub(call);
        }
        catch (ServiceException e) {
            throw new OperationNotFoundException(e);
        }
        return operation;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class OperationNotFoundException
    extends Exception {
        public OperationNotFoundException(String e) {
            super(e);
        }

        public OperationNotFoundException(Throwable e) {
            super(e);
        }
    }

    static class ServiceNotFoundException
    extends Exception {
        ServiceNotFoundException() {
        }
    }
}

