/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.util.crypto.cipher;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.CryptoFactory;
import com.metamatrix.common.util.crypto.Cryptor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class BasicCryptor
implements Cryptor {
    public static final String DEFAULT_ALGORITHM = "RSA/ECB/PKCS1Padding";
    private String cipherAlgorithm = "RSA/ECB/PKCS1Padding";
    private Key encryptKey = null;
    private Key decryptKey = null;
    private Cipher encryptCipher = null;
    private Cipher decryptCipher = null;
    private String providerName = null;

    public BasicCryptor(Key encryptKey, Key decryptKey) throws CryptoException {
        this(encryptKey, decryptKey, null);
    }

    public BasicCryptor(Key encryptKey, Key decryptKey, String providerName) throws CryptoException {
        this.encryptKey = encryptKey;
        this.decryptKey = decryptKey;
        this.providerName = providerName;
        this.initCiphers();
    }

    public synchronized byte[] encrypt(byte[] cleartext) throws CryptoException {
        try {
            return BasicCryptor.useCipher(cleartext, this.encryptCipher);
        }
        catch (Exception e) {
            CryptoFactory.clearCache();
            throw new CryptoException("ERR.003.030.0070", CommonPlugin.Util.getString("ERR.003.030.0070", (Object)e.getClass().getName(), (Object)e.getMessage()));
        }
    }

    static byte[] useCipher(byte[] in, Cipher cipher) throws CryptoException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, IOException {
        int blockSize = cipher.getBlockSize();
        if (blockSize == 0) {
            blockSize = in.length;
        }
        int blocks = in.length / blockSize;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int i = 0; i < blocks; ++i) {
            baos.write(cipher.doFinal(in, i * blockSize, blockSize));
        }
        int extraBytes = in.length % blockSize;
        if (extraBytes > 0) {
            baos.write(cipher.doFinal(in, in.length - extraBytes, extraBytes));
        }
        return baos.toByteArray();
    }

    public synchronized byte[] decrypt(byte[] ciphertext) throws CryptoException {
        try {
            return BasicCryptor.useCipher(ciphertext, this.decryptCipher);
        }
        catch (Exception e) {
            CryptoFactory.clearCache();
            throw new CryptoException("ERR.003.030.0071", CommonPlugin.Util.getString("ERR.003.030.0071", (Object)e.getClass().getName(), (Object)e.getMessage()));
        }
    }

    public char[] encrypt(char[] cleartext) throws CryptoException {
        if (cleartext == null) {
            throw new CryptoException("ERR.003.030.0072", CommonPlugin.Util.getString("ERR.003.030.0072"));
        }
        String clearString = new String(cleartext);
        if (clearString.trim().length() == 0 && clearString.length() == 0) {
            throw new CryptoException("ERR.003.030.0073", CommonPlugin.Util.getString("ERR.003.030.0073"));
        }
        byte[] clearBytes = clearString.getBytes();
        byte[] cipherBytes = this.encrypt(clearBytes);
        return CryptoFactory.encodeBytes((byte[])cipherBytes);
    }

    public char[] decrypt(char[] ciphertext) throws CryptoException {
        if (ciphertext == null) {
            throw new CryptoException("ERR.003.030.0074", CommonPlugin.Util.getString("ERR.003.030.0074"));
        }
        byte[] cipherBytes = null;
        try {
            cipherBytes = CryptoFactory.decodeBytes((char[])ciphertext);
        }
        catch (IllegalArgumentException e) {
            throw new CryptoException("ERR.003.030.0075", CommonPlugin.Util.getString("ERR.003.030.0075", (Object)e.getMessage()));
        }
        byte[] cleartext = this.decrypt(cipherBytes);
        return new String(cleartext).toCharArray();
    }

    private void initCiphers() throws CryptoException {
        try {
            this.encryptCipher = this.providerName != null ? Cipher.getInstance(this.cipherAlgorithm, this.providerName) : Cipher.getInstance(this.cipherAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException((Throwable)e, "ERR.003.030.0076", CommonPlugin.Util.getString("ERR.003.030.0076", (Object)this.cipherAlgorithm));
        }
        catch (NoSuchPaddingException e) {
            throw new CryptoException("ERR.003.030.0077", CommonPlugin.Util.getString("ERR.003.030.0077", (Object)this.cipherAlgorithm, (Object)e.getClass().getName(), (Object)e.getMessage()));
        }
        catch (NoSuchProviderException e) {
            throw new CryptoException("ERR.003.030.0077", CommonPlugin.Util.getString("ERR.003.030.0077", (Object)this.cipherAlgorithm, (Object)e.getClass().getName(), (Object)e.getMessage()));
        }
        try {
            this.encryptCipher.init(1, this.encryptKey);
        }
        catch (InvalidKeyException e) {
            throw new CryptoException((Throwable)e, "ERR.003.030.0078", CommonPlugin.Util.getString("ERR.003.030.0078", (Object)e.getClass().getName(), (Object)e.getMessage()));
        }
        AlgorithmParameters algParams = this.encryptCipher.getParameters();
        try {
            if (algParams != null) {
                algParams.getEncoded();
            }
        }
        catch (IOException e) {
            throw new CryptoException("ERR.003.030.0079", CommonPlugin.Util.getString("ERR.003.030.0079", (Object)e.getClass().getName(), (Object)e.getMessage()));
        }
        try {
            this.decryptCipher = this.providerName != null ? Cipher.getInstance(this.cipherAlgorithm, this.providerName) : Cipher.getInstance(this.cipherAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException((Throwable)e, "ERR.003.030.0076", CommonPlugin.Util.getString("ERR.003.030.0076", (Object)this.cipherAlgorithm));
        }
        catch (NoSuchPaddingException e) {
            throw new CryptoException("ERR.003.030.0077", CommonPlugin.Util.getString("ERR.003.030.0077", (Object)this.cipherAlgorithm, (Object)e.getClass().getName(), (Object)e.getMessage()));
        }
        catch (NoSuchProviderException e) {
            throw new CryptoException("ERR.003.030.0077", CommonPlugin.Util.getString("ERR.003.030.0077", (Object)this.cipherAlgorithm, (Object)e.getClass().getName(), (Object)e.getMessage()));
        }
        if (algParams != null) {
            try {
                this.decryptCipher.init(2, this.decryptKey, algParams);
            }
            catch (InvalidKeyException e) {
                throw new CryptoException((Throwable)e, "ERR.003.030.0078", CommonPlugin.Util.getString("ERR.003.030.0078", (Object)e.getClass().getName(), (Object)e.getMessage()));
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new CryptoException((Throwable)e, "ERR.003.030.0080", CommonPlugin.Util.getString("ERR.003.030.0080", (Object)this.cipherAlgorithm));
            }
        }
        try {
            this.decryptCipher.init(2, this.decryptKey);
        }
        catch (InvalidKeyException e) {
            throw new CryptoException((Throwable)e, "ERR.003.030.0079", CommonPlugin.Util.getString("ERR.003.030.0079", (Object)e.getClass().getName(), (Object)e.getMessage()));
        }
    }
}

