/*
 [The "BSD licence"]
 Copyright (c) 2003-2004 Terence Parr
 All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions
 are met:
 1. Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.
 3. The name of the author may not be used to endorse or promote products
    derived from this software without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
package org.antlr.stringtemplate.test;

import org.antlr.stringtemplate.test.TestSuite;

import java.lang.reflect.Method;
import java.lang.reflect.InvocationTargetException;

/** Terence's own version of a test case.  Got sick of trying to figure out
 *  the quirks of junit...this is pretty much the same functionality and
 *  only took me a few minutes to write.  Only missing the gui I guess from junit.
 */
public class TestRig {
    protected Class testCaseClass = null;

    /** Test program */
    public static void main(String[] args) throws Throwable {
        if ( args.length==0 ) {
            System.err.println("Please pass in a test to run; must be class with runTests() method");
        }
        String className = args[0];
        TestSuite test = null;
        try {
            try {
                Class c = Class.forName(className);
                test = (TestSuite)c.newInstance();
            }
            catch (Exception e) {
                System.out.println("Cannot load class: "+className);
                e.printStackTrace();
                return;
            }
            test.runTests();
        }
        catch (FailedAssertionException fae) {
            System.out.println("FAILED "+test.testName+":");
            fae.printStackTrace();
        }
        catch (Exception e) {
            System.out.println("Exception during test "+test.testName);
            e.printStackTrace();
        }
        System.out.println("successes: "+test.getSuccesses());
        System.out.println("failures: "+test.getFailures());
    }
}
