/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.tools.mmshell;

import com.metamatrix.dqp.tools.DQPToolsPlugin;
import com.metamatrix.dqp.tools.mmshell.JdbcManager;
import com.metamatrix.dqp.tools.mmshell.VDBContext;
import com.metamatrix.dqp.tools.mmshell.config.TypeProperty;
import com.metamatrix.modeler.jdbc.JdbcSource;
import com.metamatrix.tools.toolshell.ToolShell;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;

public class GetJdbcSourcePropertiesCommand {
    public static boolean execute(String sourceName, Resource resource, ToolShell shell, VDBContext context) throws Exception {
        JdbcSource src = JdbcManager.getJdbcSource(resource, shell);
        if (src == null) {
            shell.printlnError(DQPToolsPlugin.UTIL.getString("noConnectionInfo", (Object)sourceName));
            return false;
        }
        String srcType = JdbcManager.getJdbcSourceType(src);
        if (srcType != null) {
            List typeProps = context.getTypeManager().getProperties(srcType);
            shell.printlnVerbose(DQPToolsPlugin.UTIL.getString("GetCommand.header", (Object)sourceName));
            Iterator typeIter = typeProps.iterator();
            while (typeIter.hasNext()) {
                TypeProperty typeProp = (TypeProperty)typeIter.next();
                String srcTypePropName = typeProp.getName();
                boolean masked = typeProp.isMasked();
                String value = null;
                value = masked ? "*****" : context.getBindingProperty(sourceName, srcTypePropName);
                shell.printlnVerbose("  " + srcTypePropName + "=" + value);
            }
        } else {
            shell.printlnError("Unknown source type - can't determine properties");
        }
        return true;
    }
}

