/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.tools.mmshell;

import com.metamatrix.dqp.tools.DQPToolsPlugin;
import com.metamatrix.dqp.tools.mmshell.EmbeddedAdminCommandImpl;
import com.metamatrix.dqp.tools.mmshell.JdbcManager;
import com.metamatrix.dqp.tools.mmshell.MMShell;
import com.metamatrix.dqp.tools.mmshell.VDBContext;
import com.metamatrix.modeler.core.ModelEditor;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.jdbc.JdbcSource;
import com.metamatrix.tools.toolshell.ToolShell;
import com.metamatrix.tools.toolshell.database.DatabaseConnectionContext;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;

public class ListCommand
extends EmbeddedAdminCommandImpl {
    static final String ALL_SCHEMA_OBJECTS_KEYWORD = "ALL";
    static final String SCHEMA_SYSTEM = "System";
    static final String SCHEMA_MODELS = "System.Models";
    static final String SCHEMA_GROUPS = "System.Groups";
    static final String SCHEMA_ELEMENTS = "System.Elements";
    static final String SCHEMA_ELEMENTS_NAME = "System.Elements.Name";
    static final String SCHEMA_ELEMENTS_MODELNAME = "System.Elements.ModelName";
    static final String SCHEMA_ELEMENTS_GROUPFULLNAME = "System.Elements.GroupFullName";
    static final String SCHEMA_ELEMENTS_POSITION = "System.Elements.Position";
    static final String SCHEMA_KEYELEMENTS = "System.KeyElements";
    static final String SCHEMA_KEYELEMENTS_NAME = "System.KeyElements.Name";
    static final String SCHEMA_KEYELEMENTS_GROUPFULLNAME = "System.KeyElements.GroupFullName";
    static final String SCHEMA_KEYELEMENTS_KEYTYPE = "System.KeyElements.KeyType";
    static final String SCHEMA_ODBC = "System.ODBC";
    static final String SCHEMA_JDBC = "System.JDBC";
    static final String PRIMARY_KEYTYPE = "Primary";
    private static ListCommand shared;

    public static ListCommand get() {
        if (shared == null) {
            shared = new ListCommand();
        }
        return shared;
    }

    public String getCommandName() {
        return DQPToolsPlugin.UTIL.getString("ListCommand.commandName");
    }

    public String getLongHelp(List argList) {
        return DQPToolsPlugin.UTIL.getString("ListCommand.longHelp");
    }

    public String getShortHelp() {
        return DQPToolsPlugin.UTIL.getString("ListCommand.shortHelp");
    }

    public String getArgHelp() {
        return DQPToolsPlugin.UTIL.getString("ListCommand.argHelp");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean executeCommand(Iterator iterator) {
        block7: {
            block8: {
                if (!this.verifyOpen()) {
                    return true;
                }
                iterator.next();
                if (!iterator.hasNext()) break block8;
                String srcName = this.getSourceName(iterator);
                if (iterator.hasNext()) {
                    String listOption = (String)iterator.next();
                    if (!listOption.equalsIgnoreCase(ALL_SCHEMA_OBJECTS_KEYWORD)) {
                        this.printlnError(DQPToolsPlugin.UTIL.getString("ListCommand.invalid_option", (Object)listOption));
                        return true;
                    }
                    this.listSourceTableColumns(srcName);
                    break block7;
                } else {
                    VDBContext context = this.getVDBContext();
                    try {
                        context.findResource(srcName);
                        this.listAllTables(srcName);
                    }
                    catch (Exception e) {
                        if (!this.listTableColumns(srcName)) {
                            this.printlnError(DQPToolsPlugin.UTIL.getString("VDBContext.noTable", (Object)srcName));
                        }
                        break block7;
                    }
                }
            }
            this.listVDB(ModelerCore.getModelEditor());
        }
        this.printHelp(DQPToolsPlugin.UTIL.getString("ListCommand.next_steps"));
        return true;
    }

    private String getActualSourceName(String srcName) {
        try {
            return this.getVDBContext().findResource(srcName).getURI().trimFileExtension().lastSegment();
        }
        catch (Throwable t) {
            if (srcName.equalsIgnoreCase("system")) {
                return SCHEMA_SYSTEM;
            }
            return srcName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listSystemModels() {
        String query = "select Name from System.Models WHERE Name IN ('System')  ORDER BY Name";
        DatabaseConnectionContext dcContext = this.toolShell.getDatabaseConnectionContext();
        try {
            Connection connection = dcContext.getConnection();
            if (connection == null) {
                this.printlnError(DQPToolsPlugin.UTIL.getString("ListCommand.error_vdb_connection", (Object)this.getVDBContext().getVDBName()));
                return;
            }
            Statement statement = dcContext.getStatement();
            ResultSet resultSet = statement.executeQuery(query);
            while (resultSet.next()) {
                this.printlnVerbose("  " + resultSet.getString(1) + ": System");
            }
            resultSet.close();
        }
        catch (SQLException e) {
            this.printlnError(DQPToolsPlugin.UTIL.getString("ListCommand.error_vdb_metadata", (Object)this.getVDBContext().getVDBName()));
            this.printlnSQLException(e);
        }
        catch (ClassNotFoundException e) {
            this.printlnException(e);
        }
        finally {
            dcContext.closeStatement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getTablesForSource(String source) {
        String query = "Select FullName from System.Groups where UCASE(ModelName) = '" + source + "' AND FullName" + " NOT IN (Select FullName from " + SCHEMA_GROUPS + " WHERE FullName LIKE '" + SCHEMA_ODBC + ".%'OR FullName LIKE '" + SCHEMA_JDBC + ".%') ORDER BY FullName";
        ArrayList<String> list = new ArrayList<String>();
        DatabaseConnectionContext dcContext = this.toolShell.getDatabaseConnectionContext();
        try {
            Connection connection = dcContext.getConnection();
            if (connection == null) {
                this.printlnError(DQPToolsPlugin.UTIL.getString("ListCommand.error_vdb_connection", (Object)this.getVDBContext().getVDBName()));
                ArrayList<String> arrayList = list;
                return arrayList;
            }
            Statement statement = dcContext.getStatement();
            ResultSet resultSet = statement.executeQuery(query);
            while (resultSet.next()) {
                list.add(resultSet.getString(1));
            }
            resultSet.close();
        }
        catch (SQLException e) {
            this.printlnError(DQPToolsPlugin.UTIL.getString("ListCommand.error_vdb_metadata", (Object)this.getVDBContext().getVDBName()));
            this.printlnSQLException(e);
        }
        catch (ClassNotFoundException e) {
            this.printlnException(e);
        }
        finally {
            dcContext.closeStatement();
        }
        return list;
    }

    private void listSourceTableColumns(String sourceName) {
        String source = this.getActualSourceName(sourceName);
        String query = "SELECT System.Elements.GroupFullName, System.Elements.Name, DataType, KeyType, System.Elements.Position FROM System.Elements LEFT OUTER JOIN System.KeyElements ON System.KeyElements.Name=System.Elements.Name AND System.Elements.GroupFullName=System.KeyElements.GroupFullName AND System.KeyElements.KeyType='Primary' Where System.Elements.ModelName='" + source + "'" + " AND " + SCHEMA_ELEMENTS_GROUPFULLNAME + " NOT IN (Select " + SCHEMA_ELEMENTS_GROUPFULLNAME + " from " + SCHEMA_ELEMENTS + " WHERE " + SCHEMA_ELEMENTS_GROUPFULLNAME + " LIKE '" + SCHEMA_ODBC + ".%' " + " OR " + SCHEMA_ELEMENTS_GROUPFULLNAME + " LIKE '" + SCHEMA_JDBC + ".%')" + " ORDER BY GroupFullName, Position";
        this.printlnVerbose(DQPToolsPlugin.UTIL.getString("ListCommand.contents_all", (Object)source));
        this.listAllTableColumns(query);
    }

    private boolean listTableColumns(String tableName) {
        String table = tableName.toUpperCase();
        String query = "SELECT System.Elements.GroupFullName, System.Elements.Name, DataType, KeyType, System.Elements.Position FROM System.Elements LEFT OUTER JOIN System.KeyElements ON System.KeyElements.Name=System.Elements.Name AND System.Elements.GroupFullName=System.KeyElements.GroupFullName AND System.KeyElements.KeyType='Primary' Where (UCASE(System.Elements.GroupFullName) LIKE '%." + table + "'" + " OR UCASE(" + SCHEMA_ELEMENTS_GROUPFULLNAME + ") = '" + table + "')" + " AND " + SCHEMA_ELEMENTS_GROUPFULLNAME + " NOT IN (Select " + SCHEMA_ELEMENTS_GROUPFULLNAME + " from " + SCHEMA_ELEMENTS + " WHERE " + SCHEMA_ELEMENTS_GROUPFULLNAME + " LIKE '" + SCHEMA_ODBC + ".%' " + " OR " + SCHEMA_ELEMENTS_GROUPFULLNAME + " LIKE '" + SCHEMA_JDBC + ".%')" + " ORDER BY GroupFullName, Position";
        return this.listAllTableColumns(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean listAllTableColumns(String query) {
        StringBuffer sb = new StringBuffer();
        boolean resultsFlag = false;
        DatabaseConnectionContext dcContext = this.toolShell.getDatabaseConnectionContext();
        try {
            Connection connection = dcContext.getConnection();
            if (connection == null) {
                this.printlnError(DQPToolsPlugin.UTIL.getString("ListCommand.error_vdb_connection", (Object)this.getVDBContext().getVDBName()));
                boolean bl = false;
                return bl;
            }
            Statement statement = dcContext.getStatement();
            ResultSet resultSet = statement.executeQuery(query);
            String tableName = "";
            while (resultSet.next()) {
                resultsFlag = true;
                if (!resultSet.getString(1).equalsIgnoreCase(tableName)) {
                    tableName = resultSet.getString(1);
                    sb.append(ToolShell.LINE_FEED);
                    sb.append("  " + tableName);
                    sb.append(ToolShell.LINE_FEED);
                }
                sb.append("    " + resultSet.getString(2) + ": " + resultSet.getString(3));
                if ("primary".equalsIgnoreCase(resultSet.getString(4))) {
                    sb.append(" - ");
                    sb.append(DQPToolsPlugin.UTIL.getString("ListCommand.pkey"));
                }
                sb.append(ToolShell.LINE_FEED);
            }
            sb.append(ToolShell.LINE_FEED);
            resultSet.close();
        }
        catch (SQLException e) {
            this.printlnError(DQPToolsPlugin.UTIL.getString("ListCommand.error_vdb_metadata", (Object)this.getVDBContext().getVDBName()));
            this.printlnSQLException(e);
        }
        catch (ClassNotFoundException e) {
            this.printlnException(e);
        }
        finally {
            dcContext.closeStatement();
        }
        this.printVerbose(sb.toString());
        return resultsFlag;
    }

    boolean listAllTables(String source) {
        boolean resultsFlag = false;
        StringBuffer sb = new StringBuffer();
        Iterator iter = this.getTablesForSource(source.toUpperCase()).iterator();
        if (iter.hasNext()) {
            this.printlnVerbose(DQPToolsPlugin.UTIL.getString("ListCommand.contents_tables", (Object)this.getActualSourceName(source)));
            resultsFlag = true;
            while (iter.hasNext()) {
                String table = iter.next().toString();
                sb.append("  " + table + ToolShell.LINE_FEED);
            }
        }
        this.printVerbose(sb.toString());
        return resultsFlag;
    }

    private void listVDB(ModelEditor editor) {
        try {
            VDBContext context = this.getVDBContext();
            this.listKnownVDBs(context);
            List importedSources = this.getImportedSources();
            this.printlnVerbose("\n" + DQPToolsPlugin.UTIL.getString("ListCommand.vdb_header", (Object)context.getVDBName()));
            this.listSystemModels();
            int resourceListings = 0;
            Resource[] resources = context.getResources();
            for (int i = 0; i < resources.length; ++i) {
                Resource resource = resources[i];
                JdbcSource source = JdbcManager.getJdbcSource(resource, this.toolShell);
                if (source == null) continue;
                ++resourceListings;
                String sourceName = resource.getURI().trimFileExtension().lastSegment();
                String sourceType = JdbcManager.getJdbcSourceType(source);
                boolean imported = this.isImported(sourceName, importedSources);
                this.printSource(sourceName, sourceType, imported);
            }
            if (resourceListings == 0) {
                this.printlnError(DQPToolsPlugin.UTIL.getString("ListCommand.no_sources"));
            }
        }
        catch (Exception err) {
            this.toolShell.printlnException(err);
        }
    }

    private void listKnownVDBs(VDBContext context) throws Exception {
        String text = ((MMShell)this.toolShell).getKnownVdbsText();
        if (text.length() == 0) {
            this.printlnVerbose("  " + DQPToolsPlugin.UTIL.getString("ListCommand.no_vdbs"));
        } else {
            this.printlnVerbose(text);
        }
    }

    private void printSource(String sourceName, String sourceType, boolean sourceImported) {
        String result = DQPToolsPlugin.UTIL.getString("ListCommand.output_source", (Object)sourceName, (Object)sourceType);
        if (!sourceImported) {
            result = result + " - " + DQPToolsPlugin.UTIL.getString("ListCommand.not_imported");
        }
        this.printlnVerbose(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getImportedSources() {
        String query = "select DISTINCT ModelName from System.Groups";
        ArrayList<String> sources = new ArrayList<String>();
        DatabaseConnectionContext dcContext = this.toolShell.getDatabaseConnectionContext();
        try {
            Connection connection = dcContext.getConnection();
            if (connection == null) {
                this.printlnError(DQPToolsPlugin.UTIL.getString("ListCommand.error_vdb_connection", (Object)this.getVDBContext().getVDBName()));
                ArrayList<String> arrayList = sources;
                return arrayList;
            }
            Statement statement = dcContext.getStatement();
            ResultSet resultSet = statement.executeQuery(query);
            while (resultSet.next()) {
                sources.add(resultSet.getString(1));
            }
            resultSet.close();
        }
        catch (SQLException e) {
            this.printlnError(DQPToolsPlugin.UTIL.getString("ListCommand.error_vdb_metadata", (Object)this.getVDBContext().getVDBName()));
            this.printlnSQLException(e);
        }
        catch (ClassNotFoundException e) {
            this.printlnException(e);
        }
        finally {
            dcContext.closeStatement();
        }
        return sources;
    }

    private boolean isImported(String sourceName, List importSources) {
        return importSources.contains(sourceName);
    }
}

