/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.tools.mmshell;

import com.metamatrix.common.util.VDBNameValidator;
import com.metamatrix.dqp.tools.DQPToolsPlugin;
import com.metamatrix.dqp.tools.mmshell.EmbeddedAdminCommandImpl;
import com.metamatrix.dqp.tools.mmshell.JdbcManager;
import com.metamatrix.dqp.tools.mmshell.VDBContext;
import com.metamatrix.metamodels.relational.Catalog;
import com.metamatrix.metamodels.relational.Column;
import com.metamatrix.metamodels.relational.Schema;
import com.metamatrix.metamodels.relational.Table;
import com.metamatrix.metamodels.relational.util.RelationalUtil;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import com.metamatrix.modeler.jdbc.JdbcSource;
import com.metamatrix.modeler.jdbc.relational.CostAnalyzer;
import com.metamatrix.modeler.jdbc.relational.CostAnalyzerFactory;
import com.metamatrix.modeler.jdbc.relational.impl.ColumnStatistics;
import com.metamatrix.modeler.jdbc.relational.impl.DefaultCostAnalyzerImpl;
import com.metamatrix.modeler.jdbc.relational.impl.TableStatistics;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;

public class StatsCommand
extends EmbeddedAdminCommandImpl {
    private static StatsCommand shared;

    public static StatsCommand get() {
        if (shared == null) {
            shared = new StatsCommand();
        }
        return shared;
    }

    public String getCommandName() {
        return DQPToolsPlugin.UTIL.getString("StatsCommand.commandName");
    }

    public String getLongHelp(List argList) {
        return DQPToolsPlugin.UTIL.getString("StatsCommand.longHelp");
    }

    public String getShortHelp() {
        return DQPToolsPlugin.UTIL.getString("StatsCommand.shortHelp");
    }

    public String getArgHelp() {
        return DQPToolsPlugin.UTIL.getString("StatsCommand.argHelp");
    }

    public boolean executeCommand(Iterator iterator) throws Exception {
        if (!this.verifyOpen()) {
            return true;
        }
        iterator.next();
        String srcName = this.getSourceName(iterator);
        if (srcName == null) {
            return true;
        }
        if (VDBNameValidator.isSourceNameReserved((String)srcName)) {
            this.printlnVerbose(DQPToolsPlugin.UTIL.getString("StatsCommand.reserved_source", (Object)srcName));
            return true;
        }
        String source = srcName;
        String table = null;
        int delimiterIndex = srcName.indexOf(46);
        if (delimiterIndex != -1) {
            table = srcName.substring(delimiterIndex + 1);
            source = srcName.substring(0, delimiterIndex);
        }
        if (this.retrieveAndSetStats(source, table)) {
            this.getVDBContext().activate();
            this.printlnVerbose(DQPToolsPlugin.UTIL.getString("StatsCommand.stats_done", (Object)srcName));
        }
        return true;
    }

    private boolean retrieveAndSetStats(String sourceName, String table) {
        try {
            Map tblStats;
            int tableNameDelimiterIndex;
            VDBContext context = this.getVDBContext();
            EmfResource resrc = (EmfResource)context.findResource(sourceName);
            JdbcSource jdbcSource = this.getJDBCSource((Resource)resrc);
            if (jdbcSource == null) {
                this.printlnError(DQPToolsPlugin.UTIL.getString("StatsCommand.cannot_find_jdbc_source"));
                return false;
            }
            List emfTables = RelationalUtil.findTables((Object)resrc);
            if (table != null && (tableNameDelimiterIndex = table.lastIndexOf(46)) != -1 && tableNameDelimiterIndex != table.length() - 1) {
                table = table.substring(tableNameDelimiterIndex + 1);
            }
            if ((tblStats = this.createTableInfos(emfTables, table)) != null && tblStats.size() > 0) {
                String pwd = context.getBindingProperty(sourceName, JdbcManager.PWD);
                CostAnalyzer costAnalyzer = CostAnalyzerFactory.getCostAnalyzerFactory().getCostAnalyzer(jdbcSource, pwd);
                DefaultCostAnalyzerImpl.setVDBContainer(context.getContainer());
                DefaultCostAnalyzerImpl.setConfigFolder(context.getConfigDirectory());
                costAnalyzer.collectStatistics(tblStats, (IProgressMonitor)new NullProgressMonitor());
                this.populateEmfColumnStatistics(emfTables, tblStats);
                context.saveResource(resrc);
            }
        }
        catch (Exception e) {
            this.printlnException(e);
            return false;
        }
        return true;
    }

    private JdbcSource getJDBCSource(Resource resource) throws Exception {
        JdbcSource src = null;
        Iterator iter = resource.getContents().iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof JdbcSource)) continue;
            src = (JdbcSource)obj;
            break;
        }
        return src;
    }

    private Map createTableInfos(List emfTables, String tableNameFilter) {
        if (emfTables != null) {
            HashMap<String, TableStatistics> tableInfos = new HashMap<String, TableStatistics>();
            Iterator tblIt = emfTables.iterator();
            while (tblIt.hasNext()) {
                Table emfTable = (Table)tblIt.next();
                if (emfTable.getNameInSource() == null || tableNameFilter != null && !tableNameFilter.equalsIgnoreCase(emfTable.getNameInSource())) continue;
                Catalog catalog = emfTable.getCatalog();
                String catalogName = catalog == null || catalog.getNameInSource() == null ? null : this.unQualifyName(catalog.getNameInSource());
                Schema schema = emfTable.getSchema();
                String schemaName = schema == null || schema.getNameInSource() == null ? null : this.unQualifyName(schema.getNameInSource());
                String tblName = emfTable.getNameInSource();
                TableStatistics tableInfo = new TableStatistics(catalogName, schemaName, tblName);
                Map columnInfos = tableInfo.getColumnStats();
                Iterator colIt = emfTable.getColumns().iterator();
                while (colIt.hasNext()) {
                    Column emfColumn = (Column)colIt.next();
                    if (emfColumn.getNameInSource() == null) continue;
                    String colName = this.unQualifyName(emfColumn.getNameInSource());
                    ColumnStatistics columnInfo = new ColumnStatistics(colName);
                    columnInfos.put(colName, columnInfo);
                }
                tableInfos.put(this.unQualifyName(tblName), tableInfo);
            }
            if (tableInfos.isEmpty()) {
                throw new IllegalArgumentException(DQPToolsPlugin.UTIL.getString("StatsCommand.no_such_tbl", (Object)tableNameFilter));
            }
            return tableInfos;
        }
        return null;
    }

    private void populateEmfColumnStatistics(List emfTables, Map tableInfos) {
        Iterator itTable = emfTables.iterator();
        while (itTable.hasNext()) {
            TableStatistics tableInfo;
            Table emfTable = (Table)itTable.next();
            if (emfTable.getNameInSource() == null || (tableInfo = (TableStatistics)tableInfos.get(this.unQualifyName(emfTable.getNameInSource()))) == null) continue;
            emfTable.setCardinality(tableInfo.getCardinality());
            Map columnInfos = tableInfo.getColumnStats();
            Iterator itColumn = emfTable.getColumns().iterator();
            while (itColumn.hasNext()) {
                ColumnStatistics columnInfo;
                Column emfColumn = (Column)itColumn.next();
                if (emfColumn.getNameInSource() == null || (columnInfo = (ColumnStatistics)columnInfos.get(this.unQualifyName(emfColumn.getNameInSource()))) == null) continue;
                emfColumn.setMinimumValue(columnInfo.getMin());
                emfColumn.setMaximumValue(columnInfo.getMax());
                emfColumn.setNullValueCount(columnInfo.getNumNullValues());
                emfColumn.setDistinctValueCount(columnInfo.getNumDistinctValues());
            }
        }
    }

    private String unQualifyName(String qualifiedName) {
        return qualifiedName.substring(qualifiedName.lastIndexOf(46) + 1, qualifiedName.length());
    }
}

