/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.compare.processor;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.modeler.compare.CompareFactory;
import com.metamatrix.modeler.compare.DifferenceDescriptor;
import com.metamatrix.modeler.compare.DifferenceGuidelines;
import com.metamatrix.modeler.compare.DifferenceProcessor;
import com.metamatrix.modeler.compare.DifferenceReport;
import com.metamatrix.modeler.compare.DifferenceType;
import com.metamatrix.modeler.compare.ModelerComparePlugin;
import com.metamatrix.modeler.compare.PropertyDifference;
import com.metamatrix.modeler.compare.impl.CompareFactoryImpl;
import com.metamatrix.modeler.compare.processor.NullDifferenceGuidelines;
import com.metamatrix.modeler.compare.selector.ModelSelector;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.compare.EObjectMatcher;
import com.metamatrix.modeler.core.compare.EObjectMatcherCache;
import com.metamatrix.modeler.core.compare.EObjectMatcherFactory;
import com.metamatrix.modeler.core.compare.MappingProducer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.MappingFactory;
import org.eclipse.emf.mapping.MappingHelper;
import org.eclipse.emf.mapping.impl.MappingFactoryImpl;
import org.w3c.dom.Node;

public class DifferenceProcessorImpl
implements DifferenceProcessor {
    private static final String PLUGINID = "com.metamatrix.modeler.compare";
    protected static final int PROCESSOR_ALREADY_CLOSED = 50001;
    protected static final int ERROR_LOADING_RESOURCES = 50002;
    protected static final int ERROR_CREATING_MAPPING = 50003;
    protected static final int ERROR_COMPUTING_DIFFERENCES = 50004;
    protected static final int MISSING_MAPPING_ADAPTERS = 50005;
    protected static final int NO_PROBLEMS = 50010;
    protected static final int HAS_WARNINGS = 50011;
    protected static final int HAS_ERRORS = 50012;
    protected static final int HAS_WARNINGS_AND_ERRORS = 50013;
    protected static final int NO_WARNINGS_AND_ERRORS = 50014;
    protected static final int AMOUNT_OF_WORK_FOR_LOADING_RESOURCES = 300;
    protected static final int AMOUNT_OF_WORK_FOR_MAPPING_RESOURCES = 1000;
    protected static final int AMOUNT_OF_WORK_FOR_COMUTING_DIFFERENCES = 400;
    protected static final int AMOUNT_OF_WORK_FOR_CREATING_RESULTS = 100;
    protected static final Collection DOM_FEATURE_NAMES = new ArrayList();
    private final ModelSelector beforeSelector;
    private final ModelSelector afterSelector;
    private CompareFactory compareFactory;
    private MappingFactory mappingFactory;
    private DifferenceReport report;
    private boolean closed;
    private final List matcherFactories;
    private final HashMap inputsToObjects;
    private int totalAdditions;
    private int totalDeletions;
    private int totalChanges;
    private DifferenceGuidelines guidelines;
    private MappingProducer mappingProducer;
    private boolean isMultiModel;

    public DifferenceProcessorImpl(ModelSelector selector) {
        this(selector, selector);
    }

    public DifferenceProcessorImpl(ModelSelector beforeSelector, ModelSelector afterSelector) {
        this(beforeSelector, afterSelector, null);
    }

    public DifferenceProcessorImpl(ModelSelector beforeSelector, ModelSelector afterSelector, HashMap mappings) {
        DOM_FEATURE_NAMES.add("description");
        DOM_FEATURE_NAMES.add("applicationInformation");
        DOM_FEATURE_NAMES.add("userInformation");
        ArgCheck.isNotNull((Object)beforeSelector);
        ArgCheck.isNotNull((Object)afterSelector);
        this.beforeSelector = beforeSelector;
        this.afterSelector = afterSelector;
        this.closed = false;
        this.compareFactory = new CompareFactoryImpl();
        this.mappingFactory = new MappingFactoryImpl();
        this.matcherFactories = new ArrayList();
        this.guidelines = NullDifferenceGuidelines.INSTANCE;
        if (mappings == null) {
            this.inputsToObjects = new HashMap();
        } else {
            this.inputsToObjects = mappings;
            this.isMultiModel = true;
        }
    }

    public DifferenceGuidelines getDifferenceGuidelines() {
        return this.guidelines;
    }

    public void setDifferenceGuidelines(DifferenceGuidelines guidelines) {
        this.guidelines = guidelines != null ? guidelines : NullDifferenceGuidelines.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus execute(IProgressMonitor progressMonitor) {
        IStatus status;
        String msg;
        LinkedList<IStatus> problems;
        IProgressMonitor monitor;
        block37: {
            String analysisSubTask;
            Object[] params;
            if (this.closed) {
                int code = 50001;
                String msg2 = ModelerComparePlugin.Util.getString("DifferenceProcessorImpl.The_processor_has_already_been_closed_and_cannot_be_reused");
                return new Status(4, PLUGINID, 50001, msg2, null);
            }
            monitor = progressMonitor != null ? progressMonitor : new NullProgressMonitor();
            Object[] taskParams = new Object[]{this.beforeSelector.getLabel(), this.afterSelector.getLabel()};
            String taskName = ModelerComparePlugin.Util.getString("DifferenceProcessorImpl.execute_task_name", taskParams);
            int totalWork = 1800;
            monitor.beginTask(taskName, 1800);
            problems = new LinkedList<IStatus>();
            try {
                this.report = this.createDifferenceReport();
            }
            finally {
                monitor.worked(100);
            }
            List beforeRoots = null;
            List afterRoots = null;
            ModelSelector selector = this.beforeSelector;
            try {
                String loadingSubTask = ModelerComparePlugin.Util.getString("DifferenceProcessorImpl.Loading_resources_subtask_name");
                monitor.subTask(loadingSubTask);
                selector.open();
                beforeRoots = selector.getRootObjects();
                selector = this.afterSelector;
                selector.open();
                afterRoots = selector.getRootObjects();
            }
            catch (ModelerCoreException e) {
                params = new Object[]{selector.getLabel(), e.getMessage()};
                msg = ModelerComparePlugin.Util.getString("DifferenceProcessorImpl.Error_loading_resource", params);
                status = this.newError(50002, msg, e);
                problems.add(status);
            }
            finally {
                monitor.worked(300);
            }
            try {
                analysisSubTask = ModelerComparePlugin.Util.getString("DifferenceProcessorImpl.Performing_mapping");
                monitor.subTask(analysisSubTask);
                if (beforeRoots != null && afterRoots != null) {
                    Mapping mapping = this.createMapping(beforeRoots, afterRoots, problems, monitor, analysisSubTask);
                    this.report.setMapping(mapping);
                }
            }
            catch (Throwable e) {
                params = new Object[]{e.getMessage()};
                msg = ModelerComparePlugin.Util.getString("DifferenceProcessorImpl.Error_performing_mapping", params);
                status = this.newError(50003, msg, e);
                problems.add(status);
            }
            finally {
                monitor.worked(1000);
            }
            try {
                Object var17_27;
                block36: {
                    try {
                        if (this.report.getMapping() == null) break block36;
                        this.totalAdditions = 0;
                        this.totalChanges = 0;
                        this.totalDeletions = 0;
                        analysisSubTask = ModelerComparePlugin.Util.getString("DifferenceProcessorImpl.Computing_differences");
                        monitor.subTask(analysisSubTask);
                        Mapping rootMapping = this.report.getMapping();
                        if (rootMapping != null) {
                            this.addDifferencesInTransaction(rootMapping, monitor, analysisSubTask);
                        }
                        this.report.setTotalAdditions(this.totalAdditions);
                        this.report.setTotalChanges(this.totalChanges);
                        this.report.setTotalDeletions(this.totalDeletions);
                    }
                    catch (Throwable e) {
                        params = new Object[]{e.getMessage()};
                        msg = ModelerComparePlugin.Util.getString("DifferenceProcessorImpl.Error_computing_differences", params);
                        status = this.newError(50004, msg, e);
                        problems.add(status);
                        var17_27 = null;
                        if (!this.isMultiModel) {
                            this.inputsToObjects.clear();
                        }
                        this.totalAdditions = 0;
                        this.totalChanges = 0;
                        this.totalDeletions = 0;
                        monitor.worked(400);
                        break block37;
                    }
                }
                var17_27 = null;
                if (!this.isMultiModel) {
                    this.inputsToObjects.clear();
                }
                this.totalAdditions = 0;
                this.totalChanges = 0;
                this.totalDeletions = 0;
            }
            catch (Throwable throwable) {
                Object var17_28 = null;
                if (!this.isMultiModel) {
                    this.inputsToObjects.clear();
                }
                this.totalAdditions = 0;
                this.totalChanges = 0;
                this.totalDeletions = 0;
                monitor.worked(400);
                throw throwable;
            }
            monitor.worked(400);
        }
        IStatus resultStatus = null;
        try {
            String msg2;
            String analysisSubTask = ModelerComparePlugin.Util.getString("DifferenceProcessorImpl.Analyzing_problems");
            monitor.subTask(analysisSubTask);
            if (problems.isEmpty()) {
                msg = ModelerComparePlugin.Util.getString("DifferenceProcessorImpl.Execution_completed");
                resultStatus = status = new Status(0, PLUGINID, 50010, msg, null);
                return resultStatus;
            }
            if (problems.size() == 1) {
                resultStatus = (IStatus)problems.get(0);
                return resultStatus;
            }
            int numErrors = 0;
            int numWarnings = 0;
            Iterator iter = problems.iterator();
            while (iter.hasNext()) {
                IStatus aStatus = (IStatus)iter.next();
                if (aStatus.getSeverity() == 2) {
                    ++numWarnings;
                    continue;
                }
                if (aStatus.getSeverity() != 4) continue;
                ++numErrors;
            }
            IStatus[] statusArray = problems.toArray(new IStatus[problems.size()]);
            if (numWarnings != 0 && numErrors == 0) {
                Object[] params = new Object[]{new Integer(numWarnings)};
                String msg3 = ModelerComparePlugin.Util.getString("DifferenceProcessorImpl.Execution_resulted_in_warnings", params);
                resultStatus = new MultiStatus(PLUGINID, 50011, statusArray, msg3, null);
                return resultStatus;
            }
            if (numWarnings == 0 && numErrors != 0) {
                Object[] params = new Object[]{new Integer(numErrors)};
                msg2 = ModelerComparePlugin.Util.getString("DifferenceProcessorImpl.Execution_resulted_in_errors", params);
                resultStatus = new MultiStatus(PLUGINID, 50012, statusArray, msg2, null);
                return resultStatus;
            }
            if (numWarnings != 0 && numErrors != 0) {
                Object[] params = new Object[]{new Integer(numWarnings), new Integer(numErrors)};
                msg2 = ModelerComparePlugin.Util.getString("DifferenceProcessorImpl.Execution_resulted_in_warnings_and_errors", params);
                resultStatus = new MultiStatus(PLUGINID, 50013, statusArray, msg2, null);
                return resultStatus;
            }
            String msg4 = ModelerComparePlugin.Util.getString("DifferenceProcessorImpl.Execution_completed_with_no_warnings_or_errors");
            resultStatus = new MultiStatus(PLUGINID, 50014, statusArray, msg4, null);
            return resultStatus;
        }
        finally {
            monitor.worked(100);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDifferencesInTransaction(Mapping rootMapping, IProgressMonitor monitor, String analysisSubTask) {
        boolean started = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Add Differences", (Object)this);
        boolean succeeded = false;
        try {
            this.addDifferences(rootMapping, monitor, analysisSubTask);
            succeeded = true;
        }
        catch (Exception ex) {
            ModelerCore.Util.log(4, (Throwable)ex, ex.getMessage());
        }
        finally {
            if (started && succeeded) {
                ModelerCore.commitTxn();
            }
        }
    }

    public DifferenceReport getDifferenceReport() {
        return this.report;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.report = null;
        if (this.beforeSelector != null) {
            this.beforeSelector.close();
        }
        if (this.afterSelector != null) {
            this.afterSelector.close();
        }
        this.closed = true;
    }

    protected IStatus newWarning(int code, String msg, Throwable t) {
        return new Status(2, PLUGINID, code, msg, t);
    }

    protected IStatus newInfo(int code, String msg, Throwable t) {
        return new Status(1, PLUGINID, code, msg, t);
    }

    protected IStatus newError(int code, String msg, Throwable t) {
        return new Status(4, PLUGINID, code, msg, t);
    }

    protected IStatus newOk(int code, String msg, Throwable t) {
        return new Status(0, PLUGINID, code, msg, t);
    }

    protected Mapping createMapping(List beforeSiblings, List afterSiblings, List problems, IProgressMonitor monitor, String subtaskPrefix) {
        this.mappingProducer = new MappingProducer(this.inputsToObjects);
        EObjectMatcherCache cache = this.mappingProducer.getEObjectMatcherCache();
        cache.addEObjectMatcherFactories(this.matcherFactories);
        this.doAddMappingAdapters(cache);
        if (cache.getEObjectMatcherFactories().isEmpty()) {
            String msg = ModelerComparePlugin.Util.getString("DifferenceProcessorImpl.No_mapping_adapters");
            IStatus status = this.newError(50005, msg, null);
            problems.add(status);
            return null;
        }
        MappingFactory factory = this.getMappingFactory();
        boolean recursive = true;
        Mapping mapping = this.mappingProducer.createMappings(beforeSiblings, afterSiblings, true, factory, monitor);
        DifferenceDescriptor rootDesc = this.getCompareFactory().createDifferenceDescriptor();
        mapping.setHelper((MappingHelper)rootDesc);
        rootDesc.setType(DifferenceType.CHANGE_BELOW_LITERAL);
        return mapping;
    }

    protected void addDifferences(Mapping mapping, IProgressMonitor monitor, String subtaskPrefix) {
        LinkedList<Mapping> mappingsToRemove = new LinkedList<Mapping>();
        Iterator iter = mapping.getNested().iterator();
        while (iter.hasNext()) {
            Mapping nestedMapping = (Mapping)iter.next();
            if (this.includeInReport(nestedMapping)) {
                EList inputs = nestedMapping.getInputs();
                EList outputs = nestedMapping.getOutputs();
                if (inputs.isEmpty()) {
                    if (!outputs.isEmpty()) {
                        this.setDescriptor(nestedMapping, DifferenceType.ADDITION_LITERAL);
                        ++this.totalAdditions;
                    }
                } else if (outputs.isEmpty()) {
                    this.setDescriptor(nestedMapping, DifferenceType.DELETION_LITERAL);
                    ++this.totalDeletions;
                } else {
                    DifferenceDescriptor desc = this.setDescriptor(nestedMapping, DifferenceType.NO_CHANGE_LITERAL);
                    boolean changed = this.computeFeatureDifferences(desc, (List)inputs, (List)outputs);
                    if (changed) {
                        desc.setType(DifferenceType.CHANGE_LITERAL);
                        ++this.totalChanges;
                    }
                }
                this.addDifferences(nestedMapping, monitor, subtaskPrefix);
                DifferenceDescriptor descriptor = (DifferenceDescriptor)mapping.getHelper();
                if (((DifferenceDescriptor)nestedMapping.getHelper()).getType() == DifferenceType.NO_CHANGE_LITERAL || descriptor.getType() != DifferenceType.NO_CHANGE_LITERAL) continue;
                descriptor.setType(DifferenceType.CHANGE_BELOW_LITERAL);
                continue;
            }
            mappingsToRemove.add(nestedMapping);
        }
        Iterator iterator = mappingsToRemove.iterator();
        while (iterator.hasNext()) {
            Mapping nestedMapping = (Mapping)iterator.next();
            nestedMapping.setNestedIn(null);
        }
    }

    protected boolean includeInReport(Mapping nestedMapping) {
        EList inputs = nestedMapping.getInputs();
        EList outputs = nestedMapping.getOutputs();
        EList objects = null;
        if (outputs != null && outputs.size() != 0) {
            objects = outputs;
        }
        if (inputs != null && inputs.size() != 0) {
            objects = inputs;
        }
        if (objects != null) {
            Iterator iter = objects.iterator();
            while (iter.hasNext()) {
                EObject obj = (EObject)iter.next();
                if (this.includeInReport(obj)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean includeInReport(EObject eobject) {
        EClass eclass = eobject.eClass();
        EPackage epkg = eclass.getEPackage();
        if (!this.guidelines.includeMetamodel(epkg.getNsURI())) {
            return false;
        }
        return this.guidelines.includeMetaclass(eclass);
    }

    protected boolean includeInReport(EStructuralFeature feature) {
        if (!feature.isChangeable()) {
            return false;
        }
        return this.guidelines.includeFeature(feature);
    }

    protected DifferenceDescriptor setDescriptor(Mapping mapping, DifferenceType type) {
        MappingHelper currentHelper = mapping.getHelper();
        DifferenceDescriptor desc = null;
        if (currentHelper == null) {
            desc = this.getCompareFactory().createDifferenceDescriptor();
            desc.setType(type);
            mapping.setHelper((MappingHelper)desc);
        } else if (currentHelper instanceof DifferenceDescriptor) {
            desc = (DifferenceDescriptor)currentHelper;
            if (desc.getType().getValue() == 3) {
                desc.getPropertyDifferences().clear();
            }
            desc.setType(type);
        } else {
            Iterator iter = currentHelper.getNested().iterator();
            while (iter.hasNext()) {
                MappingHelper childHelper = (MappingHelper)iter.next();
                if (!(childHelper instanceof DifferenceDescriptor)) continue;
                desc = (DifferenceDescriptor)currentHelper;
            }
            if (desc == null) {
                desc = this.getCompareFactory().createDifferenceDescriptor();
                desc.setType(type);
                currentHelper.getNested().add((Object)desc);
            }
        }
        return desc;
    }

    protected boolean computeFeatureDifferences(DifferenceDescriptor descriptor, List inputs, List outputs) {
        boolean changed = false;
        if (inputs.size() == 1 && outputs.size() == 1) {
            EObject input = (EObject)inputs.get(0);
            EObject output = (EObject)outputs.get(0);
            changed = this.computeFeatureDifferences(descriptor, input, output);
        }
        return changed;
    }

    protected boolean computeFeatureDifferences(DifferenceDescriptor descriptor, EObject input, EObject output) {
        EClass eclass = input.eClass();
        boolean changed = false;
        EList features = eclass.getEAllStructuralFeatures();
        Iterator iter = features.iterator();
        while (iter.hasNext()) {
            EStructuralFeature feature = (EStructuralFeature)iter.next();
            if (!this.includeInReport(feature) || !(feature instanceof EAttribute) && (((EReference)feature).isContainment() || ((EReference)feature).isContainer())) continue;
            Object inputValue = input.eGet(feature);
            Object outputValue = output.eGet(feature);
            boolean sameValue = feature.isMany() ? this.isEqual(feature, (EList)inputValue, (EList)outputValue) : this.isEqual(feature, inputValue, outputValue);
            if (sameValue) continue;
            PropertyDifference diff = this.getCompareFactory().createPropertyDifference();
            diff.setAffectedFeature(feature);
            diff.setDescriptor(descriptor);
            diff.setNewValue(outputValue);
            diff.setOldValue(inputValue);
            changed = true;
        }
        return changed;
    }

    protected boolean isEqual(EStructuralFeature feature, Object object1, Object object2) {
        if (object1 == null) {
            return object2 == null;
        }
        if (object2 == null) {
            return false;
        }
        if (feature instanceof EReference) {
            EObject expectedOutput = (EObject)this.inputsToObjects.get(object1);
            if (!object2.equals(expectedOutput)) {
                URI uri1 = EcoreUtil.getURI((EObject)object1);
                URI uri2 = EcoreUtil.getURI((EObject)object2);
                if (uri1 != null && uri2 != null && uri1.equals((Object)uri2)) {
                    return true;
                }
                if (this.mappingProducer != null) {
                    EReference reference = (EReference)feature;
                    ArrayList<Object> object1List = new ArrayList<Object>(1);
                    ArrayList<Object> object2List = new ArrayList<Object>(1);
                    object1List.add(object1);
                    object2List.add(object2);
                    List matchers = this.mappingProducer.getEObjectMatcherCache().getEObjectMatchers(reference);
                    Mapping temp = this.mappingFactory.createMapping();
                    Iterator iter = matchers.iterator();
                    while (iter.hasNext()) {
                        EObjectMatcher matcher = (EObjectMatcher)iter.next();
                        matcher.addMappings(reference, object1List, object2List, temp, this.mappingFactory);
                        if (!object1List.isEmpty()) continue;
                        return true;
                    }
                }
                return false;
            }
            return true;
        }
        if (object1 instanceof Node && object2 instanceof Node) {
            if (DOM_FEATURE_NAMES.contains(feature.getName())) {
                String txt1 = this.getChildText((Node)object1);
                String txt2 = this.getChildText((Node)object2);
                boolean txtMatch = txt1 == null ? txt2 == null : txt1.equals(txt2);
                return txtMatch;
            }
            return true;
        }
        return object1.equals(object2);
    }

    protected boolean isEqual(EStructuralFeature feature, EList list1, EList list2) {
        int list1Size = list1.size();
        int list2Size = list2.size();
        if (list1Size == 0 && list2Size == 0) {
            return true;
        }
        if (list1Size != list2Size) {
            return false;
        }
        Iterator iter1 = list1.iterator();
        Iterator iter2 = list2.iterator();
        while (iter2.hasNext()) {
            Object obj2;
            Object obj1 = iter1.next();
            boolean valuesAreEqual = this.isEqual(feature, obj1, obj2 = iter2.next());
            if (valuesAreEqual) continue;
            return false;
        }
        return true;
    }

    private String getChildText(Node node) {
        if (node == null) {
            return null;
        }
        StringBuffer str = new StringBuffer();
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            short type = child.getNodeType();
            if (type == 3) {
                str.append(child.getNodeValue());
                continue;
            }
            if (type != 4) continue;
            str.append(this.getChildText(child));
        }
        return str.toString();
    }

    protected DifferenceReport createDifferenceReport() {
        DifferenceReport reportObj = this.getCompareFactory().createDifferenceReport();
        long now = System.currentTimeMillis();
        String sourceUri = this.beforeSelector.getUri().toString();
        String resultUri = this.afterSelector.getUri().toString();
        reportObj.setAnalysisTime(now);
        reportObj.setSourceUri(sourceUri);
        reportObj.setResultUri(resultUri);
        String label = this.beforeSelector.getLabel();
        if (label != null && label.trim().length() != 0) {
            reportObj.setTitle(label);
        }
        return reportObj;
    }

    public CompareFactory getCompareFactory() {
        return this.compareFactory;
    }

    public MappingFactory getMappingFactory() {
        return this.mappingFactory;
    }

    public void setCompareFactory(CompareFactory factory) {
        this.compareFactory = factory;
    }

    public void setMappingFactory(MappingFactory factory) {
        this.mappingFactory = factory;
    }

    public List getEObjectMatcherFactories() {
        return this.matcherFactories;
    }

    public synchronized void addEObjectMatcherFactories(List factories) {
        Iterator iter = factories.iterator();
        while (iter.hasNext()) {
            EObjectMatcherFactory factory;
            Object obj = iter.next();
            if (!(obj instanceof EObjectMatcherFactory) || this.matcherFactories.contains(factory = (EObjectMatcherFactory)obj)) continue;
            this.matcherFactories.add(factory);
        }
    }

    protected void doAddMappingAdapters(EObjectMatcherCache cache) {
    }

    public ModelSelector getAfterSelector() {
        return this.afterSelector;
    }

    public ModelSelector getBeforeSelector() {
        return this.beforeSelector;
    }

    public boolean isMultiModel() {
        return this.isMultiModel;
    }
}

