/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.jdbc.relational;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.metamodels.relational.RelationalPackage;
import com.metamatrix.modeler.internal.jdbc.relational.ModelerJdbcRelationalConstants;
import com.metamatrix.modeler.jdbc.metadata.JdbcCatalog;
import com.metamatrix.modeler.jdbc.metadata.JdbcNode;
import com.metamatrix.modeler.jdbc.metadata.JdbcProcedure;
import com.metamatrix.modeler.jdbc.metadata.JdbcSchema;
import com.metamatrix.modeler.jdbc.metadata.JdbcTable;
import com.metamatrix.modeler.jdbc.relational.JdbcNodeToRelationalMapping;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;

public class JdbcNodeToRelationalMappingImpl
implements JdbcNodeToRelationalMapping {
    public static final String UBIQUITOUS_VIEW_NAME = "View";
    public static final String DEFAULT_VIEW_NAME = ModelerJdbcRelationalConstants.Util.getString("JdbcNodeToRelationalMappingImpl.ViewTableType");
    private final Map tableTypeNameToEClassName = new HashMap();
    private final Map upperTableTypeNameToEClassName = new HashMap();

    public JdbcNodeToRelationalMappingImpl() {
        EClass viewClass = this.findClassifierById(7);
        String viewClassName = viewClass.getName();
        this.setRelationalClassForJdbcTableType(UBIQUITOUS_VIEW_NAME, viewClassName);
        this.setRelationalClassForJdbcTableType(DEFAULT_VIEW_NAME, viewClassName);
    }

    public EClass getRelationalClassForJdbcNode(JdbcNode jdbcNode) {
        ArgCheck.isNotNull((Object)jdbcNode);
        if (jdbcNode instanceof JdbcCatalog) {
            return this.findClassifierById(8);
        }
        if (jdbcNode instanceof JdbcSchema) {
            return this.findClassifierById(2);
        }
        if (jdbcNode instanceof JdbcProcedure) {
            return this.findClassifierById(9);
        }
        if (jdbcNode instanceof JdbcTable) {
            EClassifier eClassForTypeName;
            String typeName = jdbcNode.getTypeName();
            String eClassName = this.getRelationalClassForJdbcTableType(typeName);
            if (eClassName != null && (eClassForTypeName = RelationalPackage.eINSTANCE.getEClassifier(eClassName)) != null && eClassForTypeName instanceof EClass) {
                return (EClass)eClassForTypeName;
            }
            return this.findClassifierById(0);
        }
        return null;
    }

    public void setRelationalClassForJdbcTableType(String tableType, String eClassName) {
        ArgCheck.isNotNull((Object)tableType);
        ArgCheck.isNotNull((Object)eClassName);
        ArgCheck.isNotZeroLength((String)eClassName);
        this.tableTypeNameToEClassName.put(tableType, eClassName);
        this.upperTableTypeNameToEClassName.put(tableType.toUpperCase(), eClassName);
    }

    public String getRelationalClassForJdbcTableType(String tableType) {
        if (tableType == null) {
            return null;
        }
        String exactMatch = (String)this.tableTypeNameToEClassName.get(tableType);
        if (exactMatch != null) {
            return exactMatch;
        }
        return (String)this.upperTableTypeNameToEClassName.get(tableType.toUpperCase());
    }

    protected EClass findClassifierById(int classifierId) {
        Iterator iter = RelationalPackage.eINSTANCE.getEClassifiers().iterator();
        while (iter.hasNext()) {
            EClassifier classifier = (EClassifier)iter.next();
            if (classifier.getClassifierID() != classifierId || !(classifier instanceof EClass)) continue;
            return (EClass)classifier;
        }
        return null;
    }
}

