/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.jdbc.metadata.impl;

import com.metamatrix.modeler.jdbc.JdbcException;
import com.metamatrix.modeler.jdbc.JdbcPlugin;
import com.metamatrix.modeler.jdbc.metadata.JdbcDatabase;
import com.metamatrix.modeler.jdbc.metadata.JdbcNode;
import com.metamatrix.modeler.jdbc.metadata.JdbcProcedureType;
import com.metamatrix.modeler.jdbc.metadata.impl.JdbcNodeImpl;
import com.metamatrix.modeler.jdbc.metadata.impl.JdbcProcedureImpl;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;

public class JdbcProcedureTypeImpl
extends JdbcNodeImpl
implements JdbcProcedureType {
    public JdbcProcedureTypeImpl(JdbcNode parent, String procTerm) {
        super(108, procTerm, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected JdbcNode[] computeChildren() throws JdbcException {
        DatabaseMetaData metadata = this.getJdbcDatabase().getDatabaseMetaData();
        ArrayList<JdbcProcedureImpl> children = new ArrayList<JdbcProcedureImpl>();
        String schemaName = JdbcProcedureTypeImpl.getSchemaName(this);
        String catalogName = JdbcProcedureTypeImpl.getCatalogName(this);
        ResultSet resultSet = null;
        resultSet = metadata.getProcedures(catalogName, schemaName, "%");
        while (resultSet.next()) {
            String procName = resultSet.getString(3);
            String remarks = resultSet.getString(7);
            short procType = resultSet.getShort(8);
            JdbcProcedureImpl proc = new JdbcProcedureImpl(this, procName);
            proc.setRemarks(remarks);
            proc.setProcedureType(procType);
            children.add(proc);
        }
        Object var11_13 = null;
        if (resultSet == null) return children.toArray(new JdbcNode[children.size()]);
        try {
            resultSet.close();
            return children.toArray(new JdbcNode[children.size()]);
        }
        catch (SQLException e) {
            JdbcPlugin.Util.log((Throwable)e);
        }
        return children.toArray(new JdbcNode[children.size()]);
        {
            catch (Throwable t) {
                Object[] params = new Object[]{metadata.getClass().getName(), this.getJdbcDatabase()};
                String msg = JdbcPlugin.Util.getString("JdbcProcedureTypeImpl.Unexpected_exception_while_calling_getProcedures()_and_processing_results", params);
                JdbcPlugin.Util.log(2, t, msg);
                Object var11_14 = null;
                if (resultSet == null) return children.toArray(new JdbcNode[children.size()]);
                try {
                    resultSet.close();
                    return children.toArray(new JdbcNode[children.size()]);
                }
                catch (SQLException e) {
                    JdbcPlugin.Util.log((Throwable)e);
                }
                return children.toArray(new JdbcNode[children.size()]);
            }
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            if (resultSet == null) throw throwable;
            try {
                resultSet.close();
                throw throwable;
            }
            catch (SQLException e) {
                JdbcPlugin.Util.log((Throwable)e);
            }
            throw throwable;
        }
    }

    public String getTypeName() {
        return JdbcPlugin.Util.getString("JdbcProcedureTypeImpl.ProcedureTypeName");
    }

    public String getFullyQualifiedName() {
        return this.getParent().getFullyQualifiedName();
    }

    public IPath getPathInSource() {
        return null;
    }

    public IPath getPathInSource(boolean includeCatalog, boolean includeSchema) {
        return null;
    }

    public JdbcNode getParentDatabaseObject(boolean includeCatalog, boolean includeSchema) {
        return null;
    }

    public boolean isDatabaseObject() {
        return false;
    }

    public JdbcDatabase getJdbcDatabase() {
        return this.getParent().getJdbcDatabase();
    }
}

