/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.jdbc.relational.impl;

import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.internal.jdbc.JdbcManagerImpl;
import com.metamatrix.modeler.internal.jdbc.relational.ModelerJdbcRelationalConstants;
import com.metamatrix.modeler.internal.jdbc.relational.util.JdbcRelationalUtil;
import com.metamatrix.modeler.jdbc.JdbcManager;
import com.metamatrix.modeler.jdbc.JdbcSource;
import com.metamatrix.modeler.jdbc.relational.CostAnalyzer;
import com.metamatrix.modeler.jdbc.relational.JdbcRelationalPlugin;
import com.metamatrix.modeler.jdbc.relational.impl.ColumnStatistics;
import com.metamatrix.modeler.jdbc.relational.impl.TableStatistics;
import java.io.File;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class DefaultCostAnalyzerImpl
implements CostAnalyzer {
    protected JdbcSource src;
    protected String password;
    protected PrintStream outputStream;
    protected Connection connection;
    private static Container vdbContainer;
    private static File configFolder;

    public DefaultCostAnalyzerImpl(JdbcSource jdbcSource, String password) {
        this.src = jdbcSource;
        this.password = password;
    }

    public void setOutputStream(PrintStream outputStream) {
        this.outputStream = outputStream;
    }

    protected void log(String message) {
        if (this.outputStream != null) {
            this.outputStream.println(message);
        }
    }

    protected void connect() throws Exception {
        if (this.connection == null) {
            JdbcManager mgr = JdbcRelationalPlugin.getDefault() == null ? JdbcManagerImpl.create(ModelerJdbcRelationalConstants.Util.getString("JdbcManager.name"), configFolder, vdbContainer) : JdbcRelationalUtil.getJdbcManager();
            this.connection = mgr.createConnection(this.src, null, this.password);
        }
    }

    protected void disconnect() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectStatistics(Map tblStats, IProgressMonitor monitor) throws Exception {
        this.log("\nLoading table statistics...");
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        long begin = System.currentTimeMillis();
        this.connect();
        try {
            Iterator it = tblStats.values().iterator();
            while (it.hasNext()) {
                if (monitor.isCanceled()) {
                    break;
                }
                TableStatistics tblStat = (TableStatistics)it.next();
                try {
                    if (this.populateTableStatistics(tblStat, monitor)) {
                        this.prepareColumnStatistics(tblStat, monitor);
                        this.populateColumnStatistics(tblStat, monitor);
                        continue;
                    }
                    monitor.worked(tblStat.getColumnStats().size() + 1);
                }
                catch (Exception e) {
                    this.log("WARNING: Failed to retrieve statistics for table/view " + tblStat.getName());
                }
            }
        }
        finally {
            this.disconnect();
        }
        this.log("Done loading tables, total time = " + (System.currentTimeMillis() - begin) + " ms");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean populateTableStatistics(TableStatistics tblStat, IProgressMonitor monitor) throws Exception {
        ResultSet rs;
        Statement stmt;
        block10: {
            boolean bl;
            if (monitor.isCanceled()) {
                return false;
            }
            monitor.subTask(ModelerJdbcRelationalConstants.Util.getString("DefaultCostAnalyzer.Progress.Calculating_table_statistics", (Object)tblStat.getName()));
            long begin = System.currentTimeMillis();
            stmt = null;
            rs = null;
            try {
                String tblName = tblStat.getFullyQualifiedEscapedName();
                stmt = this.connection.createStatement();
                rs = stmt.executeQuery("select count(*) from " + tblName);
                if (!rs.next()) break block10;
                tblStat.setCardinality(rs.getInt(1));
                this.log("\t" + tblName + ": " + tblStat.getCardinality() + " rows    (in " + (System.currentTimeMillis() - begin) + " ms)");
                bl = true;
                Object var10_8 = null;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                monitor.worked(1);
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                throw throwable;
            }
            monitor.worked(1);
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            return bl;
        }
        Object var10_9 = null;
        monitor.worked(1);
        if (rs != null) {
            rs.close();
        }
        if (stmt != null) {
            stmt.close();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void prepareColumnStatistics(TableStatistics tblStat, IProgressMonitor monitor) throws Exception {
        block5: {
            if (monitor.isCanceled()) {
                return;
            }
            ResultSet rs = null;
            try {
                DatabaseMetaData md = this.connection.getMetaData();
                Map colStats = tblStat.getColumnStats();
                rs = md.getColumns(tblStat.getCatalog(), tblStat.getSchema(), tblStat.getName(), "%");
                while (rs.next()) {
                    String colName = JdbcRelationalUtil.escapeDatabaseObjectName(rs.getString(4));
                    ColumnStatistics colStat = (ColumnStatistics)colStats.get(colName);
                    if (colStat == null) continue;
                    colStat.setJdbcType(rs.getInt(5));
                    colStat.setNullable(rs.getInt(11) != 0);
                }
                Object var9_8 = null;
                if (rs == null) break block5;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (rs != null) {
                    rs.close();
                }
                monitor.worked(1);
                throw throwable;
            }
            rs.close();
        }
        monitor.worked(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean populateColumnStatistics(TableStatistics tblStat, IProgressMonitor monitor) throws Exception {
        Iterator it = tblStat.getColumnStats().values().iterator();
        while (it.hasNext()) {
            if (monitor.isCanceled()) {
                return false;
            }
            ColumnStatistics colStat = (ColumnStatistics)it.next();
            monitor.subTask(ModelerJdbcRelationalConstants.Util.getString("DefaultCostAnalyzer.Progress.Calculating_column_statistics", new Object[]{colStat.getName(), tblStat.getName()}));
            try {
                if (this.computeColumnStatistics(tblStat, colStat)) continue;
                boolean bl = false;
                return bl;
            }
            catch (Exception e) {
                this.log("WARNING: Failed to retrieve statistics for column " + colStat.getName() + " in table/view " + tblStat.getName());
            }
            finally {
                monitor.worked(1);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean computeColumnStatistics(TableStatistics tblStat, ColumnStatistics colStat) throws Exception {
        String sql;
        ResultSet rs;
        Statement stmt;
        long begin = System.currentTimeMillis();
        String tblName = tblStat.getFullyQualifiedEscapedName();
        String colName = JdbcRelationalUtil.escapeDatabaseObjectName(colStat.getName());
        boolean isNDVCalcuationRequired = colStat.isNDVCalculationRequired();
        boolean isMinMaxCalculationRequired = colStat.isMinMaxCalculationRequired();
        boolean isNNVCalculationRequired = colStat.isNNVCalculationRequired();
        if (isNDVCalcuationRequired || isMinMaxCalculationRequired) {
            block20: {
                stmt = null;
                rs = null;
                try {
                    stmt = this.connection.createStatement();
                    sql = "select ";
                    boolean isUniqueIdentifier = "uniqueidentifier".equalsIgnoreCase(colStat.getNativeType());
                    if (isNDVCalcuationRequired) {
                        sql = isUniqueIdentifier ? sql + "count(*)" : sql + "count(distinct " + colName + ")";
                        if (isMinMaxCalculationRequired) {
                            sql = sql + ", ";
                        }
                    }
                    if (isMinMaxCalculationRequired) {
                        sql = sql + "min(" + colName + "), max(" + colName + ")";
                    }
                    sql = sql + " from " + tblName;
                    if (isUniqueIdentifier && isNNVCalculationRequired) {
                        sql = sql + " where " + colName + " is not null";
                    }
                    if ((rs = stmt.executeQuery(sql)).next()) {
                        int minOffset = 1;
                        if (isNDVCalcuationRequired) {
                            colStat.setNumDistinctValues(rs.getInt(1));
                            minOffset = 2;
                        }
                        if (isMinMaxCalculationRequired) {
                            colStat.setMin(rs.getString(minOffset));
                            colStat.setMax(rs.getString(++minOffset));
                        }
                    }
                    Object var16_14 = null;
                    if (rs == null) break block20;
                }
                catch (Throwable throwable) {
                    Object var16_15 = null;
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                    throw throwable;
                }
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        if (isNNVCalculationRequired) {
            block21: {
                stmt = null;
                rs = null;
                try {
                    stmt = this.connection.createStatement();
                    sql = "select count(*) from " + tblName + " where " + colName + " is null";
                    rs = stmt.executeQuery(sql);
                    if (rs.next()) {
                        colStat.setNumNullValues(rs.getInt(1));
                    }
                    Object var18_17 = null;
                    if (rs == null) break block21;
                }
                catch (Throwable throwable) {
                    Object var18_18 = null;
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                    throw throwable;
                }
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        this.log("\t\t" + tblName + "." + colName + ": NDV=" + colStat.getNumDistinctValues() + ", NNV=" + colStat.getNumNullValues() + ", min=" + colStat.getMin() + ", max=" + colStat.getMax() + "    (in " + (System.currentTimeMillis() - begin) + " ms)");
        return true;
    }

    public static void setVDBContainer(Container container) {
        vdbContainer = container;
    }

    public static void setConfigFolder(File folder) {
        configFolder = folder;
    }
}

