/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.jdbc.relational.impl;

import com.metamatrix.modeler.internal.jdbc.relational.util.JdbcRelationalUtil;
import com.metamatrix.modeler.jdbc.JdbcSource;
import com.metamatrix.modeler.jdbc.relational.impl.ColumnStatistics;
import com.metamatrix.modeler.jdbc.relational.impl.DefaultCostAnalyzerImpl;
import com.metamatrix.modeler.jdbc.relational.impl.TableStatistics;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Statement;
import org.eclipse.core.runtime.IProgressMonitor;

public class OracleCostAnalyzerImpl
extends DefaultCostAnalyzerImpl {
    private static String ORACLE_8 = "8.";

    public OracleCostAnalyzerImpl(JdbcSource src, String password) {
        super(src, password);
    }

    protected boolean populateTableStatistics(TableStatistics tblStat, IProgressMonitor monitor) throws Exception {
        if (monitor.isCanceled()) {
            return false;
        }
        if (!this.populateOracleTableStatistics(tblStat)) {
            return super.populateTableStatistics(tblStat, monitor);
        }
        monitor.worked(1);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean populateOracleTableStatistics(TableStatistics tblStat) throws Exception {
        Statement stmt;
        block9: {
            ResultSet rs;
            block7: {
                boolean bl;
                block8: {
                    long begin = System.currentTimeMillis();
                    stmt = null;
                    rs = null;
                    try {
                        String tblName = tblStat.getName();
                        stmt = this.connection.createStatement();
                        rs = stmt.executeQuery("select num_rows from ALL_TABLES where owner = '" + tblStat.getSchema() + "' AND table_name = '" + tblName + "'");
                        if (!rs.next()) break block7;
                        tblStat.setCardinality(rs.getInt(1));
                        this.log("\t" + tblName + ": " + tblStat.getCardinality() + " rows    (collected from Oracle stats in " + (System.currentTimeMillis() - begin) + " ms)");
                        bl = true;
                        Object var9_7 = null;
                        if (rs == null) break block8;
                    }
                    catch (Throwable throwable) {
                        Object var9_9 = null;
                        if (rs != null) {
                            rs.close();
                        }
                        if (stmt != null) {
                            stmt.close();
                        }
                        throw throwable;
                    }
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                return bl;
            }
            Object var9_8 = null;
            if (rs == null) break block9;
            rs.close();
        }
        if (stmt != null) {
            stmt.close();
        }
        return false;
    }

    protected boolean computeColumnStatistics(TableStatistics tblStat, ColumnStatistics colStat) throws Exception {
        if (!this.computeOracleColumnStatistics(tblStat, colStat)) {
            return super.computeColumnStatistics(tblStat, colStat);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean computeOracleColumnStatistics(TableStatistics tblStat, ColumnStatistics colStat) throws Exception {
        Statement stmt;
        block12: {
            ResultSet rs;
            block10: {
                boolean bl;
                block11: {
                    long begin = System.currentTimeMillis();
                    stmt = null;
                    rs = null;
                    boolean success = false;
                    try {
                        stmt = this.connection.createStatement();
                        DatabaseMetaData metadata = this.connection.getMetaData();
                        rs = metadata.getDatabaseProductVersion().startsWith(ORACLE_8) ? stmt.executeQuery("select num_distinct, num_nulls, low_value, high_value from ALL_TAB_COL_STATISTICS where TABLE_NAME = '" + tblStat.getName() + "' and COLUMN_NAME = '" + colStat.getName() + "'") : stmt.executeQuery("select num_distinct, num_nulls, low_value, high_value from ALL_TAB_COL_STATISTICS where owner='" + tblStat.getSchema() + "' and TABLE_NAME = '" + tblStat.getName() + "' and COLUMN_NAME = '" + colStat.getName() + "'");
                        if (!rs.next()) break block10;
                        colStat.setNumDistinctValues(rs.getInt(1));
                        colStat.setNumNullValues(rs.getInt(2));
                        String tblName = tblStat.getFullyQualifiedEscapedName();
                        String colName = JdbcRelationalUtil.escapeDatabaseObjectName(colStat.getName());
                        if (colStat.isMinMaxCalculationRequired()) {
                            String minMaxSql = "select min(" + colName + "), max(" + colName + ") from " + tblName;
                            rs = stmt.executeQuery(minMaxSql);
                            if (rs.next()) {
                                colStat.setMin(rs.getString(1));
                                colStat.setMax(rs.getString(2));
                                success = true;
                            }
                        } else {
                            success = true;
                        }
                        this.log("\t\t" + tblName + "." + colName + ": NDV=" + colStat.getNumDistinctValues() + ": NNV=" + colStat.getNumNullValues() + ", min=" + colStat.getMin() + ", max=" + colStat.getMax() + "    (collected from stats in " + (System.currentTimeMillis() - begin) + " ms)");
                        bl = success;
                        Object var13_12 = null;
                        if (rs == null) break block11;
                    }
                    catch (Throwable throwable) {
                        Object var13_14 = null;
                        if (rs != null) {
                            rs.close();
                        }
                        if (stmt != null) {
                            stmt.close();
                        }
                        throw throwable;
                    }
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                return bl;
            }
            Object var13_13 = null;
            if (rs == null) break block12;
            rs.close();
        }
        if (stmt != null) {
            stmt.close();
        }
        return false;
    }
}

