/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.tools.toolshell.database;

import com.metamatrix.tools.ToolsPlugin;
import com.metamatrix.tools.toolshell.database.DatabaseConnectionCommandImpl;
import com.metamatrix.tools.toolshell.database.DatabaseConnectionContext;
import com.metamatrix.tools.toolshell.parser.CommandIterator;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;

public class SqlSelectCommand
extends DatabaseConnectionCommandImpl {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeCommand(Iterator argIter) {
        DatabaseConnectionContext dcContext = this.getDatabaseConnectionContext();
        try {
            Connection connection = dcContext.getConnection();
            if (connection == null) {
                this.printlnError(NOT_CONNECTED_ERROR_STRING);
                boolean bl = true;
                return bl;
            }
            Statement statement = dcContext.getStatement();
            ResultSet resultSet = statement.executeQuery(CommandIterator.wordsToString(argIter));
            if (this.getPrintResults()) {
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                    this.printVerbose(resultSetMetaData.getColumnLabel(i) + "\t");
                }
                this.printlnVerbose("");
                int rowCount = 0;
                while (resultSet.next()) {
                    for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                        this.printVerbose(resultSet.getString(i) + "\t");
                    }
                    this.printlnVerbose("");
                    ++rowCount;
                }
                this.printlnVerbose("");
                this.printlnVerbose(ToolsPlugin.Util.getString("SqlSelectCommand.rows_retrieved", rowCount));
                this.printExecutionPlan(statement);
            } else {
                while (resultSet.next()) {
                }
            }
            resultSet.close();
        }
        catch (SQLException e) {
            this.printlnSQLException(e);
        }
        catch (ClassNotFoundException e) {
            this.printlnException(e);
        }
        finally {
            dcContext.closeStatement();
        }
        return true;
    }

    public String getCommandName() {
        return ToolsPlugin.Util.getString("SqlSelectCommand.commandName");
    }

    public String getLongHelp(List argList) {
        return ToolsPlugin.Util.getString("SqlSelectCommand.longHelp");
    }

    public String getShortHelp() {
        return ToolsPlugin.Util.getString("SqlSelectCommand.shortHelp");
    }

    public String getArgHelp() {
        return ToolsPlugin.Util.getString("SqlSelectCommand.argHelp");
    }
}

