/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.DefaultChannelCapacity;
import EDU.oswego.cs.dl.util.concurrent.Heap;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactoryUser;
import java.util.Date;

public class ClockDaemon
extends ThreadFactoryUser {
    protected final Heap heap_ = new Heap(DefaultChannelCapacity.get());
    protected Thread thread_;
    protected final RunLoop runLoop_ = new RunLoop();

    public Object executeAt(Date date, Runnable runnable) {
        TaskNode taskNode = new TaskNode(date.getTime(), runnable);
        this.heap_.insert(taskNode);
        this.restart();
        return taskNode;
    }

    public Object executeAfterDelay(long l2, Runnable runnable) {
        long l3 = System.currentTimeMillis() + l2;
        TaskNode taskNode = new TaskNode(l3, runnable);
        this.heap_.insert(taskNode);
        this.restart();
        return taskNode;
    }

    public Object executePeriodically(long l2, Runnable runnable, boolean bl) {
        if (l2 <= 0L) {
            throw new IllegalArgumentException();
        }
        long l3 = System.currentTimeMillis();
        if (!bl) {
            l3 += l2;
        }
        TaskNode taskNode = new TaskNode(l3, runnable, l2);
        this.heap_.insert(taskNode);
        this.restart();
        return taskNode;
    }

    public static void cancel(Object object) {
        ((TaskNode)object).setCancelled();
    }

    public synchronized Thread getThread() {
        return this.thread_;
    }

    protected synchronized void clearThread() {
        this.thread_ = null;
    }

    public synchronized void restart() {
        if (this.thread_ == null) {
            this.thread_ = this.threadFactory_.newThread(this.runLoop_);
            this.thread_.start();
        } else {
            this.notify();
        }
    }

    public synchronized void shutDown() {
        this.heap_.clear();
        if (this.thread_ != null) {
            this.thread_.interrupt();
        }
        this.thread_ = null;
    }

    protected synchronized TaskNode nextTask() {
        try {
            while (!Thread.interrupted()) {
                TaskNode taskNode = (TaskNode)this.heap_.peek();
                if (taskNode == null) {
                    this.wait();
                    continue;
                }
                long l2 = System.currentTimeMillis();
                long l3 = taskNode.getTimeToRun();
                if (l3 > l2) {
                    this.wait(l3 - l2);
                    continue;
                }
                taskNode = (TaskNode)this.heap_.extract();
                if (taskNode.getCancelled()) continue;
                if (taskNode.period > 0L) {
                    taskNode.setTimeToRun(l2 + taskNode.period);
                    this.heap_.insert(taskNode);
                }
                return taskNode;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    protected class RunLoop
    implements Runnable {
        protected RunLoop() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                TaskNode taskNode;
                while ((taskNode = ClockDaemon.this.nextTask()) != null) {
                    taskNode.command.run();
                }
            }
            finally {
                ClockDaemon.this.clearThread();
            }
        }
    }

    protected static class TaskNode
    implements Comparable {
        final Runnable command;
        final long period;
        private long timeToRun_;
        private boolean cancelled_ = false;

        synchronized void setCancelled() {
            this.cancelled_ = true;
        }

        synchronized boolean getCancelled() {
            return this.cancelled_;
        }

        synchronized void setTimeToRun(long l2) {
            this.timeToRun_ = l2;
        }

        synchronized long getTimeToRun() {
            return this.timeToRun_;
        }

        public int compareTo(Object object) {
            long l2;
            long l3 = this.getTimeToRun();
            return l3 < (l2 = ((TaskNode)object).getTimeToRun()) ? -1 : (l3 == l2 ? 0 : 1);
        }

        TaskNode(long l2, Runnable runnable, long l3) {
            this.timeToRun_ = l2;
            this.command = runnable;
            this.period = l3;
        }

        TaskNode(long l2, Runnable runnable) {
            this(l2, runnable, -1L);
        }
    }
}

