/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class CopyOnWriteArrayList
implements List,
Cloneable,
Serializable {
    protected transient Object[] array_;

    protected synchronized Object[] array() {
        return this.array_;
    }

    public CopyOnWriteArrayList() {
        this.array_ = new Object[0];
    }

    public CopyOnWriteArrayList(Collection collection) {
        this.array_ = new Object[collection.size()];
        Iterator iterator = collection.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            this.array_[n2++] = iterator.next();
        }
    }

    public CopyOnWriteArrayList(Object[] objectArray) {
        this.copyIn(objectArray, 0, objectArray.length);
    }

    public synchronized void copyIn(Object[] objectArray, int n2, int n3) {
        this.array_ = new Object[n3];
        System.arraycopy(objectArray, n2, this.array_, 0, n3);
    }

    public int size() {
        return this.array().length;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean contains(Object object) {
        int n2;
        Object[] objectArray = this.array();
        return CopyOnWriteArrayList.indexOf(object, objectArray, n2 = objectArray.length) >= 0;
    }

    public int indexOf(Object object) {
        Object[] objectArray = this.array();
        int n2 = objectArray.length;
        return CopyOnWriteArrayList.indexOf(object, objectArray, n2);
    }

    protected static int indexOf(Object object, Object[] objectArray, int n2) {
        if (object == null) {
            for (int i2 = 0; i2 < n2; ++i2) {
                if (objectArray[i2] != null) continue;
                return i2;
            }
        } else {
            for (int i3 = 0; i3 < n2; ++i3) {
                if (!object.equals(objectArray[i3])) continue;
                return i3;
            }
        }
        return -1;
    }

    public int indexOf(Object object, int n2) {
        Object[] objectArray = this.array();
        int n3 = objectArray.length;
        if (object == null) {
            for (int i2 = n2; i2 < n3; ++i2) {
                if (objectArray[i2] != null) continue;
                return i2;
            }
        } else {
            for (int i3 = n2; i3 < n3; ++i3) {
                if (!object.equals(objectArray[i3])) continue;
                return i3;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object object) {
        Object[] objectArray = this.array();
        int n2 = objectArray.length;
        return CopyOnWriteArrayList.lastIndexOf(object, objectArray, n2);
    }

    protected static int lastIndexOf(Object object, Object[] objectArray, int n2) {
        if (object == null) {
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                if (objectArray[i2] != null) continue;
                return i2;
            }
        } else {
            for (int i3 = n2 - 1; i3 >= 0; --i3) {
                if (!object.equals(objectArray[i3])) continue;
                return i3;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object object, int n2) {
        Object[] objectArray = this.array();
        if (object == null) {
            for (int i2 = n2; i2 >= 0; --i2) {
                if (objectArray[i2] != null) continue;
                return i2;
            }
        } else {
            for (int i3 = n2; i3 >= 0; --i3) {
                if (!object.equals(objectArray[i3])) continue;
                return i3;
            }
        }
        return -1;
    }

    public Object clone() {
        try {
            Object[] objectArray = this.array();
            CopyOnWriteArrayList copyOnWriteArrayList = (CopyOnWriteArrayList)super.clone();
            copyOnWriteArrayList.array_ = new Object[objectArray.length];
            System.arraycopy(objectArray, 0, copyOnWriteArrayList.array_, 0, objectArray.length);
            return copyOnWriteArrayList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public Object[] toArray() {
        Object[] objectArray = this.array();
        Object[] objectArray2 = new Object[objectArray.length];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        return objectArray2;
    }

    public Object[] toArray(Object[] objectArray) {
        Object[] objectArray2 = this.array();
        if (objectArray.length < objectArray2.length) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), objectArray2.length);
        }
        System.arraycopy(objectArray2, 0, objectArray, 0, objectArray2.length);
        if (objectArray.length > objectArray2.length) {
            objectArray[objectArray2.length] = null;
        }
        return objectArray;
    }

    public Object get(int n2) {
        Object[] objectArray = this.array();
        this.rangeCheck(n2, objectArray.length);
        return objectArray[n2];
    }

    public synchronized Object set(int n2, Object object) {
        boolean bl;
        int n3 = this.array_.length;
        this.rangeCheck(n2, n3);
        Object object2 = this.array_[n2];
        boolean bl2 = bl = object2 == object || object != null && object.equals(object2);
        if (!bl) {
            Object[] objectArray = new Object[n3];
            System.arraycopy(this.array_, 0, objectArray, 0, n3);
            objectArray[n2] = object;
            this.array_ = objectArray;
        }
        return object2;
    }

    public synchronized boolean add(Object object) {
        int n2 = this.array_.length;
        Object[] objectArray = new Object[n2 + 1];
        System.arraycopy(this.array_, 0, objectArray, 0, n2);
        objectArray[n2] = object;
        this.array_ = objectArray;
        return true;
    }

    public synchronized void add(int n2, Object object) {
        int n3 = this.array_.length;
        if (n2 > n3 || n2 < 0) {
            throw new IndexOutOfBoundsException("Index: " + n2 + ", Size: " + n3);
        }
        Object[] objectArray = new Object[n3 + 1];
        System.arraycopy(this.array_, 0, objectArray, 0, n2);
        objectArray[n2] = object;
        System.arraycopy(this.array_, n2, objectArray, n2 + 1, n3 - n2);
        this.array_ = objectArray;
    }

    public synchronized Object remove(int n2) {
        int n3 = this.array_.length;
        this.rangeCheck(n2, n3);
        Object object = this.array_[n2];
        Object[] objectArray = new Object[n3 - 1];
        System.arraycopy(this.array_, 0, objectArray, 0, n2);
        int n4 = n3 - n2 - 1;
        if (n4 > 0) {
            System.arraycopy(this.array_, n2 + 1, objectArray, n2, n4);
        }
        this.array_ = objectArray;
        return object;
    }

    public synchronized boolean remove(Object object) {
        int n2 = this.array_.length;
        if (n2 == 0) {
            return false;
        }
        int n3 = n2 - 1;
        Object[] objectArray = new Object[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            if (object == this.array_[i2] || object != null && object.equals(this.array_[i2])) {
                for (int i3 = i2 + 1; i3 < n2; ++i3) {
                    objectArray[i3 - 1] = this.array_[i3];
                }
                this.array_ = objectArray;
                return true;
            }
            objectArray[i2] = this.array_[i2];
        }
        if (object == this.array_[n3] || object != null && object.equals(this.array_[n3])) {
            this.array_ = objectArray;
            return true;
        }
        return false;
    }

    public synchronized void removeRange(int n2, int n3) {
        int n4 = this.array_.length;
        if (n2 < 0 || n2 >= n4 || n3 > n4 || n3 < n2) {
            throw new IndexOutOfBoundsException();
        }
        int n5 = n4 - n3;
        int n6 = n4 - (n3 - n2);
        Object[] objectArray = new Object[n6];
        System.arraycopy(this.array_, 0, objectArray, 0, n2);
        System.arraycopy(this.array_, n3, objectArray, n2, n5);
        this.array_ = objectArray;
    }

    public synchronized boolean addIfAbsent(Object object) {
        int n2 = this.array_.length;
        Object[] objectArray = new Object[n2 + 1];
        for (int i2 = 0; i2 < n2; ++i2) {
            if (object == this.array_[i2] || object != null && object.equals(this.array_[i2])) {
                return false;
            }
            objectArray[i2] = this.array_[i2];
        }
        objectArray[n2] = object;
        this.array_ = objectArray;
        return true;
    }

    public boolean containsAll(Collection collection) {
        Object[] objectArray = this.array();
        int n2 = objectArray.length;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (CopyOnWriteArrayList.indexOf(iterator.next(), objectArray, n2) >= 0) continue;
            return false;
        }
        return true;
    }

    public synchronized boolean removeAll(Collection collection) {
        Object[] objectArray = this.array_;
        int n2 = objectArray.length;
        if (n2 == 0) {
            return false;
        }
        Object[] objectArray2 = new Object[n2];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = objectArray[i2];
            if (collection.contains(object)) continue;
            objectArray2[n3++] = object;
        }
        if (n3 == n2) {
            return false;
        }
        Object[] objectArray3 = new Object[n3];
        System.arraycopy(objectArray2, 0, objectArray3, 0, n3);
        this.array_ = objectArray3;
        return true;
    }

    public synchronized boolean retainAll(Collection collection) {
        Object[] objectArray = this.array_;
        int n2 = objectArray.length;
        if (n2 == 0) {
            return false;
        }
        Object[] objectArray2 = new Object[n2];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = objectArray[i2];
            if (!collection.contains(object)) continue;
            objectArray2[n3++] = object;
        }
        if (n3 == n2) {
            return false;
        }
        Object[] objectArray3 = new Object[n3];
        System.arraycopy(objectArray2, 0, objectArray3, 0, n3);
        this.array_ = objectArray3;
        return true;
    }

    public synchronized int addAllAbsent(Collection collection) {
        Object object;
        int n2 = collection.size();
        if (n2 == 0) {
            return 0;
        }
        Object[] objectArray = this.array_;
        int n3 = objectArray.length;
        Object[] objectArray2 = new Object[n2];
        int n4 = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (CopyOnWriteArrayList.indexOf(object, objectArray, n3) >= 0 || CopyOnWriteArrayList.indexOf(object, objectArray2, n4) >= 0) continue;
            objectArray2[n4++] = object;
        }
        if (n4 == 0) {
            return 0;
        }
        object = new Object[n3 + n4];
        System.arraycopy(objectArray, 0, object, 0, n3);
        System.arraycopy(objectArray2, 0, object, n3, n4);
        this.array_ = object;
        return n4;
    }

    public synchronized void clear() {
        this.array_ = new Object[0];
    }

    public synchronized boolean addAll(Collection collection) {
        int n2 = collection.size();
        if (n2 == 0) {
            return false;
        }
        int n3 = this.array_.length;
        Object[] objectArray = new Object[n3 + n2];
        System.arraycopy(this.array_, 0, objectArray, 0, n3);
        Iterator iterator = collection.iterator();
        for (int i2 = 0; i2 < n2; ++i2) {
            objectArray[n3++] = iterator.next();
        }
        this.array_ = objectArray;
        return true;
    }

    public synchronized boolean addAll(int n2, Collection collection) {
        int n3 = this.array_.length;
        if (n2 > n3 || n2 < 0) {
            throw new IndexOutOfBoundsException("Index: " + n2 + ", Size: " + n3);
        }
        int n4 = collection.size();
        if (n4 == 0) {
            return false;
        }
        Object[] objectArray = new Object[n3 + n4];
        System.arraycopy(this.array_, 0, objectArray, 0, n3);
        int n5 = n3 - n2;
        if (n5 > 0) {
            System.arraycopy(this.array_, n2, objectArray, n2 + n4, n5);
        }
        Iterator iterator = collection.iterator();
        for (int i2 = 0; i2 < n4; ++i2) {
            objectArray[n2++] = iterator.next();
        }
        this.array_ = objectArray;
        return true;
    }

    protected void rangeCheck(int n2, int n3) {
        if (n2 >= n3 || n2 < 0) {
            throw new IndexOutOfBoundsException("Index: " + n2 + ", Size: " + n3);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Object[] objectArray = this.array();
        objectOutputStream.writeInt(objectArray.length);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            objectOutputStream.writeObject(objectArray[i2]);
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n2 = objectInputStream.readInt();
        Object[] objectArray = new Object[n2];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            objectArray[i2] = objectInputStream.readObject();
        }
        this.array_ = objectArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.iterator();
        stringBuffer.append("[");
        int n2 = this.size() - 1;
        for (int i2 = 0; i2 <= n2; ++i2) {
            stringBuffer.append(String.valueOf(iterator.next()));
            if (i2 >= n2) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        if (this.size() != list.size()) {
            return false;
        }
        ListIterator listIterator = this.listIterator();
        ListIterator listIterator2 = list.listIterator();
        while (listIterator.hasNext()) {
            Object e2 = listIterator.next();
            Object e3 = listIterator2.next();
            if (e2 != null ? e2.equals(e3) : e3 == null) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n2 = 1;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            n2 = 31 * n2 + (e2 == null ? 0 : e2.hashCode());
        }
        return n2;
    }

    public Iterator iterator() {
        return new COWIterator(this.array(), 0);
    }

    public ListIterator listIterator() {
        return new COWIterator(this.array(), 0);
    }

    public ListIterator listIterator(int n2) {
        Object[] objectArray = this.array();
        int n3 = objectArray.length;
        if (n2 < 0 || n2 > n3) {
            throw new IndexOutOfBoundsException("Index: " + n2);
        }
        return new COWIterator(this.array(), n2);
    }

    public synchronized List subList(int n2, int n3) {
        int n4 = this.array_.length;
        if (n2 < 0 || n3 > n4 || n2 > n3) {
            throw new IndexOutOfBoundsException();
        }
        return new COWSubList(this, n2, n3);
    }

    protected static class COWSubList
    extends AbstractList {
        protected final CopyOnWriteArrayList l;
        protected final int offset;
        protected int size;
        protected Object[] expectedArray;

        protected COWSubList(CopyOnWriteArrayList copyOnWriteArrayList, int n2, int n3) {
            this.l = copyOnWriteArrayList;
            this.expectedArray = this.l.array();
            this.offset = n2;
            this.size = n3 - n2;
        }

        protected void checkForComodification() {
            if (this.l.array_ != this.expectedArray) {
                throw new ConcurrentModificationException();
            }
        }

        protected void rangeCheck(int n2) {
            if (n2 < 0 || n2 >= this.size) {
                throw new IndexOutOfBoundsException("Index: " + n2 + ",Size: " + this.size);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object set(int n2, Object object) {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.rangeCheck(n2);
                this.checkForComodification();
                Object object2 = this.l.set(n2 + this.offset, object);
                this.expectedArray = this.l.array_;
                return object2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(int n2) {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.rangeCheck(n2);
                this.checkForComodification();
                return this.l.get(n2 + this.offset);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                return this.size;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(int n2, Object object) {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                if (n2 < 0 || n2 > this.size) {
                    throw new IndexOutOfBoundsException();
                }
                this.l.add(n2 + this.offset, object);
                this.expectedArray = this.l.array_;
                ++this.size;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object remove(int n2) {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.rangeCheck(n2);
                this.checkForComodification();
                Object object = this.l.remove(n2 + this.offset);
                this.expectedArray = this.l.array_;
                --this.size;
                return object;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Iterator iterator() {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                return new COWSubListIterator(0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ListIterator listIterator(int n2) {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                if (n2 < 0 || n2 > this.size) {
                    throw new IndexOutOfBoundsException("Index: " + n2 + ", Size: " + this.size);
                }
                return new COWSubListIterator(n2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List subList(int n2, int n3) {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                if (n2 < 0 || n3 > this.size) {
                    throw new IndexOutOfBoundsException();
                }
                return new COWSubList(this.l, n2 + this.offset, n3 + this.offset);
            }
        }

        protected class COWSubListIterator
        implements ListIterator {
            protected final ListIterator i;
            protected final int index;

            protected COWSubListIterator(int n2) {
                this.index = n2;
                this.i = COWSubList.this.l.listIterator(n2 + COWSubList.this.offset);
            }

            public boolean hasNext() {
                return this.nextIndex() < COWSubList.this.size;
            }

            public Object next() {
                if (this.hasNext()) {
                    return this.i.next();
                }
                throw new NoSuchElementException();
            }

            public boolean hasPrevious() {
                return this.previousIndex() >= 0;
            }

            public Object previous() {
                if (this.hasPrevious()) {
                    return this.i.previous();
                }
                throw new NoSuchElementException();
            }

            public int nextIndex() {
                return this.i.nextIndex() - COWSubList.this.offset;
            }

            public int previousIndex() {
                return this.i.previousIndex() - COWSubList.this.offset;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void set(Object object) {
                throw new UnsupportedOperationException();
            }

            public void add(Object object) {
                throw new UnsupportedOperationException();
            }
        }
    }

    protected static class COWIterator
    implements ListIterator {
        protected final Object[] array;
        protected int cursor;

        protected COWIterator(Object[] objectArray, int n2) {
            this.array = objectArray;
            this.cursor = n2;
        }

        public boolean hasNext() {
            return this.cursor < this.array.length;
        }

        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        public Object next() {
            try {
                return this.array[this.cursor++];
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        public Object previous() {
            try {
                return this.array[--this.cursor];
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        public int nextIndex() {
            return this.cursor;
        }

        public int previousIndex() {
            return this.cursor - 1;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void set(Object object) {
            throw new UnsupportedOperationException();
        }

        public void add(Object object) {
            throw new UnsupportedOperationException();
        }
    }
}

