/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import java.util.Comparator;

public class Heap {
    protected Object[] nodes_;
    protected int count_ = 0;
    protected final Comparator cmp_;

    public Heap(int n2, Comparator comparator) throws IllegalArgumentException {
        if (n2 <= 0) {
            throw new IllegalArgumentException();
        }
        this.nodes_ = new Object[n2];
        this.cmp_ = comparator;
    }

    public Heap(int n2) {
        this(n2, null);
    }

    protected int compare(Object object, Object object2) {
        if (this.cmp_ == null) {
            return ((Comparable)object).compareTo(object2);
        }
        return this.cmp_.compare(object, object2);
    }

    protected final int parent(int n2) {
        return (n2 - 1) / 2;
    }

    protected final int left(int n2) {
        return 2 * n2 + 1;
    }

    protected final int right(int n2) {
        return 2 * (n2 + 1);
    }

    public synchronized void insert(Object object) {
        int n2;
        int n3;
        if (this.count_ >= this.nodes_.length) {
            n3 = 3 * this.nodes_.length / 2 + 1;
            Object[] objectArray = new Object[n3];
            System.arraycopy(this.nodes_, 0, objectArray, 0, this.nodes_.length);
            this.nodes_ = objectArray;
        }
        n3 = this.count_++;
        while (n3 > 0 && this.compare(object, this.nodes_[n2 = this.parent(n3)]) < 0) {
            this.nodes_[n3] = this.nodes_[n2];
            n3 = n2;
        }
        this.nodes_[n3] = object;
    }

    public synchronized Object extract() {
        int n2;
        if (this.count_ < 1) {
            return null;
        }
        int n3 = 0;
        Object object = this.nodes_[n3];
        --this.count_;
        Object object2 = this.nodes_[this.count_];
        this.nodes_[this.count_] = null;
        while ((n2 = this.left(n3)) < this.count_) {
            int n4;
            int n5 = this.right(n3);
            int n6 = n4 = n5 >= this.count_ || this.compare(this.nodes_[n2], this.nodes_[n5]) < 0 ? n2 : n5;
            if (this.compare(object2, this.nodes_[n4]) <= 0) break;
            this.nodes_[n3] = this.nodes_[n4];
            n3 = n4;
        }
        this.nodes_[n3] = object2;
        return object;
    }

    public synchronized Object peek() {
        if (this.count_ > 0) {
            return this.nodes_[0];
        }
        return null;
    }

    public synchronized int size() {
        return this.count_;
    }

    public synchronized void clear() {
        for (int i2 = 0; i2 < this.count_; ++i2) {
            this.nodes_[i2] = null;
        }
        this.count_ = 0;
    }
}

