/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.buffer;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.buffer.BufferManager;
import com.metamatrix.common.buffer.BufferManagerLookup;
import com.metamatrix.common.buffer.LocalLookup;
import com.metamatrix.common.buffer.LoggingBufferManagerProxy;
import com.metamatrix.common.buffer.impl.BufferManagerImpl;
import com.metamatrix.common.buffer.storage.file.FileStorageManager;
import com.metamatrix.common.buffer.storage.memory.MemoryStorageManager;
import com.metamatrix.common.util.PropertiesUtils;
import java.rmi.RemoteException;
import java.util.Properties;

public class BufferManagerFactory {
    public static BufferManager getStandaloneBufferManager() throws MetaMatrixComponentException {
        try {
            BufferManagerImpl bufferMgr = new BufferManagerImpl();
            Properties props = new Properties();
            props.setProperty("metamatrix.buffer.idCreator", "com.metamatrix.common.buffer.impl.LongIDCreator");
            props.setProperty("metamatrix.buffer.memoryAvailable", "9223372036854775807");
            props.setProperty("metamatrix.buffer.sessionUsePercentage", "100");
            props.setProperty("metamatrix.buffer.logStatsInterval", "0");
            props.setProperty("metamatrix.buffer.managementInterval", "0");
            bufferMgr.initialize(new LocalLookup(bufferMgr), props);
            bufferMgr.addStorageManager(new MemoryStorageManager());
            return bufferMgr;
        }
        catch (RemoteException e2) {
            throw new MetaMatrixComponentException(CommonPlugin.Util.getString("ERR.003.006.0001", e2.getMessage()));
        }
    }

    public static BufferManager getServerBufferManager(BufferManagerLookup lookup, Properties props) throws MetaMatrixComponentException {
        try {
            Properties bmProps = PropertiesUtils.clone(props, false);
            bmProps.setProperty("metamatrix.buffer.idCreator", "com.metamatrix.common.buffer.impl.DBIDCreator");
            BufferManagerImpl bufferManager = new BufferManagerImpl();
            bufferManager.initialize(lookup, bmProps);
            FileStorageManager fsm = new FileStorageManager();
            fsm.initialize(bmProps);
            bufferManager.addStorageManager(fsm);
            MemoryStorageManager msm = new MemoryStorageManager();
            msm.initialize(bmProps);
            bufferManager.addStorageManager(msm);
            return bufferManager;
        }
        catch (RemoteException e2) {
            throw new MetaMatrixComponentException(CommonPlugin.Util.getString("ERR.003.006.0001", e2.getMessage()));
        }
    }

    public static BufferManager getLoggingBufferManager(BufferManager mgr) {
        return new LoggingBufferManagerProxy(mgr);
    }
}

