/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.buffer;

import com.metamatrix.common.batch.BatchSerializer;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;

public class TupleBatch
implements Externalizable {
    public static final long UNKNOWN_SIZE = -1L;
    private int rowOffset;
    private List[] tuples;
    private boolean terminationFlag = false;
    private long size = -1L;
    private transient String[] types;

    public TupleBatch() {
    }

    public TupleBatch(int beginRow, List[] tuples) {
        this.rowOffset = beginRow;
        this.tuples = tuples;
    }

    public TupleBatch(int beginRow, List listOfTupleLists) {
        this.rowOffset = beginRow;
        this.tuples = listOfTupleLists.toArray(new List[0]);
    }

    public int getBeginRow() {
        return this.rowOffset;
    }

    public int getEndRow() {
        return this.rowOffset + this.tuples.length - 1;
    }

    public int getRowCount() {
        return this.tuples.length;
    }

    public List getTuple(int rowIndex) {
        return this.tuples[rowIndex - this.rowOffset];
    }

    public List[] getAllTuples() {
        return this.tuples;
    }

    public boolean getTerminationFlag() {
        return this.terminationFlag;
    }

    public void setTerminationFlag(boolean terminationFlag) {
        this.terminationFlag = terminationFlag;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public void setDataTypes(String[] types) {
        this.types = types;
    }

    public String toString() {
        StringBuffer s2 = new StringBuffer();
        s2.append("TupleBatch; beginning row=");
        s2.append(this.rowOffset);
        s2.append(", number of rows=");
        s2.append(this.tuples.length);
        s2.append(", lastBatch=");
        s2.append(this.terminationFlag);
        return s2.toString();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.size = in.readLong();
        this.rowOffset = in.readInt();
        this.terminationFlag = in.readBoolean();
        this.tuples = BatchSerializer.readBatch(in, this.types);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.size);
        out.writeInt(this.rowOffset);
        out.writeBoolean(this.terminationFlag);
        BatchSerializer.writeBatch(out, this.types, this.tuples);
    }
}

