/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.cache.simple;

import com.metamatrix.common.cache.ObjectCache;
import com.metamatrix.common.cache.ObjectCacheException;
import com.metamatrix.common.cache.ObjectCacheStatistics;
import com.metamatrix.common.cache.policy.AbstractObjectCachePolicy;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class SimpleObjectCachePolicy
extends AbstractObjectCachePolicy {
    private Map cache = new Hashtable();
    private ObjectCacheStatistics stats = new ObjectCacheStatistics();
    static /* synthetic */ Class class$com$metamatrix$common$cache$simple$SimpleObjectCachePolicyFactory;

    protected SimpleObjectCachePolicy(Properties environment) {
        super(environment);
    }

    public synchronized int size() {
        return this.cache.size();
    }

    public synchronized Object find(Object key) {
        Object result = this.cache.get(key);
        this.stats.recordCacheAccess(result != null, false);
        return result;
    }

    public synchronized void mark(Object key, Object value) {
        if (key != null && value != null) {
            boolean previousValue = this.cache.put(key, value) != null;
            this.stats.addEntries(previousValue ? 0 : 1, 0L);
        }
    }

    public synchronized void remove(Object key) {
        boolean previousValue = this.cache.remove(key) != null;
        this.stats.removeEntries(previousValue ? 1 : 0, 0L);
    }

    public synchronized void clear() {
        this.stats.removeEntries(this.cache.size(), 0L);
        this.cache.clear();
    }

    public synchronized ObjectCacheStatistics getStatistics() {
        return (ObjectCacheStatistics)this.stats.clone();
    }

    public boolean containsValue(Object key) {
        return this.cache.containsKey(key);
    }

    public synchronized Collection getKeysNotInCache(Collection keys) {
        HashSet result = new HashSet(keys);
        result.removeAll(this.cache.keySet());
        return result;
    }

    public synchronized float getResourceUtilization() {
        return 0.0f;
    }

    public synchronized boolean exceedsResources() {
        return false;
    }

    public synchronized void reduceResourceUsage() {
    }

    public String toString() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getCopyOfCacheContents() {
        HashMap contents = new HashMap();
        Map map = this.cache;
        synchronized (map) {
            Iterator keyItr = this.cache.keySet().iterator();
            while (keyItr.hasNext()) {
                Object key = keyItr.next();
                contents.put(key, this.cache.get(key));
            }
        }
        return contents;
    }

    public void reduceSize() {
    }

    public static void main(String[] args) {
        Properties env = new Properties();
        env.setProperty("com.metamatrix.common.cache.ObjectCache.PolicyFactory", (class$com$metamatrix$common$cache$simple$SimpleObjectCachePolicyFactory == null ? (class$com$metamatrix$common$cache$simple$SimpleObjectCachePolicyFactory = SimpleObjectCachePolicy.class$("com.metamatrix.common.cache.simple.SimpleObjectCachePolicyFactory")) : class$com$metamatrix$common$cache$simple$SimpleObjectCachePolicyFactory).getName());
        env.setProperty("com.metamatrix.common.cache.ObjectCache.ResourceRecaptureMode", "InLine");
        env.setProperty("com.metamatrix.common.cache.ObjectCache.ResourceRecaptureInterval", "10000");
        env.setProperty("com.metamatrix.common.cache.ObjectCache.ResourceRecaptureIntervalRate", "40");
        env.setProperty("com.metamatrix.common.cache.ObjectCache.ResourceRecaptureIntervalCeiling", "100000");
        env.setProperty("com.metamatrix.common.cache.ObjectCache.ResourceRecaptureIntervalIncrement", "2.02");
        env.setProperty("com.metamatrix.common.cache.ObjectCache.ResourceRecaptureIntervalDecrement", "0.91");
        try {
            int i2;
            ObjectCache cache = new ObjectCache(env);
            System.out.println("Cache: \n" + cache);
            for (i2 = 0; i2 != 100; ++i2) {
                cache.mark("key" + i2, "value" + i2);
            }
            System.out.println("Cache: \n" + cache);
            for (i2 = 0; i2 != 10; ++i2) {
                cache.remove("key" + i2);
            }
            System.out.println("Cache: \n" + cache);
            for (i2 = 5; i2 != 15; ++i2) {
                cache.find("key" + i2);
            }
            System.out.println("Cache: \n" + cache);
        }
        catch (ObjectCacheException e2) {
            System.out.println("ObjectCache exception:");
            e2.printStackTrace();
        }
        catch (Exception e3) {
            System.out.println("Unexpected exception:");
            e3.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

