/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.extensionmodule.spi.jdbc;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.extensionmodule.ExtensionModuleDescriptor;
import com.metamatrix.core.util.Assertion;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;

public class JDBCExtensionDescriptor
implements ExtensionModuleDescriptor,
Serializable {
    private String name;
    private String type;
    private int position;
    private boolean enabled;
    private String desc;
    private String createdBy;
    private String creationDate;
    private String lastUpdatedBy;
    private String lastUpdatedDate;
    private long checksum;

    public JDBCExtensionDescriptor() {
    }

    public JDBCExtensionDescriptor(JDBCExtensionDescriptor aDesc) {
        this.name = aDesc.getName();
        this.type = aDesc.getType();
        this.position = aDesc.getPosition();
        this.enabled = aDesc.isEnabled();
        this.desc = aDesc.getDescription();
        this.createdBy = aDesc.getCreatedBy();
        this.creationDate = aDesc.getCreationDate();
        this.lastUpdatedBy = aDesc.getLastUpdatedBy();
        this.lastUpdatedDate = aDesc.getLastUpdatedDate();
        this.checksum = aDesc.getChecksum();
    }

    public JDBCExtensionDescriptor(ResultSet resultSet) throws MetaMatrixComponentException {
        try {
            this.name = resultSet.getString("FILE_NAME");
            this.type = resultSet.getString("FILE_TYPE");
            this.position = resultSet.getInt("SEARCH_POS");
            this.enabled = resultSet.getBoolean("IS_ENABLED");
            this.desc = resultSet.getString("FILE_DESC");
            this.createdBy = resultSet.getString("CREATED_BY");
            this.creationDate = resultSet.getString("CREATION_DATE");
            this.lastUpdatedBy = resultSet.getString("UPDATED_BY");
            this.lastUpdatedDate = resultSet.getString("UPDATE_DATE");
            this.checksum = resultSet.getLong("CHKSUM");
        }
        catch (SQLException e2) {
            throw new MetaMatrixComponentException((Throwable)e2, "ERR.014.004.0044", CommonPlugin.Util.getString("ERR.014.004.0044"));
        }
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public int getPosition() {
        return this.position;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getDescription() {
        return this.desc;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public String getLastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    public String getLastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public long getChecksum() {
        return this.checksum;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public void setType(String newType) {
        this.type = newType;
    }

    public void setPosition(int pos) {
        this.position = pos;
    }

    public void setEnabled(boolean isEnabled) {
        this.enabled = isEnabled;
    }

    public void setDescription(String description) {
        this.desc = description;
    }

    public void setCreatedBy(String by) {
        this.createdBy = by;
    }

    public void setCreationDate(String date) {
        this.creationDate = date;
    }

    public void setLastUpdatedBy(String by) {
        this.lastUpdatedBy = by;
    }

    public void setLastUpdatedDate(String date) {
        this.lastUpdatedDate = date;
    }

    public void setChecksum(long sum) {
        this.checksum = sum;
    }

    public int compareTo(Object obj) {
        ExtensionModuleDescriptor that = (ExtensionModuleDescriptor)obj;
        if (obj == null) {
            Assertion.isNotNull(obj, CommonPlugin.Util.getString("ERR.014.004.0045"));
        }
        if (obj == this) {
            return 0;
        }
        return this.position - that.getPosition();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ExtensionModuleDescriptor) {
            ExtensionModuleDescriptor that = (ExtensionModuleDescriptor)obj;
            return this.position == that.getPosition();
        }
        return false;
    }

    public String toString() {
        return "Extension Source: " + this.name;
    }
}

