/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.jdbc;

import com.metamatrix.core.util.StringUtil;
import java.util.List;

public class JDBCURL {
    private static final String DELIMITER_AT = "@";
    private static final String DELIMITER_FORWARDSLASH = "//";
    private static final String JDBC_PROTOCOL = "jdbc:";
    private String connectionURL;
    private String protocol;
    private String databaseInfo;

    public JDBCURL(String jdbcURL) {
        this.parseURL(jdbcURL);
        this.connectionURL = jdbcURL;
    }

    public String getConnectionURL() {
        return this.connectionURL;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getDataConnectionInfo() {
        return this.databaseInfo;
    }

    private void parseURL(String jdbcURL) {
        if (jdbcURL == null) {
            throw new IllegalArgumentException();
        }
        if ((jdbcURL = jdbcURL.trim()).length() == 0) {
            throw new IllegalArgumentException();
        }
        int delimiter = jdbcURL.indexOf(DELIMITER_AT);
        if (delimiter > 0) {
            this.parseWithAt(jdbcURL);
        } else {
            this.parseForSlash(jdbcURL);
        }
    }

    private void parseForSlash(String jdbcURL) {
        this.parseOnDelimiter(jdbcURL, DELIMITER_FORWARDSLASH);
    }

    private void parseOnDelimiter(String jdbcURL, String delim) {
        List urlParts = StringUtil.splitOnEntireString(jdbcURL, delim);
        if (urlParts.size() != 2) {
            throw new IllegalArgumentException();
        }
        this.parseJDBCProtocol((String)urlParts.get(0));
        this.parseConnectionPart((String)urlParts.get(1));
    }

    private void parseWithAt(String jdbcURL) {
        this.parseOnDelimiter(jdbcURL, DELIMITER_AT);
    }

    private void parseJDBCProtocol(String protocolurl) {
        if (!protocolurl.startsWith(JDBC_PROTOCOL)) {
            throw new IllegalArgumentException();
        }
        if (protocolurl.length() == JDBC_PROTOCOL.length()) {
            throw new IllegalArgumentException();
        }
        this.protocol = protocolurl.substring(JDBC_PROTOCOL.length());
    }

    private void parseConnectionPart(String connectionInfo) {
        this.databaseInfo = connectionInfo;
    }

    public String getJDBCURL() {
        return this.connectionURL;
    }

    public String toString() {
        return this.getJDBCURL();
    }
}

