/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.jdbc.metadata;

import com.metamatrix.common.CommonPlugin;
import java.util.HashMap;
import java.util.Map;

public class IndexType {
    public static final IndexType STATISTIC = new IndexType(0, "Statistic");
    public static final IndexType CLUSTERED = new IndexType(1, "Clustered");
    public static final IndexType HASHED = new IndexType(2, "Hashed");
    public static final IndexType OTHER = new IndexType(3, "Other");
    private int value;
    private String displayName;
    private static final Map BY_NAME = new HashMap();
    private static final Map BY_VALUE = new HashMap();

    private IndexType(int value, String displayName) {
        this.value = value;
        this.displayName = displayName;
    }

    private static void add(IndexType instance) {
        BY_NAME.put(instance.getDisplayName(), instance);
        BY_VALUE.put(new Integer(instance.value), instance);
    }

    public static IndexType getInstance(String displayName) {
        return (IndexType)BY_NAME.get(displayName);
    }

    public static IndexType getInstance(int value) {
        return (IndexType)BY_VALUE.get(new Integer(value));
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int compareTo(Object obj) {
        IndexType that = (IndexType)obj;
        if (obj == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.015.0022"));
        }
        return this.value - that.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IndexType) {
            IndexType that = (IndexType)obj;
            return this.value == that.value;
        }
        return false;
    }

    public final int hashCode() {
        return this.value;
    }

    public final String toString() {
        return this.getDisplayName();
    }

    static {
        IndexType.add(STATISTIC);
        IndexType.add(CLUSTERED);
        IndexType.add(HASHED);
        IndexType.add(OTHER);
    }
}

