/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.jndi;

import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.jgroups.JGroupsManager;
import com.metamatrix.common.jndi.ObjectWrapper;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jgroups.Address;
import org.jgroups.blocks.DistributedHashtable;

public class JNDIRegistry {
    private static DistributedHashtable dht;
    private static JNDIRegistry registry;
    private static Address id;

    private JNDIRegistry() {
    }

    public static synchronized JNDIRegistry getInstance() {
        if (registry == null) {
            try {
                String systemName = null;
                try {
                    systemName = CurrentConfiguration.getSystemName();
                }
                catch (Throwable t2) {
                    systemName = "Default";
                }
                dht = new DistributedHashtable(systemName + "_" + "JNDIRegistry", null, JGroupsManager.getChannelProperties("JNDIRegistry"), 10000L);
                id = dht.getLocalAddress();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            registry = new JNDIRegistry();
            dht.addNotifier((DistributedHashtable.Notification)new Notifier(registry));
            id = dht.getLocalAddress();
        }
        return registry;
    }

    public void bind(String name, Object obj) {
        dht.put((Object)name, (Object)new ObjectWrapper(id, obj));
    }

    public Object lookup(String name) {
        ObjectWrapper wrapper = (ObjectWrapper)dht.get((Object)name);
        if (wrapper == null) {
            return null;
        }
        return wrapper.getObject();
    }

    public void unbind(String name) {
        dht.remove((Object)name);
    }

    public boolean contains(String name) {
        return dht.containsKey((Object)name);
    }

    public Enumeration getAllNames() {
        return dht.keys();
    }

    public void close() {
    }

    protected void removeNode(Address id) {
        Enumeration enumeration = this.getAllNames();
        while (enumeration.hasMoreElements()) {
            Object key = enumeration.nextElement();
            ObjectWrapper wrapper = (ObjectWrapper)dht.get(key);
            if (wrapper == null || !wrapper.getID().equals(id)) continue;
            dht._remove(key);
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public static void main(String[] args) {
        JNDIRegistry.getInstance();
        System.setProperty("java.naming.factory.initial", "com.metamatrix.common.jndi.MMInitialContextFactory");
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
        }
        catch (NamingException e1) {
            e1.printStackTrace();
        }
        try {
            ctx.bind("JNDIRegistry_" + Math.random(), (Object)"JNDIRegistry");
        }
        catch (NamingException e3) {
            e3.printStackTrace();
        }
        while (true) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e2) {
                // empty catch block
            }
            System.out.println("JNDITree:");
            try {
                System.out.println(ctx.list(""));
                continue;
            }
            catch (NamingException e2) {
                e2.printStackTrace();
                continue;
            }
            break;
        }
    }

    static class Notifier
    implements DistributedHashtable.Notification {
        JNDIRegistry registry;

        Notifier(JNDIRegistry reg) {
            this.registry = reg;
        }

        public void entrySet(Object key, Object value) {
        }

        public void entryRemoved(Object key) {
        }

        public void viewChange(Vector new_mbrs, Vector old_mbrs) {
            Iterator iter = old_mbrs.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                this.registry.removeNode((Address)obj);
            }
        }

        public void contentsSet(Map m2) {
        }

        public void contentsCleared() {
        }
    }
}

