/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.log;

import com.metamatrix.common.log.LogConfiguration;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.log.LogMessage;

public final class I18nLogManager {
    private static I18nLogManager INSTANCE = new I18nLogManager();

    private I18nLogManager() {
    }

    public static void logCritical(String context, String msgID, Object[] msgParts) {
        if (msgParts != null) {
            INSTANCE.logMessage(1, msgID, context, msgParts);
        }
    }

    public static void logCritical(String context, String msgID, Object msgPart) {
        if (msgPart != null) {
            INSTANCE.logMessage(1, msgID, context, new Object[]{msgPart});
        }
    }

    public static void logCritical(String context, String msgID) {
        INSTANCE.logMessage(1, msgID, context);
    }

    public static void logCritical(String context, String msgID, Throwable e2) {
        if (e2 != null) {
            INSTANCE.logMessage(1, msgID, context, e2);
        }
    }

    public static void logCritical(String context, String msgID, Throwable e2, Object[] msgParts) {
        if (e2 != null) {
            INSTANCE.logMessage(1, msgID, context, e2, msgParts);
        }
    }

    public static void logCritical(String context, String msgID, Throwable e2, Object msgPart) {
        if (e2 != null) {
            INSTANCE.logMessage(1, msgID, context, e2, new Object[]{msgPart});
        }
    }

    public static void logError(String context, String msgID, Object[] msgParts) {
        if (msgParts != null) {
            INSTANCE.logMessage(2, msgID, context, msgParts);
        }
    }

    public static void logError(String context, String msgID, Object msgPart) {
        if (msgPart != null) {
            INSTANCE.logMessage(2, msgID, context, new Object[]{msgPart});
        }
    }

    public static void logError(String context, String msgID) {
        INSTANCE.logMessage(2, msgID, context);
    }

    public static void logError(String context, String msgID, Throwable e2) {
        if (e2 != null) {
            INSTANCE.logMessage(2, msgID, context, e2);
        }
    }

    public static void logError(String context, Throwable e2) {
        if (e2 != null) {
            INSTANCE.logMessage(2, null, context, e2);
        }
    }

    public static void logError(String context, String msgID, Throwable e2, Object[] msgParts) {
        if (e2 != null) {
            INSTANCE.logMessage(2, msgID, context, e2, msgParts);
        }
    }

    public static void logError(String context, String msgID, Throwable e2, Object msgPart) {
        if (e2 != null) {
            INSTANCE.logMessage(2, msgID, context, e2, new Object[]{msgPart});
        }
    }

    public static void logWarning(String context, String msgID, Object[] msgParts) {
        if (msgParts != null) {
            INSTANCE.logMessage(3, msgID, context, msgParts);
        }
    }

    public static void logWarning(String context, String msgID, Object msgPart) {
        if (msgPart != null) {
            INSTANCE.logMessage(3, msgID, context, new Object[]{msgPart});
        }
    }

    public static void logWarning(String context, String msgID) {
        INSTANCE.logMessage(3, msgID, context);
    }

    public static void logWarning(String context, String msgID, Throwable e2) {
        if (e2 != null) {
            INSTANCE.logMessage(3, msgID, context, e2);
        }
    }

    public static void logWarning(String context, String msgID, Throwable e2, Object[] msgParts) {
        if (e2 != null) {
            INSTANCE.logMessage(3, msgID, context, e2, msgParts);
        }
    }

    public static void logWarning(String context, String msgID, Throwable e2, Object msgPart) {
        if (e2 != null) {
            INSTANCE.logMessage(3, msgID, context, e2, new Object[]{msgPart});
        }
    }

    public static void logInfo(String context, String msgID, Object[] msgParts) {
        if (msgParts != null) {
            INSTANCE.logMessage(4, msgID, context, msgParts);
        }
    }

    public static void logInfo(String context, String msgID, Object msgPart) {
        if (msgPart != null) {
            INSTANCE.logMessage(4, msgID, context, new Object[]{msgPart});
        }
    }

    public static void logInfo(String context, String msgID) {
        INSTANCE.logMessage(4, msgID, context);
    }

    public static void logInfo(String context, String msgID, Throwable e2, Object[] msgParts) {
        if (e2 != null) {
            INSTANCE.logMessage(4, msgID, context, e2, msgParts);
        }
    }

    public static void logDetail(String context, String msgID, Object[] msgParts) {
        if (msgParts != null) {
            INSTANCE.logMessage(5, msgID, context, msgParts);
        }
    }

    public static void logDetail(String context, String msgID, Throwable e2) {
        if (e2 != null) {
            INSTANCE.logMessage(5, msgID, context, e2);
        }
    }

    public static void logDetail(String context, String msgID, Throwable e2, Object[] msgParts) {
        if (e2 != null) {
            INSTANCE.logMessage(5, msgID, context, e2, msgParts);
        }
    }

    public static void logTrace(String context, String msgID, Object[] msgParts) {
        if (msgParts != null) {
            INSTANCE.logMessage(6, msgID, context, msgParts);
        }
    }

    public static void setLogConfiguration(LogConfiguration config) {
        LogManager.setLogConfiguration(config);
    }

    public static boolean isMessageToBeRecorded(String context, int msgLevel) {
        return LogManager.isMessageToBeRecorded(context, msgLevel);
    }

    protected void logMessage(int level, String msgID, String context, Object[] msgParts) {
        if (!LogManager.isMessageToBeRecorded(context, level)) {
            return;
        }
        LogMessage msg = new LogMessage(msgID, context, level, msgParts);
        LogManager.getInstance().forwardMessage(msg);
    }

    protected void logMessage(int level, String msgID, String context) {
        if (!LogManager.isMessageToBeRecorded(context, level)) {
            return;
        }
        LogMessage msg = new LogMessage(msgID, context, level);
        LogManager.getInstance().forwardMessage(msg);
    }

    protected void logMessage(int level, String msgID, String context, Throwable e2) {
        if (!LogManager.isMessageToBeRecorded(context, level)) {
            return;
        }
        LogMessage msg = new LogMessage(msgID, context, level, e2);
        LogManager.getInstance().forwardMessage(msg);
    }

    protected void logMessage(int level, String msgID, String context, Throwable e2, Object[] msgParts) {
        if (!LogManager.isMessageToBeRecorded(context, level)) {
            return;
        }
        LogMessage msg = new LogMessage(msgID, context, level, e2, msgParts);
        LogManager.getInstance().forwardMessage(msg);
    }
}

