/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.log;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.core.proxy.ServiceInterceptor;
import com.metamatrix.core.proxy.ServiceInvocation;
import com.metamatrix.core.struct.ReflectionWrapper;
import com.metamatrix.core.struct.StructHandler;
import com.metamatrix.core.struct.StructWalker;

public class LoggingInterceptor
implements ServiceInterceptor {
    public Object invoke(ServiceInvocation invocation) throws Throwable {
        ReflectionWrapper wrapper;
        LogManager.logInfo("LOG", "Incoming Method: " + invocation.getMethodName());
        Object[] arguments = invocation.getArguments();
        LogManager.logInfo("LOG", "Number of Arguments: " + arguments.length);
        StructWalker walker = new StructWalker(new ArgStructHandler());
        for (int i2 = 0; i2 < arguments.length; ++i2) {
            if (i2 != 0) {
                LogManager.logInfo("LOG", "/>");
            }
            LogManager.logInfo("LOG", "<Argument: " + arguments[i2].getClass().getName());
            wrapper = new ReflectionWrapper(arguments[i2]);
            if (!wrapper.isUserDefined(arguments[i2].getClass())) {
                LogManager.logInfo("LOG", arguments[i2].getClass().getName() + ": '" + arguments[i2] + "' (level: 0)");
                continue;
            }
            walker.walk(arguments[i2], true);
        }
        LogManager.logInfo("LOG", "/>");
        Object result = invocation.invokeNext();
        LogManager.logInfo("LOG", "Outcome of the method invocation:");
        if (result != null) {
            LogManager.logInfo("LOG", "<Result: " + result.getClass().getName());
            wrapper = new ReflectionWrapper(result);
            if (!wrapper.isUserDefined(result.getClass())) {
                LogManager.logInfo("LOG", result.getClass().getName() + ": '" + result + "' (level: 0)");
            } else {
                walker.walk(result, true);
            }
            LogManager.logInfo("LOG", "/>");
        } else {
            LogManager.logInfo("LOG", "<Result: null />");
        }
        return result;
    }

    static class ArgStructHandler
    implements StructHandler {
        ArgStructHandler() {
        }

        public void handle(String name, Integer index, Object struct, int level) {
            if (level != 0 && name != null) {
                LogManager.logInfo("LOG", name + ": '" + struct + "'" + " (level: " + level + ")");
            }
        }
    }
}

