/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.object;

import com.metamatrix.common.object.BooleanValidator;
import com.metamatrix.common.object.ByteValidator;
import com.metamatrix.common.object.DefaultValidator;
import com.metamatrix.common.object.DirectoryEntryValidator;
import com.metamatrix.common.object.DoubleValidator;
import com.metamatrix.common.object.FloatValidator;
import com.metamatrix.common.object.HostnameValidator;
import com.metamatrix.common.object.IntegerValidator;
import com.metamatrix.common.object.LongValidator;
import com.metamatrix.common.object.MultiplicityValidator;
import com.metamatrix.common.object.ObjectIDValidator;
import com.metamatrix.common.object.PasswordValidator;
import com.metamatrix.common.object.PropertiedObjectValidator;
import com.metamatrix.common.object.PropertyTypeValidator;
import com.metamatrix.common.object.RegularExpressionValidator;
import com.metamatrix.common.object.ShortValidator;
import com.metamatrix.common.object.StringValidator;
import com.metamatrix.common.object.URIValidator;
import com.metamatrix.common.object.URLValidator;
import com.metamatrix.common.object.UnboundedIntegerValidator;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public final class StandardPropertyTypeValidator
implements Serializable {
    private static final PropertyTypeValidator DEFAULT_VALIDATOR = new DefaultValidator();
    public static final Map STANDARD_VALIDATORS = new HashMap();

    public static PropertyTypeValidator lookup(String typeName) {
        PropertyTypeValidator result = (PropertyTypeValidator)STANDARD_VALIDATORS.get(typeName);
        if (result == null) {
            result = DEFAULT_VALIDATOR;
        }
        return result;
    }

    public static boolean isValidValue(Object[] values, PropertyTypeValidator validator) {
        for (int i2 = 0; i2 < values.length; ++i2) {
            if (validator.isValidValue(values[i2])) continue;
            return false;
        }
        return true;
    }

    static {
        STANDARD_VALIDATORS.put("String", new StringValidator());
        STANDARD_VALIDATORS.put("Integer", new IntegerValidator());
        STANDARD_VALIDATORS.put("Long", new LongValidator());
        STANDARD_VALIDATORS.put("Float", new FloatValidator());
        STANDARD_VALIDATORS.put("Double", new DoubleValidator());
        STANDARD_VALIDATORS.put("Byte", new ByteValidator());
        STANDARD_VALIDATORS.put("Short", new ShortValidator());
        STANDARD_VALIDATORS.put("Boolean", new BooleanValidator());
        STANDARD_VALIDATORS.put("Time", new DefaultValidator());
        STANDARD_VALIDATORS.put("Date", new DefaultValidator());
        STANDARD_VALIDATORS.put("Timestamp", new DefaultValidator());
        STANDARD_VALIDATORS.put("List", new DefaultValidator());
        STANDARD_VALIDATORS.put("Set", new DefaultValidator());
        STANDARD_VALIDATORS.put("URL", new URLValidator());
        STANDARD_VALIDATORS.put("URI", new URIValidator());
        STANDARD_VALIDATORS.put("Hostname", new HostnameValidator());
        STANDARD_VALIDATORS.put("File", new DirectoryEntryValidator());
        STANDARD_VALIDATORS.put("ObjectID", new ObjectIDValidator());
        STANDARD_VALIDATORS.put("Multiplicity", new MultiplicityValidator());
        STANDARD_VALIDATORS.put("Password", new PasswordValidator());
        STANDARD_VALIDATORS.put("PropertiedObject", new PropertiedObjectValidator());
        STANDARD_VALIDATORS.put("ResourceDescriptor", new DefaultValidator());
        STANDARD_VALIDATORS.put("ObjectReference", new DefaultValidator());
        STANDARD_VALIDATORS.put("DataType", new DefaultValidator());
        STANDARD_VALIDATORS.put("UnboundedInteger", new UnboundedIntegerValidator());
        STANDARD_VALIDATORS.put("RegularExpression", new RegularExpressionValidator());
    }
}

