/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.tree.basic;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.object.DefaultPropertyAccessPolicy;
import com.metamatrix.common.object.ObjectDefinition;
import com.metamatrix.common.object.PropertiedObject;
import com.metamatrix.common.object.PropertyAccessPolicy;
import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.common.transaction.UserTransaction;
import com.metamatrix.common.transaction.UserTransactionFactory;
import com.metamatrix.common.transaction.manager.SimpleUserTransactionFactory;
import com.metamatrix.common.tree.TreeNode;
import com.metamatrix.common.tree.TreeNodeEditor;
import com.metamatrix.common.tree.basic.BasicTreeNode;
import com.metamatrix.common.tree.directory.DirectoryEntry;
import com.metamatrix.common.util.exception.AssertionException;
import com.metamatrix.core.id.ObjectID;
import com.metamatrix.core.id.ObjectIDFactory;
import com.metamatrix.core.util.Assertion;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BasicTreeNodeEditor
implements TreeNodeEditor {
    private ObjectIDFactory idFactory;
    private PropertyAccessPolicy policy;
    private UserTransactionFactory txnFactory;

    public BasicTreeNodeEditor(ObjectIDFactory idFactory, PropertyAccessPolicy policy, UserTransactionFactory txnFactory) {
        Assertion.isNotNull(idFactory, "The ObjectIDFactory reference may not be null");
        Assertion.isNotNull(policy, "The PropertyAccessPolicy reference may not be null");
        Assertion.isNotNull(txnFactory, "The UserTransactionFactory reference may not be null");
        this.idFactory = idFactory;
        this.policy = policy;
        this.txnFactory = txnFactory;
    }

    public BasicTreeNodeEditor(ObjectIDFactory idFactory) {
        this(idFactory, new DefaultPropertyAccessPolicy(), new SimpleUserTransactionFactory());
    }

    public BasicTreeNodeEditor(ObjectIDFactory idFactory, PropertyAccessPolicy policy) {
        this(idFactory, policy, new SimpleUserTransactionFactory());
    }

    public BasicTreeNodeEditor(ObjectIDFactory idFactory, UserTransactionFactory txnFactory) {
        this(idFactory, new DefaultPropertyAccessPolicy(), txnFactory);
    }

    protected BasicTreeNode assertBasicTreeNode(PropertiedObject obj) {
        Assertion.isNotNull(obj, "The PropertiedObject reference may not be null");
        Assertion.assertTrue(obj instanceof BasicTreeNode, "The referenced object must be an instance of BasicTreeNode");
        return (BasicTreeNode)obj;
    }

    public List getPropertyDefinitions(PropertiedObject obj) {
        BasicTreeNode entity = this.assertBasicTreeNode(obj);
        return entity.getPropertyDefinitions();
    }

    public List getAllowedValues(PropertiedObject obj, PropertyDefinition def) {
        Assertion.isNotNull(def, "The PropertyDefinition reference may not be null");
        return def.getAllowedValues();
    }

    public Object getValue(PropertiedObject obj, PropertyDefinition def) {
        BasicTreeNode entity = this.assertBasicTreeNode(obj);
        Assertion.isNotNull(def, "The PropertyDefinition reference may not be null");
        return entity.getPropertyValue(def);
    }

    public boolean isValidValue(PropertiedObject obj, PropertyDefinition def, Object value) {
        BasicTreeNode entity = this.assertBasicTreeNode(obj);
        Assertion.isNotNull(def, "The PropertyDefinition reference may not be null");
        if (value == null) {
            return def.getMultiplicity().getMinimum() == 0;
        }
        if (entity.getNamePropertyDefinition() == def) {
            if (!(value instanceof String)) {
                return false;
            }
            return entity.isValidNewName(value.toString());
        }
        return def.getPropertyType().isValidValue(value);
    }

    public void setValue(PropertiedObject obj, PropertyDefinition def, Object value) {
        BasicTreeNode entity = this.assertBasicTreeNode(obj);
        Assertion.isNotNull(def, "The PropertyDefinition reference may not be null");
        if (this.isReadOnly(obj, def)) {
            throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.028.0023"));
        }
        entity.setPropertyValue(def, value);
        if (entity.getNamePropertyDefinition() == def) {
            entity.setName(value.toString());
        }
    }

    public PropertyAccessPolicy getPolicy() {
        return this.policy;
    }

    public void setPolicy(PropertyAccessPolicy policy) {
        this.policy = policy == null ? new DefaultPropertyAccessPolicy() : policy;
    }

    public boolean isReadOnly(PropertiedObject obj) {
        Assertion.isNotNull(obj, "The PropertiedObject reference may not be null");
        return this.policy.isReadOnly(obj);
    }

    public boolean isReadOnly(PropertiedObject obj, PropertyDefinition def) {
        Assertion.isNotNull(obj, "The PropertiedObject reference may not be null");
        Assertion.isNotNull(def, "The PropertyDefinition reference may not be null");
        return this.policy.isReadOnly(obj, def);
    }

    public void setReadOnly(PropertiedObject obj, PropertyDefinition def, boolean readOnly) {
        Assertion.isNotNull(obj, "The PropertiedObject reference may not be null");
        Assertion.isNotNull(def, "The PropertyDefinition reference may not be null");
        this.policy.setReadOnly(obj, def, readOnly);
    }

    public void setReadOnly(PropertiedObject obj, boolean readOnly) {
        Assertion.isNotNull(obj, "The PropertiedObject reference may not be null");
        this.policy.setReadOnly(obj, readOnly);
    }

    public void reset(PropertiedObject obj) {
        Assertion.isNotNull(obj, "The PropertiedObject reference may not be null");
        this.policy.reset(obj);
    }

    public UserTransaction createReadTransaction() {
        return this.txnFactory.createReadTransaction();
    }

    public UserTransaction createWriteTransaction() {
        return this.txnFactory.createWriteTransaction();
    }

    public UserTransaction createWriteTransaction(Object source) {
        return this.txnFactory.createWriteTransaction(source);
    }

    public void setMarked(TreeNode node, boolean marked) {
        BasicTreeNode entity = this.assertBasicTreeNode(node);
        entity.setMarked(marked);
    }

    public boolean isMarked(TreeNode node) {
        BasicTreeNode entity = this.assertBasicTreeNode(node);
        return entity.isMarked();
    }

    public boolean isParentOf(TreeNode parent, TreeNode child) {
        BasicTreeNode parentEntity = this.assertBasicTreeNode(parent);
        BasicTreeNode childEntity = this.assertBasicTreeNode(child);
        return parentEntity.isParentOf(childEntity);
    }

    public boolean isAncestorOf(TreeNode ancestor, TreeNode descendent) {
        BasicTreeNode ancestorEntity = this.assertBasicTreeNode(ancestor);
        BasicTreeNode descendentEntity = this.assertBasicTreeNode(descendent);
        return ancestorEntity.isAncestorOf(descendentEntity);
    }

    public TreeNode create(TreeNode parent, ObjectDefinition type) {
        return this.create(parent, null, type);
    }

    public TreeNode create(TreeNode parent, String name, ObjectDefinition type) {
        if (this.isReadOnly(parent)) {
            throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.028.0023"));
        }
        BasicTreeNode parentEntity = this.assertBasicTreeNode(parent);
        ObjectID guid = this.idFactory.create();
        BasicTreeNode newChild = new BasicTreeNode(parentEntity, name, type, guid);
        return newChild;
    }

    public boolean delete(TreeNode node) {
        if (this.isReadOnly(node)) {
            throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.028.0023"));
        }
        BasicTreeNode nodeEntity = this.assertBasicTreeNode(node);
        BasicTreeNode parentEntity = nodeEntity.getParent();
        parentEntity.getIndexOfChild(nodeEntity);
        parentEntity.remove(nodeEntity);
        return true;
    }

    public TreeNode paste(TreeNode original, TreeNode newParent, boolean deepCopy) {
        return this.paste(original, newParent, deepCopy, false);
    }

    public TreeNode paste(TreeNode original, TreeNode newParent) {
        return this.paste(original, newParent, true, false);
    }

    public TreeNode paste(TreeNode original, TreeNode newParent, boolean deepCopy, boolean forceCopy) {
        Assertion.assertTrue(deepCopy, "Only a deep copy operations are allowed");
        if (this.isReadOnly(newParent)) {
            throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.028.0024", newParent));
        }
        BasicTreeNode originalEntity = this.assertBasicTreeNode(original);
        BasicTreeNode newParentEntity = this.assertBasicTreeNode(newParent);
        BasicTreeNode newChildEntity = originalEntity;
        if (forceCopy || original.exists()) {
            newChildEntity = this.cloneBasicTreeNode(originalEntity, null, deepCopy);
        }
        newParentEntity.add(newChildEntity);
        return newChildEntity;
    }

    public boolean move(TreeNode original, TreeNode newParent) {
        if (this.isReadOnly(original)) {
            throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.028.0023"));
        }
        BasicTreeNode originalEntity = this.assertBasicTreeNode(original);
        BasicTreeNode newParentEntity = this.assertBasicTreeNode(newParent);
        BasicTreeNode originalParentEntity = originalEntity.getParent();
        if (newParent == originalParentEntity) {
            return false;
        }
        newParentEntity.add(originalEntity);
        return true;
    }

    public boolean move(TreeNode node, TreeNode newParent, int indexInNewParent) {
        if (this.isReadOnly(node)) {
            throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.028.0023"));
        }
        BasicTreeNode originalEntity = this.assertBasicTreeNode(node);
        BasicTreeNode newParentEntity = this.assertBasicTreeNode(newParent);
        BasicTreeNode originalParentEntity = originalEntity.getParent();
        if (newParent == originalParentEntity && indexInNewParent != originalParentEntity.getIndexOfChild(originalEntity)) {
            return this.moveChild(node, indexInNewParent);
        }
        newParentEntity.add(originalEntity, indexInNewParent);
        return true;
    }

    public boolean moveChild(TreeNode child, int newIndex) {
        if (this.isReadOnly(child)) {
            throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.028.0023"));
        }
        BasicTreeNode childEntity = this.assertBasicTreeNode(child);
        BasicTreeNode parentEntity = childEntity.getParent();
        if (parentEntity == null) {
            if (newIndex != 0) {
                throw new IndexOutOfBoundsException(CommonPlugin.Util.getString("ERR.003.028.0025"));
            }
            return false;
        }
        parentEntity.moveChild(childEntity, newIndex);
        return true;
    }

    public boolean rename(TreeNode node, String newName) {
        if (this.isReadOnly(node)) {
            throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.028.0023"));
        }
        BasicTreeNode childEntity = this.assertBasicTreeNode(node);
        if (!childEntity.isValidNewName(newName)) {
            return false;
        }
        childEntity.setName(newName);
        return true;
    }

    public PropertyDefinition getNamePropertyDefinition(TreeNode obj) {
        BasicTreeNode entity = this.assertBasicTreeNode(obj);
        return entity.getNamePropertyDefinition();
    }

    public PropertyDefinition getDescriptionPropertyDefinition(TreeNode obj) {
        BasicTreeNode entity = this.assertBasicTreeNode(obj);
        return entity.getDescriptionPropertyDefinition();
    }

    protected BasicTreeNode cloneBasicTreeNode(BasicTreeNode original, BasicTreeNode newParent, boolean deep) {
        ObjectID guid = this.idFactory.create();
        BasicTreeNode copy = new BasicTreeNode(newParent, original.getName(), original.getType(), guid);
        Map originalProps = original.getProperties();
        Iterator iter = originalProps.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            PropertyDefinition key = (PropertyDefinition)entry.getKey();
            Object value = entry.getValue();
            copy.setPropertyValue(key, this.copyPropertyValue(value));
        }
        if (deep) {
            iter = original.iterator();
            while (iter.hasNext()) {
                BasicTreeNode child = (BasicTreeNode)iter.next();
                this.cloneBasicTreeNode(child, copy, deep);
            }
        }
        return copy;
    }

    protected Object copyPropertyValue(Object value) {
        if (value == null) {
            return value;
        }
        if (value instanceof String) {
            return value.toString();
        }
        if (value instanceof ObjectID) {
            return value;
        }
        if (value instanceof DirectoryEntry) {
            return value;
        }
        if (value instanceof List) {
            List valueList = (List)value;
            ArrayList<Object> result = new ArrayList<Object>(valueList.size());
            Iterator iter = valueList.iterator();
            while (iter.hasNext()) {
                result.add(this.copyPropertyValue(iter.next()));
            }
            return result;
        }
        throw new AssertionException("ERR.003.028.0026", CommonPlugin.Util.getString("ERR.003.028.0026", value.getClass().getName()));
    }
}

