/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.tree.directory;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.util.OSPlatformUtil;
import com.metamatrix.common.util.exception.AssertionException;
import com.metamatrix.core.util.Assertion;
import java.io.File;
import java.io.PrintStream;
import java.util.Properties;

public class PlatformAwareFilePermission {
    private static String SEPARATOR = File.separator;
    private static int operatingSystem = -1;

    public static final int getOperatingSystem() {
        return operatingSystem;
    }

    public static final boolean isWindows() {
        return OSPlatformUtil.isWindows();
    }

    public static final boolean isUnix() {
        return OSPlatformUtil.isUnix();
    }

    public static boolean changeReadOnly(File dir, String filespec, boolean makeRO) {
        if (PlatformAwareFilePermission.isWindows()) {
            if (operatingSystem == 2 || operatingSystem == 4) {
                boolean success = PlatformAwareFilePermission.changeReadOnlyWin95(dir, filespec, makeRO);
                if (!success) {
                    success = PlatformAwareFilePermission.changeReadOnlyWin95_V2(dir, filespec, makeRO);
                }
                return success;
            }
            if (operatingSystem == 4096) {
                return PlatformAwareFilePermission.changeReadOnlyWin2000(dir, filespec, makeRO);
            }
            if (operatingSystem == 16384) {
                return PlatformAwareFilePermission.changeReadOnlyWin2000(dir, filespec, makeRO);
            }
            boolean success = PlatformAwareFilePermission.changeReadOnlyWinNT(dir, filespec, makeRO);
            if (!success) {
                success = PlatformAwareFilePermission.changeReadOnlyWinNT_V2(dir, filespec, makeRO);
            }
            return success;
        }
        if (PlatformAwareFilePermission.isUnix()) {
            return PlatformAwareFilePermission.changeReadOnlyUnix(dir, filespec, makeRO);
        }
        throw new AssertionException("ERR.003.028.0056", CommonPlugin.Util.getString("ERR.003.028.0056", System.getProperty(OSPlatformUtil.OS_PROPERTY_NAME)));
    }

    private static boolean changeReadOnlyUnix(File dir, String filespec, boolean makeRO) {
        int exitcode;
        String[] attrib = new String[]{"chmod", makeRO ? "u-w" : "u+wr,g+wr"};
        try {
            String dirpath = dir.getCanonicalPath();
            attrib[1] = attrib[1] + " " + dirpath + SEPARATOR + filespec + "";
            Runtime rt = Runtime.getRuntime();
            String cmd = attrib[0] + " " + attrib[1];
            Process proc = rt.exec(cmd);
            proc.waitFor();
            exitcode = proc.exitValue();
        }
        catch (Exception e2) {
            return false;
        }
        return exitcode == 0;
    }

    private static boolean changeReadOnlyWin95(File dir, String filespec, boolean makeRO) {
        int exitcode;
        String[] attrib = new String[]{"c:\\windows\\command\\attrib.exe", makeRO ? "+R" : "-R"};
        try {
            String dirpath = dir.getCanonicalPath();
            attrib[1] = attrib[1] + " \"" + dirpath + SEPARATOR + filespec + "\"";
            Runtime rt = Runtime.getRuntime();
            String cmd = attrib[0] + " " + attrib[1];
            Process proc = rt.exec(cmd);
            proc.waitFor();
            exitcode = proc.exitValue();
        }
        catch (Exception e2) {
            return false;
        }
        return exitcode == 0;
    }

    private static boolean changeReadOnlyWin95_V2(File dir, String filespec, boolean makeRO) {
        int exitcode;
        String[] attrib = new String[]{"attrib.exe", makeRO ? "+R" : "-R"};
        try {
            String dirpath = dir.getCanonicalPath();
            attrib[1] = attrib[1] + " \"" + dirpath + SEPARATOR + filespec + "\"";
            Runtime rt = Runtime.getRuntime();
            String cmd = attrib[0] + " " + attrib[1];
            Process proc = rt.exec(cmd);
            proc.waitFor();
            exitcode = proc.exitValue();
        }
        catch (Exception e2) {
            return false;
        }
        return exitcode == 0;
    }

    private static boolean changeReadOnlyWin2000(File dir, String filespec, boolean makeRO) {
        int exitcode;
        String[] attrib = new String[]{"cmd.exe /c attrib", makeRO ? "+R" : "-R"};
        try {
            String dirpath = dir.getCanonicalPath();
            attrib[1] = attrib[1] + " \"" + dirpath + SEPARATOR + filespec + "\"";
            Runtime rt = Runtime.getRuntime();
            String cmd = attrib[0] + " " + attrib[1];
            Process proc = rt.exec(cmd);
            proc.waitFor();
            exitcode = proc.exitValue();
        }
        catch (Exception e2) {
            return false;
        }
        return exitcode == 0;
    }

    private static boolean changeReadOnlyWinNT(File dir, String filespec, boolean makeRO) {
        int exitcode;
        String[] attrib = new String[]{"c:\\WINNT\\system32\\attrib.exe", makeRO ? "+R" : "-R"};
        try {
            String dirpath = dir.getCanonicalPath();
            attrib[1] = attrib[1] + " \"" + dirpath + SEPARATOR + filespec + "\"";
            Runtime rt = Runtime.getRuntime();
            String cmd = attrib[0] + " " + attrib[1];
            Process proc = rt.exec(cmd);
            proc.waitFor();
            exitcode = proc.exitValue();
        }
        catch (Exception e2) {
            return false;
        }
        return exitcode == 0;
    }

    private static boolean changeReadOnlyWinNT_V2(File dir, String filespec, boolean makeRO) {
        int exitcode;
        String[] attrib = new String[]{"attrib.exe", makeRO ? "+R" : "-R"};
        try {
            String dirpath = dir.getCanonicalPath();
            attrib[1] = attrib[1] + " \"" + dirpath + SEPARATOR + filespec + "\"";
            Runtime rt = Runtime.getRuntime();
            String cmd = attrib[0] + " " + attrib[1];
            Process proc = rt.exec(cmd);
            proc.waitFor();
            exitcode = proc.exitValue();
        }
        catch (Exception e2) {
            return false;
        }
        return exitcode == 0;
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.println("Usage: PlatformAwareFilePermission dirPath fileName +r|-r");
            return;
        }
        try {
            PlatformAwareFilePermission.printSystemProperties(System.out);
            String dirPath = args[0];
            String filename = args[1];
            String permission = args[2];
            PlatformAwareFilePermission.testChangePermission(dirPath, filename, permission);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    static void printSystemProperties(PrintStream stream) {
        Assertion.isNotNull(stream, "The PrintStream reference may not be null");
        Properties p2 = System.getProperties();
        p2.list(stream);
    }

    static void printPermissions(File f2, String action) {
        System.out.println("\nFile \"" + f2 + "\" action = " + action);
        System.out.println("exists  = " + f2.exists() + " canRead = " + f2.canRead() + " canWrite = " + f2.canWrite());
    }

    static void printRuntimeCmd(String methodName, String cmd) {
        System.out.println("\n[" + methodName + "] Runtime.exec( " + cmd + " )");
    }

    static void testChangePermission(String dirPath, String filename, String permission) {
        boolean makeRO = true;
        if (permission.equalsIgnoreCase("-r")) {
            makeRO = false;
        }
        File dir = new File(dirPath);
        File f2 = new File(dir, filename);
        PlatformAwareFilePermission.changeReadOnly(dir, filename, makeRO);
        PlatformAwareFilePermission.printPermissions(f2, "after changing permission to  " + permission);
    }

    static {
        operatingSystem = OSPlatformUtil.getOperatingSystem();
    }
}

