/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.util;

import java.text.StringCharacterIterator;

public class VDBNameValidator {
    static String[] reservedVDBNames = new String[]{"System", "Admin", "Help"};
    static String[] reservedSourceNames = new String[]{"System"};

    public static boolean isValid(String vdbName) {
        if (vdbName == null || vdbName.length() == 0) {
            return false;
        }
        if (VDBNameValidator.containsInvalidChars(vdbName)) {
            return false;
        }
        for (int i2 = 0; i2 < reservedVDBNames.length; ++i2) {
            if (!vdbName.equalsIgnoreCase(reservedVDBNames[i2])) continue;
            return false;
        }
        return true;
    }

    public static boolean isSourceValid(String sourceName) {
        if (sourceName == null || sourceName.length() == 0) {
            return false;
        }
        if (VDBNameValidator.containsInvalidChars(sourceName)) {
            return false;
        }
        return !VDBNameValidator.isSourceNameReserved(sourceName);
    }

    public static boolean isSourceNameReserved(String sourceName) {
        for (int i2 = 0; i2 < reservedSourceNames.length; ++i2) {
            if (!sourceName.equalsIgnoreCase(reservedVDBNames[i2])) continue;
            return true;
        }
        return false;
    }

    private static boolean containsInvalidChars(String vdbName) {
        StringCharacterIterator charIterator = new StringCharacterIterator(vdbName);
        char c2 = charIterator.first();
        if (c2 != '\uffff') {
            if (!Character.isLetter(c2)) {
                return true;
            }
        } else {
            return true;
        }
        do {
            if ((c2 = charIterator.next()) != '\uffff') continue;
            return false;
        } while (!(!Character.isLetterOrDigit(c2) & c2 != '_'));
        return true;
    }
}

