/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.util.crypto;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.CryptoFactory;
import com.metamatrix.common.util.crypto.CryptoUtil;
import com.metamatrix.common.util.crypto.Cryptor;
import com.metamatrix.common.util.crypto.Decryptor;
import com.metamatrix.common.util.crypto.Encryptor;
import com.metamatrix.common.util.crypto.NullCryptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;

public class PasswordCryptoFactory {
    public static final String KEYSTORE_NAME = "metamatrixpki.keystore";
    public static final String DEFAULT_KEY_NAME = "encrypt";
    private static boolean initialized = false;
    public static final String PASS_KEY_NAME = "metamatrix.security.password.PasswordKeyStore";

    public static synchronized void init() throws CryptoException {
        if (!CryptoUtil.isEncryptionEnabled()) {
            return;
        }
        if (!initialized) {
            char[] storePass = PasswordCryptoFactory.getStorePass();
            String keyName = PasswordCryptoFactory.getKeyName();
            try {
                CryptoFactory.init(KEYSTORE_NAME, storePass, keyName);
            }
            catch (FileNotFoundException e2) {
                throw new CryptoException((Throwable)e2, "ERR.003.030.0068", CommonPlugin.Util.getString("ERR.003.030.0068", e2.getMessage()));
            }
            catch (IOException e3) {
                throw new CryptoException((Throwable)e3, "ERR.003.030.0068", CommonPlugin.Util.getString("ERR.003.030.0068", e3.getMessage()));
            }
            initialized = true;
        }
    }

    public static synchronized void init(char[] storePass) throws CryptoException {
        if (!CryptoUtil.isEncryptionEnabled()) {
            return;
        }
        if (!initialized) {
            String keyName = PasswordCryptoFactory.getKeyName();
            try {
                CryptoFactory.init(KEYSTORE_NAME, storePass, keyName);
            }
            catch (FileNotFoundException e2) {
                throw new CryptoException((Throwable)e2, "ERR.003.030.0068", CommonPlugin.Util.getString("ERR.003.030.0068", e2.getMessage()));
            }
            catch (IOException e3) {
                throw new CryptoException((Throwable)e3, "ERR.003.030.0068", CommonPlugin.Util.getString("ERR.003.030.0068", e3.getMessage()));
            }
            initialized = true;
        }
    }

    public static synchronized void init(String storeFilename, char[] storePass) throws CryptoException {
        if (!CryptoUtil.isEncryptionEnabled()) {
            return;
        }
        if (!initialized) {
            String keyName = PasswordCryptoFactory.getKeyName();
            try {
                CryptoFactory.init(storeFilename, storePass, keyName, false);
            }
            catch (FileNotFoundException e2) {
                throw new CryptoException((Throwable)e2, "ERR.003.030.0068", CommonPlugin.Util.getString("ERR.003.030.0068", e2.getMessage()));
            }
            catch (IOException e3) {
                throw new CryptoException((Throwable)e3, "ERR.003.030.0068", CommonPlugin.Util.getString("ERR.003.030.0068", e3.getMessage()));
            }
            initialized = true;
        }
    }

    public static synchronized void init(URL storeFilename, char[] storePass) throws CryptoException {
        if (!CryptoUtil.isEncryptionEnabled()) {
            return;
        }
        if (!initialized) {
            String keyName = PasswordCryptoFactory.getKeyName();
            try {
                CryptoFactory.init(storeFilename, storePass, keyName);
            }
            catch (FileNotFoundException e2) {
                throw new CryptoException((Throwable)e2, "ERR.003.030.0068", CommonPlugin.Util.getString("ERR.003.030.0068", e2.getMessage()));
            }
            catch (IOException e3) {
                throw new CryptoException((Throwable)e3, "ERR.003.030.0068", CommonPlugin.Util.getString("ERR.003.030.0068", e3.getMessage()));
            }
            initialized = true;
        }
    }

    private static String getKeyName() {
        String keyName = null;
        return keyName != null ? keyName : DEFAULT_KEY_NAME;
    }

    private static char[] getStorePass() throws CryptoException {
        String passKey = CurrentConfiguration.getProperty(PASS_KEY_NAME);
        if (passKey == null || passKey.length() == 0) {
            throw new CryptoException("ERR.003.030.0069", CommonPlugin.Util.getString("ERR.003.030.0069"));
        }
        return passKey.toCharArray();
    }

    public static synchronized Cryptor getCryptor() throws CryptoException {
        if (!CryptoUtil.isEncryptionEnabled()) {
            return new NullCryptor();
        }
        PasswordCryptoFactory.init();
        return CryptoFactory.getCryptor();
    }

    public static synchronized Encryptor getEncryptor() throws CryptoException {
        if (!CryptoUtil.isEncryptionEnabled()) {
            return new NullCryptor();
        }
        PasswordCryptoFactory.init();
        return CryptoFactory.getEncryptor();
    }

    public static synchronized Decryptor getDecryptor() throws CryptoException {
        if (!CryptoUtil.isEncryptionEnabled()) {
            return new NullCryptor();
        }
        PasswordCryptoFactory.init();
        return CryptoFactory.getDecryptor();
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("usage: PasswordCryptoFactory keyStorePass [cleartext]");
            System.exit(-1);
        }
        char[] storePass = args[0].toCharArray();
        String cleartext = args.length > 1 ? args[1] : "Clear text.";
        System.out.println("\nCleartext (length " + cleartext.length() + "): " + cleartext);
        String argle = new String(CryptoFactory.argle(cleartext.toCharArray()));
        System.out.println("\nArgled cleartext: " + argle);
        System.out.println("Deargled cleartext: " + new String(CryptoFactory.deArgle(argle.toCharArray())));
        PasswordCryptoFactory.init(storePass);
        Encryptor encryptor = PasswordCryptoFactory.getEncryptor();
        char[] clearChars = cleartext.toCharArray();
        char[] cipherChars = encryptor.encrypt(clearChars);
        String ciphertext = new String(cipherChars);
        System.out.println("\nCiphertext (length " + ciphertext.length() + ", ratio " + PasswordCryptoFactory.getRatio(cleartext, ciphertext) + "):\n" + ciphertext);
        Decryptor decryptor = PasswordCryptoFactory.getDecryptor();
        char[] clearChars2 = decryptor.decrypt(cipherChars);
        PasswordCryptoFactory.checkEncryptDecrypt(cleartext, clearChars2);
        Cryptor cryptor = PasswordCryptoFactory.getCryptor();
        char[] clearChars3 = cryptor.decrypt(cipherChars);
        PasswordCryptoFactory.checkEncryptDecrypt(cleartext, clearChars3);
    }

    static void checkEncryptDecrypt(String cleartext, char[] clearChars2) {
        String cleartext2 = new String(clearChars2);
        if (cleartext2.equals(cleartext)) {
            System.out.println(CommonPlugin.Util.getString("MSG.003.030.0030"));
        } else {
            System.out.println(CommonPlugin.Util.getString("ERR.003.030.0058"));
        }
    }

    static float getRatio(String s1, String s2) {
        float ratio = (float)s2.length() / (float)s1.length();
        return (float)((int)(100.0f * ratio)) / 100.0f;
    }
}

