/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.xa.log;

import com.metamatrix.common.config.JDBCConnectionPoolHelper;
import com.metamatrix.common.id.dbid.DBIDGenerator;
import com.metamatrix.common.id.dbid.DBIDGeneratorException;
import com.metamatrix.common.jdbc.JDBCPlatform;
import com.metamatrix.common.jdbc.JDBCPlatformFactory;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.util.DateUtil;
import com.metamatrix.common.xa.CommonXAPlugin;
import com.metamatrix.common.xa.log.TransactionLogMessage;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import java.util.Properties;

public class TransactionLogWriter {
    public static final int DEFAULT_MAX_VDB_NAME_LENGTH = 255;
    public static final int DEFAULT_MAX_VDB_VERSION_LENGTH = 50;
    public static final int DEFAULT_MAX_CNCTR_NAME_LENGTH = 255;
    public static final int DEFAULT_MAX_MDL_NAME_LENGTH = 255;
    public static final int DEFAULT_MAX_SQL_LENGTH = 512;
    private static final int WAIT_TIME = 60;
    private static final int RETRY_TIME = 5;
    private static final int WRITE_RETRIES = 1;
    private static final int RESUME_LOGGING_AFTER_TIME = 1800000;
    private Connection con;
    private Properties connProps;
    private PreparedStatement txnStmt;
    private PreparedStatement mmxcmdStmt;
    private PreparedStatement srccmdStmt;
    private PreparedStatement sqlValueStmt;
    private JDBCPlatform jdbcPlatform;
    private StringBuffer txnLogInsertStr;
    private StringBuffer mmxcmdLogInsertStr;
    private StringBuffer srccmdLogInsertStr;
    private StringBuffer sqlValueInsertStr;
    private boolean isLogSuspended = false;
    private long resumeTime = -1L;
    private boolean shutdown = false;

    public void initialize(Properties props) throws Exception {
        this.txnLogInsertStr = new StringBuffer("INSERT INTO ");
        this.txnLogInsertStr.append("TX_TXNLOG");
        this.txnLogInsertStr.append(" (");
        this.txnLogInsertStr.append("TXNUID");
        this.txnLogInsertStr.append(',');
        this.txnLogInsertStr.append("TXNPOINT");
        this.txnLogInsertStr.append(',');
        this.txnLogInsertStr.append("TXN_STATUS");
        this.txnLogInsertStr.append(',');
        this.txnLogInsertStr.append("SESSIONUID");
        this.txnLogInsertStr.append(',');
        this.txnLogInsertStr.append("PRINCIPAL_NA");
        this.txnLogInsertStr.append(',');
        this.txnLogInsertStr.append("VDBNAME");
        this.txnLogInsertStr.append(',');
        this.txnLogInsertStr.append("VDBVERSION");
        this.txnLogInsertStr.append(',');
        this.txnLogInsertStr.append("CREATED_TS");
        this.txnLogInsertStr.append(',');
        this.txnLogInsertStr.append("ENDED_TS");
        this.txnLogInsertStr.append(") VALUES (?,?,?,?,?,?,?,?,?)");
        this.mmxcmdLogInsertStr = new StringBuffer("INSERT INTO ");
        this.mmxcmdLogInsertStr.append("TX_MMXCMDLOG");
        this.mmxcmdLogInsertStr.append(" (");
        this.mmxcmdLogInsertStr.append("REQUESTID");
        this.mmxcmdLogInsertStr.append(',');
        this.mmxcmdLogInsertStr.append("TXNUID");
        this.mmxcmdLogInsertStr.append(',');
        this.mmxcmdLogInsertStr.append("CMDPOINT");
        this.mmxcmdLogInsertStr.append(',');
        this.mmxcmdLogInsertStr.append("CMD_STATUS");
        this.mmxcmdLogInsertStr.append(',');
        this.mmxcmdLogInsertStr.append("SESSIONUID");
        this.mmxcmdLogInsertStr.append(',');
        this.mmxcmdLogInsertStr.append("APP_NAME");
        this.mmxcmdLogInsertStr.append(',');
        this.mmxcmdLogInsertStr.append("PRINCIPAL_NA");
        this.mmxcmdLogInsertStr.append(',');
        this.mmxcmdLogInsertStr.append("VDBNAME");
        this.mmxcmdLogInsertStr.append(',');
        this.mmxcmdLogInsertStr.append("VDBVERSION");
        this.mmxcmdLogInsertStr.append(',');
        this.mmxcmdLogInsertStr.append("CREATED_TS");
        this.mmxcmdLogInsertStr.append(',');
        this.mmxcmdLogInsertStr.append("ENDED_TS");
        this.mmxcmdLogInsertStr.append(',');
        this.mmxcmdLogInsertStr.append("FINL_ROWCNT");
        this.mmxcmdLogInsertStr.append(',');
        this.mmxcmdLogInsertStr.append("SQL_ID");
        this.mmxcmdLogInsertStr.append(") VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)");
        this.srccmdLogInsertStr = new StringBuffer("INSERT INTO ");
        this.srccmdLogInsertStr.append("TX_SRCCMDLOG");
        this.srccmdLogInsertStr.append(" (");
        this.srccmdLogInsertStr.append("REQUESTID");
        this.srccmdLogInsertStr.append(',');
        this.srccmdLogInsertStr.append("NODEID");
        this.srccmdLogInsertStr.append(',');
        this.srccmdLogInsertStr.append("SUBTXNUID");
        this.srccmdLogInsertStr.append(',');
        this.srccmdLogInsertStr.append("CMD_STATUS");
        this.srccmdLogInsertStr.append(',');
        this.srccmdLogInsertStr.append("MDL_NM");
        this.srccmdLogInsertStr.append(',');
        this.srccmdLogInsertStr.append("CNCTRNAME");
        this.srccmdLogInsertStr.append(',');
        this.srccmdLogInsertStr.append("CMDPOINT");
        this.srccmdLogInsertStr.append(',');
        this.srccmdLogInsertStr.append("SESSIONUID");
        this.srccmdLogInsertStr.append(',');
        this.srccmdLogInsertStr.append("PRINCIPAL_NA");
        this.srccmdLogInsertStr.append(',');
        this.srccmdLogInsertStr.append("CREATED_TS");
        this.srccmdLogInsertStr.append(',');
        this.srccmdLogInsertStr.append("ENDED_TS");
        this.srccmdLogInsertStr.append(',');
        this.srccmdLogInsertStr.append("SQL_ID");
        this.srccmdLogInsertStr.append(',');
        this.srccmdLogInsertStr.append("FINL_ROWCNT");
        this.srccmdLogInsertStr.append(") VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)");
        this.sqlValueInsertStr = new StringBuffer("INSERT INTO ");
        this.sqlValueInsertStr.append("TX_SQL");
        this.sqlValueInsertStr.append(" (");
        this.sqlValueInsertStr.append("SQL_ID");
        this.sqlValueInsertStr.append(',');
        this.sqlValueInsertStr.append("SQL_VL");
        this.sqlValueInsertStr.append(") VALUES (?,?)");
        this.connProps = props;
        this.con = this.getConnection();
    }

    protected Connection getConnection() throws Exception {
        Connection connection = JDBCConnectionPoolHelper.getConnection(this.connProps, "TRANSACTION_LOGGING");
        connection.setAutoCommit(true);
        this.txnStmt = connection.prepareStatement(this.txnLogInsertStr.toString());
        this.mmxcmdStmt = connection.prepareStatement(this.mmxcmdLogInsertStr.toString());
        this.srccmdStmt = connection.prepareStatement(this.srccmdLogInsertStr.toString());
        this.sqlValueStmt = connection.prepareStatement(this.sqlValueInsertStr.toString());
        this.jdbcPlatform = JDBCPlatformFactory.getPlatform(connection);
        return connection;
    }

    protected synchronized boolean isConnectionOpen() throws SQLException {
        if (this.con != null) {
            if (this.jdbcPlatform.isClosed(this.con)) {
                LogManager.logError("TXN_LOG", CommonXAPlugin.Util.getString("TransactionLogWriter.LogManager_database_connection_is_closed,_must_obtain_another._53"));
                try {
                    this.con.close();
                }
                catch (SQLException ce) {
                    LogManager.logError("TXN_LOG", CommonXAPlugin.Util.getString("ERR.003.031.0033"));
                }
                this.con = null;
            } else {
                return true;
            }
        }
        long waitTime = 60000L;
        long endTime = System.currentTimeMillis() + waitTime;
        while (true) {
            try {
                this.con = this.getConnection();
                return false;
            }
            catch (Exception e2) {
                this.con = null;
                if (waitTime != -1L && System.currentTimeMillis() > endTime) {
                    LogManager.logError("TXN_LOG", CommonXAPlugin.Util.getString("ERR.003.031.0034", e2.getMessage()));
                    String msg = CommonXAPlugin.Util.getString("ERR.003.031.0035", e2.getMessage());
                    throw new SQLException(msg);
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ie) {
                }
                continue;
            }
            break;
        }
    }

    public void print(TransactionLogMessage message) {
        int retrycnt = 0;
        if (this.isLogSuspended && System.currentTimeMillis() > this.resumeTime) {
            this.resumeLogging();
        }
        while (!this.isLogSuspended && !this.shutdown) {
            try {
                this.printMsg(message);
                return;
            }
            catch (Throwable t2) {
                if (retrycnt >= 1) {
                    this.suspendLogging();
                } else {
                    this.reconnect();
                }
                ++retrycnt;
            }
        }
    }

    private boolean reconnect() {
        if (!this.shutdown) {
            this.cleanup();
            try {
                this.con = this.getConnection();
                return true;
            }
            catch (Exception e2) {
                LogManager.logError("TXN_LOG", CommonXAPlugin.Util.getString("ERR.003.014.0028", e2.getMessage()));
                this.suspendLogging();
            }
        }
        return false;
    }

    private synchronized void suspendLogging() {
        this.isLogSuspended = true;
        this.resumeTime = System.currentTimeMillis() + 1800000L;
        Date rd = new Date(this.resumeTime);
        String stringDate = DateUtil.getDateAsString(rd);
        LogManager.logInfo("TXN_LOG", CommonXAPlugin.Util.getString("TransactionLogWriter.Transaction_Logging_has_been_suspended", stringDate));
    }

    private synchronized void resumeLogging() {
        if (this.reconnect()) {
            this.isLogSuspended = false;
            this.resumeTime = -1L;
            Date rd = new Date(System.currentTimeMillis());
            String stringDate = DateUtil.getDateAsString(rd);
            LogManager.logInfo("TXN_LOG", CommonXAPlugin.Util.getString("TransactionLogWriter.Transaction_Logging_has_been_resumed", stringDate));
        }
    }

    private void printMsg(TransactionLogMessage message) throws SQLException {
        short dest = message.getDestinationTable();
        switch (dest) {
            case 0: {
                this.txnStmt.setString(1, message.getTxnUid());
                this.txnStmt.setShort(2, message.getPoint());
                this.txnStmt.setShort(3, message.getStatus());
                this.txnStmt.setString(4, message.getSessionUid());
                this.txnStmt.setString(5, message.getPrincipal());
                this.txnStmt.setString(6, TransactionLogWriter.truncString(message.getVdbName(), 255));
                this.txnStmt.setString(7, TransactionLogWriter.truncString(message.getVdbVersion(), 50));
                this.txnStmt.setString(8, message.getBeginTimeStamp());
                this.txnStmt.setString(9, message.getEndTimeStamp());
                this.txnStmt.executeUpdate();
                break;
            }
            case 1: {
                this.mmxcmdStmt.setString(1, message.getRequestId());
                this.mmxcmdStmt.setString(2, message.getTxnUid());
                this.mmxcmdStmt.setShort(3, message.getPoint());
                this.mmxcmdStmt.setShort(4, message.getStatus());
                this.mmxcmdStmt.setString(5, message.getSessionUid());
                this.mmxcmdStmt.setString(6, message.getApplicationName());
                this.mmxcmdStmt.setString(7, message.getPrincipal());
                this.mmxcmdStmt.setString(8, TransactionLogWriter.truncString(message.getVdbName(), 255));
                this.mmxcmdStmt.setString(9, TransactionLogWriter.truncString(message.getVdbVersion(), 50));
                this.mmxcmdStmt.setString(10, message.getBeginTimeStamp());
                this.mmxcmdStmt.setString(11, message.getEndTimeStamp());
                if (message.getRowCount() < 0) {
                    this.mmxcmdStmt.setObject(12, null);
                } else {
                    this.mmxcmdStmt.setInt(12, message.getRowCount());
                }
                if (message.getSql() == null) {
                    this.mmxcmdStmt.setLong(13, -1L);
                    this.mmxcmdStmt.executeUpdate();
                    break;
                }
                long sqlId = this.getNextSqlID();
                this.mmxcmdStmt.setLong(13, sqlId);
                this.mmxcmdStmt.executeUpdate();
                this.insertSqlValue(sqlId, message.getSql());
                break;
            }
            case 2: {
                this.srccmdStmt.setString(1, message.getRequestId());
                this.srccmdStmt.setLong(2, message.getType());
                this.srccmdStmt.setString(3, message.getSubTxnUid());
                this.srccmdStmt.setShort(4, message.getStatus());
                this.srccmdStmt.setString(5, TransactionLogWriter.truncString(message.getModelName(), 255));
                this.srccmdStmt.setString(6, TransactionLogWriter.truncString(message.getConnectorBindingName(), 255));
                this.srccmdStmt.setShort(7, message.getPoint());
                this.srccmdStmt.setString(8, message.getSessionUid());
                this.srccmdStmt.setString(9, message.getPrincipal());
                this.srccmdStmt.setString(10, message.getBeginTimeStamp());
                this.srccmdStmt.setString(11, message.getEndTimeStamp());
                if (message.getSql() == null) {
                    this.srccmdStmt.setLong(12, -1L);
                    this.srccmdStmt.setInt(13, message.getRowCount());
                    this.srccmdStmt.executeUpdate();
                    break;
                }
                long sqlId = this.getNextSqlID();
                this.srccmdStmt.setLong(12, sqlId);
                this.srccmdStmt.setInt(13, message.getRowCount());
                this.srccmdStmt.executeUpdate();
                this.insertSqlValue(sqlId, message.getSql());
            }
        }
    }

    public synchronized void shutdown() {
        this.shutdown = true;
        this.cleanup();
    }

    private void cleanup() {
        try {
            if (this.txnStmt != null) {
                this.txnStmt.close();
            }
        }
        catch (SQLException ex) {
            LogManager.logError("TXN_LOG", CommonXAPlugin.Util.getString("ERR.003.031.0037", ex.getMessage()));
        }
        try {
            if (this.mmxcmdStmt != null) {
                this.mmxcmdStmt.close();
            }
        }
        catch (SQLException ex) {
            LogManager.logError("TXN_LOG", CommonXAPlugin.Util.getString("ERR.003.031.0037", ex.getMessage()));
        }
        try {
            if (this.srccmdStmt != null) {
                this.srccmdStmt.close();
            }
        }
        catch (SQLException ex) {
            LogManager.logError("TXN_LOG", CommonXAPlugin.Util.getString("ERR.003.031.0037", ex.getMessage()));
        }
        try {
            if (this.sqlValueStmt != null) {
                this.sqlValueStmt.close();
            }
        }
        catch (SQLException ex) {
            LogManager.logError("TXN_LOG", CommonXAPlugin.Util.getString("ERR.003.031.0037", ex.getMessage()));
        }
        try {
            if (this.con != null) {
                this.con.close();
            }
        }
        catch (SQLException ex) {
            LogManager.logError("TXN_LOG", CommonXAPlugin.Util.getString("ERR.003.031.0038", ex.getMessage()));
        }
    }

    public static String truncString(String in, int len) {
        String out = in;
        if (in != null && len > 0 && in.length() > len) {
            out = in.substring(0, len);
        }
        return out;
    }

    private long getNextSqlID() throws SQLException {
        try {
            return DBIDGenerator.getID("TX_SQL");
        }
        catch (DBIDGeneratorException e2) {
            throw new SQLException(CommonXAPlugin.Util.getString("ERR.003.031.0039"));
        }
    }

    private void insertSqlValue(long sqlID, String sqlValue) throws SQLException {
        this.sqlValueStmt.setLong(1, sqlID);
        this.sqlValueStmt.setString(2, sqlValue);
        if (this.sqlValueStmt.executeUpdate() != 1) {
            throw new SQLException(CommonXAPlugin.Util.getString("ERR.003.031.0040"));
        }
    }

    public static final class SqlTable {
        public static final String TABLE_NAME = "TX_SQL";

        public static final class ColumnName {
            public static final String SQL_ID = "SQL_ID";
            public static final String SQL_VL = "SQL_VL";
        }
    }

    public static final class SubcommandLogTable {
        public static final String TABLE_NAME = "TX_SRCCMDLOG";

        public static final class ColumnName {
            public static final String REQUESTID = "REQUESTID";
            public static final String STATUS = "CMD_STATUS";
            public static final String SUBTXNUID = "SUBTXNUID";
            public static final String NODEID = "NODEID";
            public static final String MDL_NM = "MDL_NM";
            public static final String CNCTRNAME = "CNCTRNAME";
            public static final String CMDPOINT = "CMDPOINT";
            public static final String SESSIONUID = "SESSIONUID";
            public static final String PRINCIPAL_NA = "PRINCIPAL_NA";
            public static final String CREATED_TS = "CREATED_TS";
            public static final String ENDED_TS = "ENDED_TS";
            public static final String SQL_CMD = "SQL_ID";
            public static final String FINL_ROWCNT = "FINL_ROWCNT";
        }
    }

    public static final class CommandLogTable {
        public static final String TABLE_NAME = "TX_MMXCMDLOG";

        public static final class ColumnName {
            public static final String REQUESTID = "REQUESTID";
            public static final String TXNUID = "TXNUID";
            public static final String CMDPOINT = "CMDPOINT";
            public static final String STATUS = "CMD_STATUS";
            public static final String SESSIONUID = "SESSIONUID";
            public static final String APP_NAME = "APP_NAME";
            public static final String PRINCIPAL_NA = "PRINCIPAL_NA";
            public static final String VDBNAME = "VDBNAME";
            public static final String VDBVERSION = "VDBVERSION";
            public static final String CREATED_TS = "CREATED_TS";
            public static final String ENDED_TS = "ENDED_TS";
            public static final String FINL_ROWCNT = "FINL_ROWCNT";
            public static final String SQL_CMD = "SQL_ID";
        }
    }

    public static final class TransactionLogTable {
        public static final String TABLE_NAME = "TX_TXNLOG";

        public static final class ColumnName {
            public static final String TXNUID = "TXNUID";
            public static final String TXNPOINT = "TXNPOINT";
            public static final String STATUS = "TXN_STATUS";
            public static final String SESSIONUID = "SESSIONUID";
            public static final String PRINCIPAL_NA = "PRINCIPAL_NA";
            public static final String VDBNAME = "VDBNAME";
            public static final String VDBVERSION = "VDBVERSION";
            public static final String CREATED_TS = "CREATED_TS";
            public static final String ENDED_TS = "ENDED_TS";
        }
    }
}

