/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.xml;

import com.metamatrix.core.util.Assertion;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Parent;

public class XPathUtil {
    public static final String STEP_DELIMITER = "/";
    public static final char STEP_DELIMITER_CHAR = "/".charAt(0);
    private static final String DOCUMENT_ROOT = "/doc/";

    public static String getAbsolutePath(Element tag) {
        Assertion.isNotNull(tag, "The JDOM Element reference may not be null");
        return XPathUtil.addToXPath(tag, new StringBuffer(DOCUMENT_ROOT)).toString();
    }

    public static String getAbsolutePath(Attribute attribute) {
        Assertion.isNotNull(attribute, "The JDOM Attribute reference may not be null");
        Element tag = attribute.getParent();
        StringBuffer sb = new StringBuffer(DOCUMENT_ROOT);
        XPathUtil.addToXPath(tag, sb);
        sb.append(STEP_DELIMITER_CHAR);
        sb.append('@');
        sb.append(attribute.getName());
        sb.append('=');
        sb.append('\"');
        sb.append(attribute.getValue());
        sb.append('\"');
        return sb.toString();
    }

    protected static StringBuffer addToXPath(Element tag, StringBuffer sb) {
        StringBuffer result = sb;
        Parent parent = tag.getParent();
        int index = 1;
        if (parent != null && parent instanceof Element) {
            List parentsChildren = ((Element)parent).getChildren();
            index = parentsChildren.indexOf(tag) + 1;
            result = XPathUtil.addToXPath((Element)parent, result);
            result.append(STEP_DELIMITER_CHAR);
        }
        result.append(tag.getName());
        result.append('[');
        result.append(index);
        result.append(']');
        return result;
    }

    public static class Operator {
        public static final char OR = '|';
        public static final char ADD = '+';
        public static final char MINUS = '-';
        public static final char EQUAL = '=';
        public static final char LESS_THAN = '<';
        public static final char MULTIPLY = '*';
        public static final char GREATER_THAN = '>';
        public static final String NOT_EQUAL = "!=";
        public static final String LESS_THAN_EQUAL = "<=";
        public static final String GREATER_THAN_EQUAL = ">=";
        public static final String AND_NAME = "and";
        public static final String OR_NAME = "or";
        public static final String MODULUS_NAME = "mod";
        public static final String DIVIDE_NAME = "div";
        public static final String DECENDENT_OR_SELF = "//";
    }

    public static class ExpressionToken {
        public static final char ATTRIBUTE_PREFIX = '@';
        public static final char INDEX_OPEN = '[';
        public static final char INDEX_CLOSE = ']';
        public static final char PARAMETERS_OPEN = '(';
        public static final char PARAMETERS_CLOSE = ')';
        public static final char SELF = '.';
        public static final String PARENT = "..";
        public static final String AXIS_SUFFIX = "::";
    }

    public static class Literal {
        public static final char APOSTROPHE = '\'';
        public static final char QUOTE = '\"';
    }
}

