/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.metadata.internal;

import com.metamatrix.connector.metadata.adapter.ObjectResultsTranslator;
import com.metamatrix.connector.metadata.internal.IObjectSource;
import com.metamatrix.connector.metadata.internal.ObjectQuery;
import com.metamatrix.connector.metadata.internal.ReflectionWrapper;
import com.metamatrix.data.exception.ConnectorException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ObjectQueryProcessor
implements Iterator {
    private final IObjectSource objectSource;
    private Iterator resultLists;
    private List resultObjects;
    private String tableDefiningMethodName = null;
    private ArrayList rows;
    private ObjectQuery query;

    public ObjectQueryProcessor(IObjectSource objectSource, ObjectResultsTranslator resultsTranslator) {
        this.objectSource = objectSource;
    }

    public Iterator process(ObjectQuery query) throws ConnectorException {
        int endMethodNameIndex;
        String tableName;
        this.tableDefiningMethodName = null;
        String tableNameForObjectSource = tableName = query.getTableNameInSource();
        int startMethodNameIndex = tableName.lastIndexOf(String.valueOf('('));
        if (startMethodNameIndex > 0 && (endMethodNameIndex = tableName.lastIndexOf(String.valueOf(')'))) > 0 && endMethodNameIndex > startMethodNameIndex) {
            this.tableDefiningMethodName = tableName.substring(startMethodNameIndex + 1, endMethodNameIndex);
            tableNameForObjectSource = tableName.substring(0, startMethodNameIndex);
        }
        this.resultLists = this.objectSource.getObjects(tableNameForObjectSource, query.getCriteria());
        this.query = query;
        return this;
    }

    public Object next() {
        this.resultObjects = (List)this.resultLists.next();
        this.rows = new ArrayList(this.resultObjects.size());
        Iterator iterator = this.resultObjects.iterator();
        while (iterator.hasNext()) {
            this.createRows(iterator.next());
        }
        return this.rows;
    }

    public boolean hasNext() {
        return this.resultLists.hasNext();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void createRows(Object resultObject) {
        ReflectionWrapper wrapper = new ReflectionWrapper(resultObject);
        if (this.tableDefiningMethodName == null) {
            this.addRow(wrapper, null);
        } else {
            Collection<Object> subTableCollection = null;
            Object subTableResults = wrapper.get(this.tableDefiningMethodName);
            if (subTableResults.getClass().isArray()) {
                subTableCollection = Arrays.asList((Object[])subTableResults);
            } else if (subTableResults instanceof Collection) {
                subTableCollection = (Collection)subTableResults;
            }
            this.createRowsFor(wrapper, subTableCollection);
        }
    }

    private void createRowsFor(ReflectionWrapper wrapperAroundResultObject, Collection subTableCollection) {
        Iterator iterator = subTableCollection.iterator();
        while (iterator.hasNext()) {
            Object subTableObject = iterator.next();
            this.addRow(wrapperAroundResultObject, subTableObject);
        }
    }

    private void addRow(ReflectionWrapper wrapper, Object subTableObject) {
        ArrayList<Object> newRow = new ArrayList<Object>();
        String[] columnNames = this.query.getColumnNames();
        for (int i2 = 0; i2 < columnNames.length; ++i2) {
            Object value = null;
            if (columnNames[i2].equals(this.tableDefiningMethodName)) {
                value = subTableObject;
            } else if (columnNames[i2].startsWith(this.tableDefiningMethodName + '.')) {
                ReflectionWrapper subWrapper = new ReflectionWrapper(subTableObject);
                String columnMethodName = columnNames[i2].substring(this.tableDefiningMethodName.length() + 1);
                value = subWrapper.get(columnMethodName);
            } else {
                value = wrapper.get(columnNames[i2]);
            }
            this.query.checkType(i2, value);
            if (value != null) {
                this.query.checkCaseType(i2, value);
                Integer caseType = this.query.getCaseType(i2);
                if (caseType.equals(ObjectQuery.UPPER_CASE)) {
                    value = value.toString().toUpperCase();
                } else if (caseType.equals(ObjectQuery.LOWER_CASE)) {
                    value = value.toString().toLowerCase();
                }
            }
            newRow.add(value);
        }
        this.rows.add(newRow);
    }
}

