/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.sysadmin;

import com.metamatrix.admin.api.exception.AdminException;
import com.metamatrix.admin.internal.server.IAdmin;
import com.metamatrix.admin.internal.server.IAdminFactory;
import com.metamatrix.admin.util.AdminMethodRoleResolver;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.connector.sysadmin.SysAdminObjectSource;
import com.metamatrix.connector.sysadmin.SysAdminPlugin;
import com.metamatrix.connector.sysadmin.SysAdminSourceTranslator;
import com.metamatrix.connector.sysadmin.extension.ISysAdminConnectionFactory;
import com.metamatrix.connector.sysadmin.extension.ISysAdminSource;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.SecurityContext;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.platform.admin.apiimpl.AdminHelper;
import com.metamatrix.platform.admin.apiimpl.IAdminHelper;

public class SysAdminConnectionFactory
implements ISysAdminConnectionFactory {
    private static final String ADMIN_CLASS_NAME = "com.metamatrix.admin.api.objects.AdminObject";
    private static final String LOCAL_FACTORY_NAME = "com.metamatrix.admin.server.local.LocalAdminFactory";
    private ConnectorEnvironment env = null;
    private SysAdminSourceTranslator sourceTranslator = null;
    private Class clazz = null;
    private IAdminHelper adminHelper = null;
    private AdminMethodRoleResolver adminRoleResolver = null;

    public void init(ConnectorEnvironment environment) throws ConnectorException {
        this.env = environment;
        try {
            this.clazz = Class.forName(ADMIN_CLASS_NAME);
        }
        catch (ClassNotFoundException err) {
            ConnectorException e2 = new ConnectorException(err.getMessage());
            e2.setStackTrace(err.getStackTrace());
            throw e2;
        }
        this.sourceTranslator = new SysAdminSourceTranslator(this.clazz);
        this.sourceTranslator.initialize(this.env);
        this.adminHelper = null;
        try {
            this.adminHelper = new AdminHelper();
        }
        catch (MetaMatrixComponentException err) {
            ConnectorException e3 = new ConnectorException(err.getMessage());
            e3.setStackTrace(err.getStackTrace());
            throw e3;
        }
        this.adminRoleResolver = new AdminMethodRoleResolver();
        try {
            this.adminRoleResolver.init();
        }
        catch (AdminException err) {
            ConnectorException e4 = new ConnectorException(err.getMessage());
            e4.setStackTrace(err.getStackTrace());
            throw e4;
        }
    }

    public ISysAdminSource getObjectSource(SecurityContext context) throws ConnectorException {
        IAdmin admin = null;
        try {
            Class<?> localclazz = this.getClass().getClassLoader().loadClass(LOCAL_FACTORY_NAME);
            IAdminFactory localAdminFactory = (IAdminFactory)localclazz.newInstance();
            admin = (IAdmin)localAdminFactory.createAdmin(context.getUser(), context.getConnectionIdentifier(), this.adminHelper, this.adminRoleResolver);
            return new SysAdminObjectSource(admin, this.clazz, this.env, this.sourceTranslator);
        }
        catch (Exception me) {
            throw new ConnectorException((Throwable)me, SysAdminPlugin.Util.getString("SysAdminConnectionFactory.Unable_to_connect_to_adminapi"));
        }
    }
}

