/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.sysadmin.extension.command;

import com.metamatrix.connector.sysadmin.SysAdminPlugin;
import com.metamatrix.connector.sysadmin.extension.command.ObjectCommand;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.IParameter;
import com.metamatrix.data.language.IProcedure;
import com.metamatrix.data.metadata.runtime.Element;
import com.metamatrix.data.metadata.runtime.MetadataID;
import com.metamatrix.data.metadata.runtime.RuntimeMetadata;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class BaseProcedureCommand
extends ObjectCommand {
    private IProcedure procedure = null;
    private String procName;
    private String procNameInSource;
    private IParameter resultSetParameter = null;
    private boolean hasResults = false;
    private String[] columnNames = null;
    private String[] columnNamesInSource = null;
    private Class[] columnTypes = null;
    private List criteriaValues = new LinkedList();
    private List criteriaTypes = new LinkedList();
    private Map criteriaMap = new HashMap();
    private List parameters = new LinkedList();

    public BaseProcedureCommand(RuntimeMetadata metadata, IProcedure command) throws ConnectorException {
        super(metadata, command);
        this.procedure = command;
        this.initParameters();
    }

    public String getGroupName() {
        return this.getProcedureName();
    }

    public String getGroupNameInSource() {
        return this.getProcedureNameInSource();
    }

    private String getProcedureName() {
        return this.procName;
    }

    private String getProcedureNameInSource() {
        return this.procNameInSource;
    }

    public Map getCriteria() {
        return this.criteriaMap;
    }

    public List getCriteriaTypes() {
        return this.criteriaTypes;
    }

    public List getCriteriaValues() {
        return this.criteriaValues;
    }

    public String[] getResultColumnNames() {
        return this.columnNames;
    }

    public List getParameters() {
        return this.parameters;
    }

    public String[] getResultNamesInSource() {
        return this.columnNamesInSource;
    }

    public Class[] getResultColumnTypes() {
        return this.columnTypes;
    }

    public boolean hasResults() {
        return this.hasResults;
    }

    private void initParameters() throws ConnectorException {
        this.procName = this.procedure.getMetadataID().getName();
        this.procNameInSource = this.getMetadataObjectNameInSource(this.procedure);
        List parameters = this.procedure.getParameters();
        if (parameters != null) {
            Iterator iter = parameters.iterator();
            while (iter.hasNext()) {
                IParameter parameter = (IParameter)iter.next();
                if (parameter.getDirection() == 4) {
                    this.resultSetParameter = parameter;
                    this.initResultSet();
                    continue;
                }
                if (parameter.getDirection() == 0 || parameter.getDirection() == 2) {
                    this.initCriteria(parameter);
                    continue;
                }
                if (parameter.getDirection() != 3 || this.resultSetParameter != null) continue;
                this.resultSetParameter = parameter;
                this.initResultReturn();
            }
        }
        this.setCriteria();
    }

    abstract void setCriteria() throws ConnectorException;

    protected void addCriteria(Object type, Object value, String nameInSource) {
        this.criteriaTypes.add(type);
        this.criteriaValues.add(value);
        this.criteriaMap.put(nameInSource, value);
    }

    private void initResultSet() throws ConnectorException {
        List columnMetadata = this.resultSetParameter.getMetadataID().getChildIDs();
        int size = columnMetadata.size();
        this.columnNames = new String[size];
        this.columnNamesInSource = new String[size];
        this.columnTypes = new Class[size];
        for (int i2 = 0; i2 < size; ++i2) {
            MetadataID mID = (MetadataID)columnMetadata.get(i2);
            Element element = (Element)this.getMetadata().getObject(mID);
            this.columnNamesInSource[i2] = element.getNameInSource() != null && element.getNameInSource().length() > 0 ? element.getNameInSource() : null;
            this.columnNames[i2] = element.getMetadataID().getName();
            this.columnTypes[i2] = element.getJavaType();
            this.hasResults = true;
        }
    }

    private void initResultReturn() throws ConnectorException {
        this.columnNames = new String[1];
        this.columnTypes = new Class[1];
        this.columnNamesInSource = new String[1];
        this.columnNames[0] = this.resultSetParameter.getMetadataID().getName();
        this.columnTypes[0] = this.resultSetParameter.getType();
        this.columnNamesInSource[0] = this.getMetadataObjectNameInSource(this.resultSetParameter);
        this.hasResults = true;
    }

    private void initCriteria(IParameter parameter) throws ConnectorException {
        this.parameters.add(parameter);
    }

    public void checkType(int columnIndex, Object value) {
        if (value != null && this.columnTypes != null && !this.columnTypes[columnIndex].isAssignableFrom(value.getClass())) {
            throw new MetaMatrixRuntimeException(SysAdminPlugin.Util.getString("ObjectQuery.Type_mismatch", new Object[]{this.columnNames[columnIndex], this.columnTypes[columnIndex].getName(), value.getClass().getName()}));
        }
    }
}

