/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.commandshell;

import com.metamatrix.core.CorePlugin;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.commandshell.ArgumentConversionException;
import com.metamatrix.core.commandshell.CommandLineParser;
import com.metamatrix.core.commandshell.WrongNumberOfArgumentsException;
import com.metamatrix.core.id.IDGenerator;
import com.metamatrix.core.id.InvalidIDException;
import com.metamatrix.core.util.DateUtil;
import com.metamatrix.core.util.FileUtil;
import com.metamatrix.core.util.StringUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class Command {
    private static final String COMMAND_COMMENT = "//";
    private Object target;
    private Class targetClass;
    private String commandName;
    private String[] args;
    private Method method;
    private String defaultFilePath = "";
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$com$metamatrix$core$commandshell$CommandTarget;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$util$Properties;
    static /* synthetic */ Class class$com$metamatrix$core$id$ObjectID;

    public Command(Object target, String[] commandLine) {
        this.init(target, commandLine);
    }

    private void init(Object target, String[] commandLine) {
        this.target = target;
        this.targetClass = target.getClass();
        if (commandLine.length == 0) {
            this.commandName = null;
        } else {
            this.commandName = commandLine[0];
            if (this.commandName.trim().startsWith(COMMAND_COMMENT)) {
                this.commandName = null;
            } else {
                this.args = new String[commandLine.length - 1];
                for (int i2 = 1; i2 < commandLine.length; ++i2) {
                    this.args[i2 - 1] = commandLine[i2];
                }
            }
        }
    }

    public Command(Object target, String commandLine) {
        this.init(target, new CommandLineParser().parse(commandLine));
    }

    public Command(Object target, String commandName, String[] args) {
        this.target = target;
        this.targetClass = target.getClass();
        this.commandName = commandName;
        this.args = args;
    }

    public void setDefaultFilePath(String defaultFilePath) {
        this.defaultFilePath = defaultFilePath;
    }

    private Method getMethod(Set methodsToIgnore) throws NoSuchMethodException {
        if (!Command.shouldIgnoreMethod(this.commandName, methodsToIgnore)) {
            this.getMethodDirect();
        }
        if (this.method == null) {
            Object[] params = new Object[]{this.targetClass.getName(), this.commandName};
            String message = CorePlugin.Util.getString("Command.Could_not_find_method", params);
            throw new NoSuchMethodException(message);
        }
        return this.method;
    }

    static boolean shouldIgnoreMethod(String currentMethodName, Set methodsToIgnore) {
        Iterator i2 = methodsToIgnore.iterator();
        while (i2.hasNext()) {
            String methodName = (String)i2.next();
            if (!methodName.toLowerCase().equals(currentMethodName.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private void getMethodDirect() {
        Method[] methods = this.targetClass.getMethods();
        for (int i2 = 0; i2 < methods.length; ++i2) {
            if (this.shouldSkipMethod(methods, i2) || !methods[i2].getName().toLowerCase().equals(this.commandName.toLowerCase())) continue;
            this.method = methods[i2];
            break;
        }
    }

    private boolean shouldSkipMethod(Method[] methods, int i2) {
        boolean skipMethod = false;
        if (methods[i2].getDeclaringClass().equals(class$java$lang$Object == null ? (class$java$lang$Object = Command.class$("java.lang.Object")) : class$java$lang$Object)) {
            skipMethod = true;
        }
        if (methods[i2].getDeclaringClass().equals(class$com$metamatrix$core$commandshell$CommandTarget == null ? (class$com$metamatrix$core$commandshell$CommandTarget = Command.class$("com.metamatrix.core.commandshell.CommandTarget")) : class$com$metamatrix$core$commandshell$CommandTarget) && !this.commandName.toLowerCase().equals("help") && !this.commandName.toLowerCase().equals("quit") && !this.commandName.toLowerCase().equals("exit")) {
            skipMethod = true;
        }
        return skipMethod;
    }

    private Object[] getConvertedArgs() throws WrongNumberOfArgumentsException, ArgumentConversionException {
        String message;
        Object[] params;
        Class<?> lastArgType;
        String[] stringArray;
        Class<?>[] neededTypes = this.method.getParameterTypes();
        if (neededTypes.length == 1 && neededTypes[0] == (stringArray = new String[0]).getClass()) {
            return new Object[]{this.args};
        }
        boolean skipLast = false;
        Object lastArg = null;
        if (neededTypes.length > 0 && (lastArgType = neededTypes[neededTypes.length - 1]).isArray()) {
            Object[] tempLastArg = new Object[this.args.length - (neededTypes.length - 1)];
            for (int i2 = neededTypes.length - 1; i2 < this.args.length; ++i2) {
                tempLastArg[i2 - (neededTypes.length - 1)] = this.convert(this.args[i2], lastArgType.getComponentType());
            }
            skipLast = true;
            lastArg = this.convertArray(tempLastArg, lastArgType.getComponentType());
        }
        if (skipLast) {
            if (neededTypes.length > this.args.length) {
                params = new Object[]{new Integer(neededTypes.length), new Integer(this.args.length)};
                message = CorePlugin.Util.getString("Command.Argument_count_mis-match,_expected_{0}_but_received_{1}", params);
                throw new WrongNumberOfArgumentsException(message);
            }
        } else if (neededTypes.length != this.args.length) {
            params = new Object[]{new Integer(neededTypes.length), new Integer(this.args.length)};
            message = CorePlugin.Util.getString("Command.Argument_count_mis-match,_expected_{0}_but_received_{1}", params);
            throw new WrongNumberOfArgumentsException(message);
        }
        Object[] result = new Object[neededTypes.length];
        if (skipLast) {
            for (int i3 = 0; i3 < neededTypes.length - 1; ++i3) {
                result[i3] = this.convert(this.args[i3], neededTypes[i3]);
            }
            result[neededTypes.length - 1] = lastArg;
        } else {
            for (int i4 = 0; i4 < neededTypes.length; ++i4) {
                result[i4] = this.convert(this.args[i4], neededTypes[i4]);
            }
        }
        return result;
    }

    private Object convertArray(Object[] input, Class targetType) {
        Object result = Array.newInstance(targetType, input.length);
        for (int i2 = 0; i2 < input.length; ++i2) {
            Array.set(result, i2, input[i2]);
        }
        return result;
    }

    private void handleFileException(String target, Throwable exception) throws ArgumentConversionException {
        String message = CorePlugin.Util.getString("Command.Error_processing_file", target);
        throw new ArgumentConversionException(exception, message);
    }

    private Object convert(String target, Class neededType) throws ArgumentConversionException {
        if (neededType.equals(class$java$lang$String == null ? (class$java$lang$String = Command.class$("java.lang.String")) : class$java$lang$String)) {
            return target;
        }
        byte[] x2 = new byte[0];
        if (neededType.equals(x2.getClass())) {
            String fileName = this.defaultFilePath + target;
            FileUtil file = new FileUtil(fileName);
            try {
                return file.readBytesSafe();
            }
            catch (FileNotFoundException e2) {
                this.handleFileException(target, e2);
            }
            catch (IOException e3) {
                this.handleFileException(target, e3);
            }
        }
        if (neededType.equals(class$java$util$Date == null ? (class$java$util$Date = Command.class$("java.util.Date")) : class$java$util$Date)) {
            try {
                return DateUtil.convertStringToDate(target);
            }
            catch (ParseException e4) {
                throw new ArgumentConversionException((Throwable)e4, e4.getMessage());
            }
        }
        if (neededType.equals(Integer.TYPE)) {
            return new Integer(target);
        }
        if (neededType.equals(Boolean.TYPE)) {
            return new Boolean(target);
        }
        if (neededType.equals(class$java$util$Properties == null ? (class$java$util$Properties = Command.class$("java.util.Properties")) : class$java$util$Properties)) {
            Properties result = new Properties();
            String[] subStrings = StringUtil.split(target, ",=").toArray(new String[0]);
            for (int i2 = 0; i2 < subStrings.length; i2 += 2) {
                result.put(subStrings[i2], subStrings[i2 + 1]);
            }
            return result;
        }
        if (neededType.equals(class$com$metamatrix$core$id$ObjectID == null ? (class$com$metamatrix$core$id$ObjectID = Command.class$("com.metamatrix.core.id.ObjectID")) : class$com$metamatrix$core$id$ObjectID)) {
            if (target != null) {
                try {
                    if (target.equals("null")) {
                        return null;
                    }
                    return IDGenerator.getInstance().stringToObject(target);
                }
                catch (InvalidIDException e5) {
                    throw new ArgumentConversionException((Throwable)e5, e5.getMessage());
                }
            }
            return null;
        }
        char[] charArray = new char[0];
        if (neededType.equals(charArray.getClass())) {
            String fileName = this.defaultFilePath + target;
            FileUtil file = new FileUtil(fileName);
            try {
                return file.readSafe().toCharArray();
            }
            catch (FileNotFoundException e6) {
                this.handleFileException(target, e6);
            }
        }
        String message = CorePlugin.Util.getString("Command.Cannot_convert_to", neededType);
        throw new MetaMatrixRuntimeException(message);
    }

    public Object execute() throws NoSuchMethodException, WrongNumberOfArgumentsException, ArgumentConversionException {
        return this.execute(Collections.EMPTY_SET);
    }

    public Object execute(Set methodsToIgnore) throws NoSuchMethodException, WrongNumberOfArgumentsException, ArgumentConversionException {
        if (this.commandName == null) {
            return null;
        }
        this.getMethod(methodsToIgnore);
        try {
            return this.method.invoke(this.target, this.getConvertedArgs());
        }
        catch (IllegalArgumentException e2) {
            throw new MetaMatrixRuntimeException(e2);
        }
        catch (IllegalAccessException e3) {
            throw new MetaMatrixRuntimeException(e3);
        }
        catch (InvocationTargetException e4) {
            if (e4.getTargetException() instanceof MetaMatrixRuntimeException) {
                throw (MetaMatrixRuntimeException)e4.getTargetException();
            }
            if (e4.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e4.getTargetException();
            }
            throw new MetaMatrixRuntimeException(e4);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

