/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.struct;

import com.metamatrix.core.struct.ReflectionWrapper;
import com.metamatrix.core.struct.StructHandler;
import java.lang.reflect.Array;

public class StructWalker {
    private StructHandler handler;

    public StructWalker(StructHandler handler) {
        this.handler = handler;
    }

    public void walk(Object struct) {
        this.walkDirect(null, null, struct, 0, false);
    }

    public void walk(Object struct, boolean walkPrimitive) {
        this.walkDirect(null, null, struct, 0, walkPrimitive);
    }

    private void walkDirect(String name, Integer arrayIndex, Object struct, int level, boolean walkPrimitive) {
        if (struct == null) {
            return;
        }
        if (struct.getClass().isArray()) {
            int count = Array.getLength(struct);
            for (int i2 = 0; i2 < count; ++i2) {
                this.walkDirect(name, new Integer(i2), Array.get(struct, i2), level + 1, walkPrimitive);
            }
        } else {
            String fieldName;
            int i3;
            this.handler.handle(name, arrayIndex, struct, level);
            ReflectionWrapper wrapper = new ReflectionWrapper(struct);
            if (walkPrimitive) {
                String[] primitives = wrapper.getFieldsWithPrimitiveTypes();
                for (i3 = 0; i3 < primitives.length; ++i3) {
                    fieldName = primitives[i3];
                    this.handler.handle(fieldName, null, wrapper.get(fieldName), level + 1);
                }
            }
            String[] subStructs = wrapper.getFieldsWithUserDefinedTypes();
            for (i3 = 0; i3 < subStructs.length; ++i3) {
                fieldName = subStructs[i3];
                this.walkDirect(fieldName, null, wrapper.get(fieldName), level + 1, walkPrimitive);
            }
        }
    }
}

