/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.embedded;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.application.ApplicationService;
import com.metamatrix.common.application.exception.ApplicationInitializationException;
import com.metamatrix.common.protocol.URLHelper;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.dqp.config.DQPConfigSource;
import com.metamatrix.dqp.embedded.DQPEmbeddedPlugin;
import com.metamatrix.dqp.embedded.EmbeddedConfigUtil;
import com.metamatrix.dqp.embedded.services.EmbeddedBufferService;
import com.metamatrix.dqp.embedded.services.EmbeddedConfigurationService;
import com.metamatrix.dqp.embedded.services.EmbeddedDQPServiceRegistry;
import com.metamatrix.dqp.embedded.services.EmbeddedDataService;
import com.metamatrix.dqp.embedded.services.EmbeddedMetadataService;
import com.metamatrix.dqp.embedded.services.EmbeddedTrackingService;
import com.metamatrix.dqp.embedded.services.EmbeddedVDBService;
import com.metamatrix.dqp.service.ConfigurationService;
import com.metamatrix.dqp.service.DataService;
import com.metamatrix.dqp.service.MetadataService;
import com.metamatrix.dqp.service.VDBService;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class EmbeddedConfigSource
implements DQPConfigSource {
    private Map services = new HashMap();
    private EmbeddedDQPServiceRegistry svcRegistry = new EmbeddedDQPServiceRegistry();
    static /* synthetic */ Class class$com$metamatrix$dqp$service$DQPServiceRegistry;
    static /* synthetic */ Class class$com$metamatrix$dqp$service$DataService;
    static /* synthetic */ Class class$com$metamatrix$dqp$service$VDBService;
    static /* synthetic */ Class class$com$metamatrix$dqp$service$MetadataService;
    static /* synthetic */ Class class$com$metamatrix$dqp$service$ConfigurationService;

    public EmbeddedConfigSource(URL dqpURL, Properties connectionProperties) throws ApplicationInitializationException {
        System.getProperties().setProperty("metamatrix.config.none", Boolean.TRUE.toString());
        String dqpURLString = dqpURL.toString();
        try {
            Properties props;
            dqpURL = URLHelper.buildURL((String)dqpURLString);
            InputStream in = dqpURL.openStream();
            if (in != null) {
                props = new Properties();
                props.load(in);
                in.close();
                if (connectionProperties != null) {
                    props.putAll((Map<?, ?>)connectionProperties);
                }
            } else {
                throw new ApplicationInitializationException(DQPEmbeddedPlugin.Util.getString("EmbeddedConfigSource.Can_not_load_config_file_2", dqpURL));
            }
            props = PropertiesUtils.resolveNestedProperties(props);
            props.put("dqp.identity", this.getDQPIdentity());
            props.put("mm.io.tmpdir", this.getWorkspaceDirectory());
            props.put("dqp.propertiesFile", dqpURL);
            this.configureLogging(dqpURL, props);
            this.createConfigurationService(props);
        }
        catch (IOException e2) {
            throw new ApplicationInitializationException(e2);
        }
    }

    String getDQPIdentity() {
        String id = System.getProperty("dqp.identity", "0");
        return id;
    }

    String getWorkspaceDirectory() {
        return System.getProperty("mm.io.tmpdir", System.getProperty("java.io.tmpdir"));
    }

    ApplicationService reflectivelyLoadService(String serviceName, Class serviceType) throws ApplicationInitializationException {
        if (serviceName != null) {
            try {
                Class<?> serviceClass = Class.forName(serviceName);
                if (!serviceType.isAssignableFrom(serviceClass)) {
                    throw new ApplicationInitializationException(DQPEmbeddedPlugin.Util.getString("EmbeddedConfigSource.Service_class__4", serviceName, serviceType.getName()));
                }
                Constructor<?> c2 = serviceClass.getConstructor(class$com$metamatrix$dqp$service$DQPServiceRegistry == null ? (class$com$metamatrix$dqp$service$DQPServiceRegistry = EmbeddedConfigSource.class$("com.metamatrix.dqp.service.DQPServiceRegistry")) : class$com$metamatrix$dqp$service$DQPServiceRegistry);
                return (ApplicationService)c2.newInstance(this.svcRegistry);
            }
            catch (ClassNotFoundException e2) {
                throw new ApplicationInitializationException((Throwable)e2, DQPEmbeddedPlugin.Util.getString("EmbeddedConfigSource.Unable_to_find_service_class_6", serviceName));
            }
            catch (NoSuchMethodException e3) {
                throw new ApplicationInitializationException((Throwable)e3, DQPEmbeddedPlugin.Util.getString("EmbeddedConfigSource.Unable_to_instantiate_service_class_7", serviceName));
            }
            catch (InstantiationException e4) {
                throw new ApplicationInitializationException((Throwable)e4, DQPEmbeddedPlugin.Util.getString("EmbeddedConfigSource.Unable_to_instantiate_service_class_7", serviceName));
            }
            catch (IllegalAccessException e5) {
                throw new ApplicationInitializationException((Throwable)e5, DQPEmbeddedPlugin.Util.getString("EmbeddedConfigSource.Unable_to_instantiate_service_class_due_to_security_error_8", serviceName));
            }
            catch (InvocationTargetException e6) {
                throw new ApplicationInitializationException((Throwable)e6, DQPEmbeddedPlugin.Util.getString("EmbeddedConfigSource.Unable_to_instantiate_service_class_7", serviceName));
            }
        }
        return null;
    }

    public ApplicationService getService(String serviceName) throws ApplicationInitializationException {
        ApplicationService svc = (ApplicationService)this.services.get(serviceName);
        if (svc != null) {
            return svc;
        }
        if (serviceName.equalsIgnoreCase("dqp.buffer")) {
            svc = this.createBufferService();
        } else if (serviceName.equalsIgnoreCase("dqp.data")) {
            svc = this.createDataService();
        } else if (serviceName.equalsIgnoreCase("dqp.metadata")) {
            svc = this.createMetadataService();
        } else if (serviceName.equalsIgnoreCase("dqp.vdb")) {
            svc = this.createVDBService();
        } else if (serviceName.equals("dqp.tracking")) {
            svc = this.createTrackingService();
        } else if (serviceName.equals("dqp.configuration")) {
            svc = this.getConfigurationService();
        }
        this.services.put(serviceName, svc);
        return svc;
    }

    ApplicationService createBufferService() throws ApplicationInitializationException {
        try {
            ConfigurationService configSvc = this.getConfigurationService();
            Properties props = configSvc.getSystemProperties();
            EmbeddedBufferService svc = new EmbeddedBufferService(this.svcRegistry);
            svc.initialize(props);
            return svc;
        }
        catch (MetaMatrixComponentException e2) {
            throw new ApplicationInitializationException(e2);
        }
    }

    ApplicationService createDataService() throws ApplicationInitializationException {
        try {
            DataService svc = null;
            String className = this.overloadedClass("dqp.data");
            svc = className != null && className.length() > 0 ? (DataService)this.reflectivelyLoadService(className, class$com$metamatrix$dqp$service$DataService == null ? (class$com$metamatrix$dqp$service$DataService = EmbeddedConfigSource.class$("com.metamatrix.dqp.service.DataService")) : class$com$metamatrix$dqp$service$DataService) : new EmbeddedDataService(this.svcRegistry);
            svc.initialize(null);
            return svc;
        }
        catch (MetaMatrixComponentException e2) {
            throw new ApplicationInitializationException(e2);
        }
    }

    ApplicationService createTrackingService() throws ApplicationInitializationException {
        try {
            EmbeddedTrackingService svc = new EmbeddedTrackingService(this.svcRegistry);
            svc.initialize(null);
            return svc;
        }
        catch (MetaMatrixComponentException e2) {
            throw new ApplicationInitializationException(e2);
        }
    }

    ApplicationService createVDBService() throws ApplicationInitializationException {
        try {
            VDBService svc = null;
            String className = this.overloadedClass("dqp.vdb");
            svc = className != null && className.length() > 0 ? (VDBService)this.reflectivelyLoadService(className, class$com$metamatrix$dqp$service$VDBService == null ? (class$com$metamatrix$dqp$service$VDBService = EmbeddedConfigSource.class$("com.metamatrix.dqp.service.VDBService")) : class$com$metamatrix$dqp$service$VDBService) : new EmbeddedVDBService(this.svcRegistry);
            svc.initialize(null);
            return svc;
        }
        catch (MetaMatrixComponentException e2) {
            throw new ApplicationInitializationException(e2);
        }
    }

    ApplicationService createMetadataService() throws ApplicationInitializationException {
        try {
            MetadataService svc = null;
            String className = this.overloadedClass("dqp.metadata");
            svc = className != null && className.length() > 0 ? (MetadataService)this.reflectivelyLoadService(className, class$com$metamatrix$dqp$service$MetadataService == null ? (class$com$metamatrix$dqp$service$MetadataService = EmbeddedConfigSource.class$("com.metamatrix.dqp.service.MetadataService")) : class$com$metamatrix$dqp$service$MetadataService) : new EmbeddedMetadataService(this.svcRegistry);
            svc.initialize(null);
            return svc;
        }
        catch (MetaMatrixComponentException e2) {
            throw new ApplicationInitializationException(e2);
        }
    }

    ApplicationService createConfigurationService(Properties props) throws ApplicationInitializationException {
        try {
            ApplicationService svc = null;
            String className = this.overloadedClass(props, "dqp.configuration");
            svc = className != null && className.length() > 0 ? this.reflectivelyLoadService(className, class$com$metamatrix$dqp$service$ConfigurationService == null ? (class$com$metamatrix$dqp$service$ConfigurationService = EmbeddedConfigSource.class$("com.metamatrix.dqp.service.ConfigurationService")) : class$com$metamatrix$dqp$service$ConfigurationService) : new EmbeddedConfigurationService(this.svcRegistry);
            svc.initialize(props);
            this.services.put("dqp.configuration", svc);
            return svc;
        }
        catch (MetaMatrixComponentException e2) {
            throw new ApplicationInitializationException(e2);
        }
    }

    public Properties getProperties() throws ApplicationInitializationException {
        try {
            return this.getConfigurationService().getSystemProperties();
        }
        catch (MetaMatrixComponentException e2) {
            throw new ApplicationInitializationException(e2);
        }
    }

    ConfigurationService getConfigurationService() throws ApplicationInitializationException {
        return (ConfigurationService)this.getService("dqp.configuration");
    }

    private String overloadedClass(String svcName) throws ApplicationInitializationException {
        return this.overloadedClass(this.getProperties(), svcName);
    }

    private String overloadedClass(Properties props, String svcName) throws ApplicationInitializationException {
        return props.getProperty("service." + svcName + ".classname");
    }

    void configureLogging(URL dqpURL, Properties props) throws ApplicationInitializationException {
        boolean captureSystemStreams = Boolean.valueOf(props.getProperty("dqp.captureSystemStreams", "false"));
        String logLevel = props.getProperty("dqp.logLevel");
        String logFile = props.getProperty("dqp.logFile");
        String classpath = props.getProperty("dqp.classpath");
        boolean unifiedClassLoader = classpath == null || classpath.length() <= 0;
        String instanceId = props.getProperty("dqp.identity");
        try {
            try {
                if (logFile != null && !logFile.equalsIgnoreCase("STDOUT")) {
                    String modifiedLogFileName = logFile;
                    int dotIndex = logFile.lastIndexOf(46);
                    modifiedLogFileName = dotIndex != -1 ? logFile.substring(0, dotIndex) + "_" + instanceId + "." + logFile.substring(dotIndex + 1) : logFile + "_" + instanceId;
                    URL logURL = URLHelper.buildURL((URL)dqpURL, (String)modifiedLogFileName);
                    logFile = logURL.getPath();
                }
            }
            catch (MalformedURLException e2) {
                e2.printStackTrace();
            }
            EmbeddedConfigUtil.configureLogger(logFile, logLevel, captureSystemStreams, unifiedClassLoader);
        }
        catch (MetaMatrixComponentException e3) {
            throw new ApplicationInitializationException(e3);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

