/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.embedded.admin;

import com.metamatrix.admin.api.embedded.EmbeddedLogger;
import com.metamatrix.admin.api.embedded.EmbeddedRuntimeStateAdmin;
import com.metamatrix.admin.api.exception.AdminException;
import com.metamatrix.admin.api.exception.AdminProcessingException;
import com.metamatrix.admin.api.objects.AdminObject;
import com.metamatrix.admin.objects.MMRequest;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.common.application.exception.ApplicationLifecycleException;
import com.metamatrix.common.comm.api.ClientConnection;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.vdb.api.VDBDefn;
import com.metamatrix.dqp.embedded.DQPEmbeddedManager;
import com.metamatrix.dqp.embedded.DQPEmbeddedPlugin;
import com.metamatrix.dqp.embedded.EmbeddedConfigUtil;
import com.metamatrix.dqp.embedded.admin.BaseAdmin;
import com.metamatrix.dqp.embedded.admin.DQPLogListener;
import com.metamatrix.dqp.message.AdminRequestMessage;
import com.metamatrix.dqp.message.CancelMessage;
import com.metamatrix.dqp.message.RequestID;
import com.metamatrix.dqp.message.TerminateConnectionMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class DQPRuntimeStateAdminImpl
extends BaseAdmin
implements EmbeddedRuntimeStateAdmin {
    public DQPRuntimeStateAdminImpl(DQPEmbeddedManager manager) {
        super(manager);
    }

    public void stop(int millisToWait) throws AdminException {
        try {
            this.terminateSession("*");
            this.getManager().shutdown();
        }
        catch (ApplicationLifecycleException e2) {
            this.handleSystemException(e2);
        }
    }

    public void restart() throws AdminException {
        try {
            this.terminateSession("*");
            this.getManager().shutdown();
        }
        catch (ApplicationLifecycleException e2) {
            this.handleSystemException(e2);
        }
    }

    public void startConnectorBinding(String identifier) throws AdminException {
        if (identifier == null || !identifier.matches("\\w*(\\s*\\w)*(\\*)?")) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_identifier"));
        }
        AdminException exceptionWrapper = null;
        Collection bindings = this.getConnectorBindings(identifier);
        if (bindings != null && !bindings.isEmpty()) {
            Iterator i2 = bindings.iterator();
            while (i2.hasNext()) {
                try {
                    AdminObject binding = (AdminObject)i2.next();
                    this.getDataService().startConnectorBinding(binding.getName());
                }
                catch (ApplicationLifecycleException e2) {
                    exceptionWrapper = this.accumulateSystemException(exceptionWrapper, e2);
                }
                catch (MetaMatrixComponentException e3) {
                    exceptionWrapper = this.accumulateSystemException(exceptionWrapper, e3);
                }
                catch (MetaMatrixProcessingException e4) {
                    exceptionWrapper = this.accumulateProcessingException(exceptionWrapper, e4);
                }
            }
        } else {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Connector_binding_does_not_exists", new Object[]{identifier}));
        }
        if (exceptionWrapper != null) {
            throw exceptionWrapper;
        }
    }

    public void stopConnectorBinding(String identifier, boolean stopNow) throws AdminException {
        if (identifier == null || !identifier.matches("\\w*(\\s*\\w)*(\\*)?")) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_identifier"));
        }
        AdminException exceptionWrapper = null;
        Collection bindings = this.getConnectorBindings(identifier);
        if (bindings != null && !bindings.isEmpty()) {
            Iterator i2 = bindings.iterator();
            while (i2.hasNext()) {
                try {
                    AdminObject binding = (AdminObject)i2.next();
                    this.getDataService().stopConnectorBinding(binding.getName());
                }
                catch (ApplicationLifecycleException e2) {
                    exceptionWrapper = this.accumulateSystemException(exceptionWrapper, e2);
                }
                catch (MetaMatrixComponentException e3) {
                    exceptionWrapper = this.accumulateSystemException(exceptionWrapper, e3);
                }
                catch (MetaMatrixProcessingException e4) {
                    exceptionWrapper = this.accumulateProcessingException(exceptionWrapper, e4);
                }
            }
        } else {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Connector_binding_does_not_exists", new Object[]{identifier}));
        }
        if (exceptionWrapper != null) {
            throw exceptionWrapper;
        }
    }

    public void clearCache(String identifier) throws AdminException {
        if (identifier == null || !identifier.matches("\\w*(\\*)?")) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_identifier"));
        }
        boolean processed = false;
        for (int i2 = 0; i2 < cacheTypes.length; ++i2) {
            AdminRequestMessage msg = new AdminRequestMessage();
            if (!this.matches(identifier, cacheTypes[i2])) continue;
            if (cacheTypes[i2].equals("CodeTableCache")) {
                processed = true;
                msg.setRequestType(4);
                this.processMessage(msg);
                continue;
            }
            if (cacheTypes[i2].equals("PreparedPlanCache")) {
                processed = true;
                msg.setRequestType(5);
                this.processMessage(msg);
                continue;
            }
            if (cacheTypes[i2].equals("QueryServiceResultSetCache")) {
                processed = true;
                msg.setRequestType(6);
                this.processMessage(msg);
                continue;
            }
            if (!cacheTypes[i2].equals("ConnectorResultSetCache")) continue;
            processed = true;
            try {
                Collection bindings = super.getConnectorBindings("*");
                Iterator iter = bindings.iterator();
                while (iter.hasNext()) {
                    com.metamatrix.admin.api.objects.ConnectorBinding binding = (com.metamatrix.admin.api.objects.ConnectorBinding)iter.next();
                    this.getDataService().clearConnectorBindingCache(binding.getName());
                }
                continue;
            }
            catch (MetaMatrixComponentException e2) {
                this.handleSystemException(e2);
                continue;
            }
            catch (MetaMatrixProcessingException e3) {
                this.handleProcessingException(e3);
            }
        }
        if (!processed) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.invalid_request", new Object[]{identifier}));
        }
    }

    public void terminateSession(String identifier) throws AdminException {
        ClientConnection clientConnection;
        if (identifier == null || !identifier.equals("*") && !identifier.matches("\\d+")) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_identifier"));
        }
        Set connections = this.getClientConnections();
        ArrayList<ClientConnection> matchedConnections = new ArrayList<ClientConnection>();
        Iterator i2 = connections.iterator();
        while (i2.hasNext()) {
            clientConnection = (ClientConnection)i2.next();
            String id = (String)clientConnection.getConnectionProperty("connectionID");
            if (!this.matches(identifier, id)) continue;
            matchedConnections.add(clientConnection);
        }
        i2 = matchedConnections.iterator();
        while (i2.hasNext()) {
            clientConnection = (ClientConnection)i2.next();
            TerminateConnectionMessage close = new TerminateConnectionMessage();
            close.setClientConnection(clientConnection);
            this.processMessage(close);
            try {
                clientConnection.shutdown();
            }
            catch (CommunicationException e2) {
                this.handleProcessingException(e2);
            }
        }
    }

    public void cancelRequest(String identifier) throws AdminException {
        if (identifier == null || !identifier.matches("\\d+\\" + AdminObject.DELIMITER + "\\d+")) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_identifier"));
        }
        String[] identifierParts = MMRequest.buildIdentifierArray(identifier);
        String connId = identifierParts[0];
        long requestId = Long.parseLong(identifierParts[1]);
        ClientConnection conn = this.getClientConnection(connId);
        RequestID id = new RequestID(connId, requestId);
        CancelMessage cancelMsg = new CancelMessage();
        cancelMsg.setClientConnection(conn);
        cancelMsg.setRequestID(id);
        this.processMessage(cancelMsg);
    }

    public void cancelSourceRequest(String identifier) throws AdminException {
        if (identifier == null || !identifier.matches("\\d+\\" + AdminObject.DELIMITER + "\\d+\\" + AdminObject.DELIMITER + "\\d+")) {
            throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_identifier"));
        }
        String[] identifierParts = MMRequest.buildIdentifierArray(identifier);
        String connId = identifierParts[0];
        ClientConnection conn = this.getClientConnection(connId);
        long requestId = Long.parseLong(identifierParts[1]);
        int nodeId = Integer.parseInt(identifierParts[2]);
        RequestID id = new RequestID(connId, requestId);
        CancelMessage cancelMsg = new CancelMessage();
        cancelMsg.setClientConnection(conn);
        cancelMsg.setRequestID(id);
        cancelMsg.setNodeID(nodeId);
        this.processMessage(cancelMsg);
    }

    public void changeVDBStatus(String name, String version, int status) throws AdminException {
        try {
            if (name == null || version == null || !name.matches("\\w+")) {
                throw new AdminProcessingException(DQPEmbeddedPlugin.Util.getString("Admin.Invalid_vdb_name"));
            }
            VDBDefn vdb = this.getVDBService().changeVDBStatus(name, version, status);
            if (vdb != null && status == 4) {
                Collection bindings = vdb.getConnectorBindings().values();
                Iterator i2 = bindings.iterator();
                while (i2.hasNext()) {
                    ConnectorBinding binding = (ConnectorBinding)i2.next();
                    try {
                        this.getDataService().deleteConnectorBinding(binding.getName());
                    }
                    catch (Exception e2) {}
                }
            }
        }
        catch (ApplicationLifecycleException err) {
            this.handleSystemException(err);
        }
        catch (MetaMatrixComponentException err) {
            this.handleSystemException(err);
        }
        catch (MetaMatrixProcessingException err) {
            this.handleProcessingException(err);
        }
    }

    public void setLogListener(EmbeddedLogger listener) throws AdminException {
        if (listener != null) {
            try {
                EmbeddedConfigUtil.installLogListener(new DQPLogListener(listener));
            }
            catch (MetaMatrixComponentException e2) {
                this.handleProcessingException(e2);
            }
        } else {
            throw new AdminProcessingException("Admin_invalid_log_listener");
        }
    }
}

