/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.embedded.services;

import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.application.ApplicationEnvironment;
import com.metamatrix.common.application.exception.ApplicationInitializationException;
import com.metamatrix.common.application.exception.ApplicationLifecycleException;
import com.metamatrix.common.classloader.NonDelegatingClassLoader;
import com.metamatrix.common.comm.api.ClientConnection;
import com.metamatrix.common.comm.api.MessageListener;
import com.metamatrix.common.comm.exception.ApplicationException;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ComponentTypeDefn;
import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.ConnectorBindingType;
import com.metamatrix.common.protocol.MetaMatrixURLStreamHandlerFactory;
import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.CryptoUtil;
import com.metamatrix.common.vdb.api.VDBDefn;
import com.metamatrix.data.monitor.AliveStatus;
import com.metamatrix.dqp.embedded.DQPEmbeddedPlugin;
import com.metamatrix.dqp.embedded.DataClientConnection;
import com.metamatrix.dqp.embedded.configuration.ExtensionModuleReader;
import com.metamatrix.dqp.embedded.services.EmbeddedBaseDQPService;
import com.metamatrix.dqp.internal.datamgr.ConnectorID;
import com.metamatrix.dqp.internal.datamgr.ConnectorManager;
import com.metamatrix.dqp.internal.datamgr.impl.ConnectorManagerImpl;
import com.metamatrix.dqp.message.AdminRequestMessage;
import com.metamatrix.dqp.message.AdminResultsMessage;
import com.metamatrix.dqp.message.AtomicRequestMessage;
import com.metamatrix.dqp.message.CapabilitiesMessage;
import com.metamatrix.dqp.message.RequestMessage;
import com.metamatrix.dqp.service.DQPServiceRegistry;
import com.metamatrix.dqp.service.DataService;
import com.metamatrix.dqp.service.ServiceWrapper;
import com.metamatrix.query.j.e.a;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class EmbeddedDataService
extends EmbeddedBaseDQPService
implements DataService {
    private static final String SYSTEM_PHYSICAL_MODEL_CONNECTOR_BINDING_CLASSNAME = "com.metamatrix.dqp.embedded.services.DefaultIndexConnectorBinding";
    private static final String CONNECTOR_MGR_IMPL = "com.metamatrix.dqp.internal.datamgr.impl.ConnectorManagerImpl";
    private static final String CONNECTOR_CLASSPATH = "ConnectorClassPath";
    private Map connectorIDs = new HashMap();
    private Map connectorMgrs = new HashMap();
    private int counter = 0;
    private Map loadedConnectorBindingsMap = new HashMap();
    static /* synthetic */ Class class$com$metamatrix$dqp$service$MetadataService;
    static /* synthetic */ Class class$com$metamatrix$dqp$service$metadata$IndexSelectorSource;
    static /* synthetic */ Class class$com$metamatrix$dqp$service$VDBService;
    static /* synthetic */ Class class$com$metamatrix$dqp$service$TrackingService;

    public EmbeddedDataService(DQPServiceRegistry svcRegistry) throws MetaMatrixComponentException {
        super("dqp.data", svcRegistry);
    }

    public ConnectorID selectConnector(String connectorBindingName) throws MetaMatrixComponentException {
        ConnectorID id = (ConnectorID)this.connectorIDs.get(connectorBindingName);
        if (id == null) {
            throw new ComponentNotFoundException(DQPEmbeddedPlugin.Util.getString("DataService.Connector_State_invalid", new Object[]{connectorBindingName}));
        }
        return id;
    }

    public String getConnectorBindingName(ConnectorID connector) {
        if (this.connectorIDs.containsValue(connector)) {
            Iterator it = this.connectorIDs.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                ConnectorID value = (ConnectorID)this.connectorIDs.get(key);
                if (!value.equals(connector)) continue;
                return key;
            }
        }
        return null;
    }

    public void executeRequest(AtomicRequestMessage request, ConnectorID connector, MessageListener listener) throws MetaMatrixComponentException {
        ConnectorManager mgr = this.getConnectorManager(connector);
        if (mgr == null) {
            throw new ComponentNotFoundException(DQPEmbeddedPlugin.Util.getString("DataService.Unable_to_find_connector_manager_for_{0}_1", new Object[]{connector}));
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("connectionID", request.getConnectionID());
        props.put("trustedPayload", request.getTrustedPayload());
        props.put("user", request.getUserName());
        props.put("vdbName", request.getVdbName());
        props.put("vdbVersion", request.getVdbVersion());
        DataClientConnection conn = new DataClientConnection(listener, props);
        mgr.receive(conn, request, null);
    }

    public a getCapabilities(RequestMessage request, ConnectorID connector) throws MetaMatrixComponentException {
        ConnectorManager mgr = this.getConnectorManager(connector);
        if (mgr != null) {
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put("connectionID", request.getConnectionID());
            props.put("trustedPayload", request.getTrustedPayload());
            props.put("user", request.getUserName());
            props.put("vdbName", request.getVdbName());
            props.put("vdbVersion", request.getVdbVersion());
            DataClientConnection conn = new DataClientConnection(null, props);
            try {
                CapabilitiesMessage capMsg = new CapabilitiesMessage();
                ClientConnection clientConn = request.getClientConnection();
                capMsg.assignToClientConnection(clientConn);
                capMsg.setUserParameters(clientConn);
                CapabilitiesMessage resultMsg = (CapabilitiesMessage)mgr.receive(conn, capMsg);
                return resultMsg.getCaps();
            }
            catch (ApplicationException e2) {
                throw new MetaMatrixComponentException((Throwable)e2, e2.getMessage());
            }
        }
        throw new ComponentNotFoundException(DQPEmbeddedPlugin.Util.getString("DataService.Unable_to_find_connector_manager_for_{0}_1", new Object[]{connector}));
    }

    public Collection getConnectorBindingStatistics(String connectorBindingName) throws MetaMatrixComponentException {
        AdminRequestMessage msg = new AdminRequestMessage();
        msg.setRequestType(2);
        return this.processAdminMessage(connectorBindingName, msg);
    }

    public void clearConnectorBindingCache(String connectorBindingName) throws MetaMatrixComponentException {
        AdminRequestMessage msg = new AdminRequestMessage();
        msg.setRequestType(6);
        this.processAdminMessage(connectorBindingName, msg);
    }

    Collection processAdminMessage(String connectorBindingName, AdminRequestMessage msg) throws MetaMatrixComponentException {
        ConnectorManager mgr = this.getConnectorManager(connectorBindingName);
        if (mgr != null) {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("connectionID", "0");
            DataClientConnection conn = new DataClientConnection(null, props);
            try {
                AdminResultsMessage resultMsg = (AdminResultsMessage)mgr.receive(conn, msg);
                return resultMsg.getResults();
            }
            catch (ApplicationException e2) {
                throw new MetaMatrixComponentException((Throwable)e2, e2.getMessage());
            }
        }
        throw new ComponentNotFoundException(DQPEmbeddedPlugin.Util.getString("DataService.Unable_to_find_connector_manager_for_{0}_1", new Object[]{connectorBindingName}));
    }

    public void addConnectorBinding(String connectorBindingName, ConnectorBinding binding, boolean replace) throws ApplicationLifecycleException, MetaMatrixComponentException {
        boolean add = false;
        if (this.getConnectorBinding(connectorBindingName) != null) {
            if (replace) {
                DQPEmbeddedPlugin.logInfo("DataService.Connector_exists_replace", new Object[]{connectorBindingName});
                this.stopConnectorBinding(connectorBindingName);
                add = true;
            } else {
                DQPEmbeddedPlugin.logInfo("DataService.Connector_exists", new Object[]{connectorBindingName});
            }
        } else {
            add = true;
        }
        if (add) {
            ConnectorBindingType type = this.getConfigurationService().getConnectorType(binding.getComponentTypeID().getName());
            if (type != null) {
                binding = this.getConfigurationService().saveConnectorBinding(binding);
                this.createConnectorManger(connectorBindingName, binding);
                DQPEmbeddedPlugin.logInfo("DataService.Connector_Added", new Object[]{connectorBindingName});
            } else {
                throw new MetaMatrixComponentException(DQPEmbeddedPlugin.Util.getString("DataService.Connector_type_does_not_exists", new Object[]{connectorBindingName}));
            }
        }
    }

    public void deleteConnectorBinding(String connectorBindingName) throws ApplicationLifecycleException, MetaMatrixComponentException {
        ConnectorBinding binding = this.getConnectorBinding(connectorBindingName);
        if (binding != null) {
            if (this.getConfigurationService().isAssigned(binding)) {
                throw new MetaMatrixComponentException(DQPEmbeddedPlugin.Util.getString("DataService.Connector_still_used", connectorBindingName));
            }
        } else {
            throw new MetaMatrixComponentException(DQPEmbeddedPlugin.Util.getString("DataService.Connector_does_not_exists", connectorBindingName));
        }
        this.stopConnectorBinding(connectorBindingName);
        this.getConfigurationService().deleteConnectorBinding(connectorBindingName);
        DQPEmbeddedPlugin.logInfo("DataService.Connector_Deleted", new Object[]{connectorBindingName});
    }

    public void updateConnectorBinding(ConnectorBinding binding) throws ApplicationLifecycleException, MetaMatrixComponentException {
        ConnectorBinding localBinding = this.getConnectorBinding(binding.getName());
        if (localBinding == null) {
            throw new MetaMatrixComponentException(DQPEmbeddedPlugin.Util.getString("DataService.Connector_does_not_exists", binding.getName()));
        }
        binding = this.getConfigurationService().saveConnectorBinding(binding);
        DQPEmbeddedPlugin.logInfo("DataService.Connector_modified", new Object[]{binding.getName()});
    }

    public void startConnectorBinding(String connectorBindingName) throws ApplicationLifecycleException, MetaMatrixComponentException {
        ConnectorManager mgr = this.getConnectorManager(connectorBindingName);
        if (mgr != null) {
            if (!mgr.started()) {
                try {
                    mgr.installService("dqp.metadata", ServiceWrapper.create(new Class[]{class$com$metamatrix$dqp$service$MetadataService == null ? (class$com$metamatrix$dqp$service$MetadataService = EmbeddedDataService.class$("com.metamatrix.dqp.service.MetadataService")) : class$com$metamatrix$dqp$service$MetadataService, class$com$metamatrix$dqp$service$metadata$IndexSelectorSource == null ? (class$com$metamatrix$dqp$service$metadata$IndexSelectorSource = EmbeddedDataService.class$("com.metamatrix.dqp.service.metadata.IndexSelectorSource")) : class$com$metamatrix$dqp$service$metadata$IndexSelectorSource}, this.lookupService("dqp.metadata")));
                    mgr.installService("dqp.vdb", ServiceWrapper.create(new Class[]{class$com$metamatrix$dqp$service$VDBService == null ? (class$com$metamatrix$dqp$service$VDBService = EmbeddedDataService.class$("com.metamatrix.dqp.service.VDBService")) : class$com$metamatrix$dqp$service$VDBService}, this.lookupService("dqp.vdb")));
                    mgr.installService("dqp.tracking", ServiceWrapper.create(new Class[]{class$com$metamatrix$dqp$service$TrackingService == null ? (class$com$metamatrix$dqp$service$TrackingService = EmbeddedDataService.class$("com.metamatrix.dqp.service.TrackingService")) : class$com$metamatrix$dqp$service$TrackingService}, this.lookupService("dqp.tracking")));
                }
                catch (ApplicationInitializationException e2) {
                    throw new ApplicationLifecycleException(e2);
                }
                mgr.start();
                String connectorId = mgr.getConnectorEnvironment().getProperties().getProperty("ConnectorID");
                ConnectorID connID = new ConnectorID(connectorId);
                this.connectorIDs.put(connectorBindingName, connID);
                this.connectorMgrs.put(connID, mgr);
                this.loadedConnectorBindingsMap.put(connectorBindingName, this.getConnectorBinding(connectorBindingName));
                DQPEmbeddedPlugin.logInfo("DataService.Connector_Started", new Object[]{connectorBindingName});
            }
        } else {
            throw new ApplicationLifecycleException(DQPEmbeddedPlugin.Util.getString("DataService.Unable_to_find_connector", connectorBindingName));
        }
    }

    public void stopConnectorBinding(String connectorBindingName) throws ApplicationLifecycleException, MetaMatrixComponentException {
        ConnectorBinding binding = this.getConnectorBinding(connectorBindingName);
        if (binding != null) {
            ConnectorManager mgr = this.getConnectorManager(connectorBindingName, false);
            if (mgr != null && mgr.started()) {
                mgr.stop();
                this.removeConnectorBinding(connectorBindingName);
                DQPEmbeddedPlugin.logInfo("DataService.Connector_Stopped", new Object[]{connectorBindingName});
            }
        } else {
            throw new ApplicationLifecycleException(DQPEmbeddedPlugin.Util.getString("DataService.Unable_to_find_connector", connectorBindingName));
        }
    }

    public List getConnectorBindings() throws MetaMatrixComponentException {
        List list = this.getConfigurationService().getConnectorBindings();
        return list;
    }

    public AliveStatus getConnectorBindingState(String connectorBindingName) throws MetaMatrixComponentException {
        ConnectorManager mgr = this.getConnectorManager(connectorBindingName);
        if (mgr != null) {
            return mgr.getStatus().getStatus();
        }
        throw new MetaMatrixComponentException(DQPEmbeddedPlugin.Util.getString("DataService.Unable_to_find_connector", connectorBindingName));
    }

    public void initializeService(Properties props) throws ApplicationInitializationException {
    }

    public void startService(ApplicationEnvironment environment) throws ApplicationLifecycleException {
        try {
            this.startConnectorBinding("SystemPhysical");
            ArrayList otherBindings = new ArrayList();
            List vdbs = this.getConfigurationService().getVDBs();
            Iterator i2 = vdbs.iterator();
            while (i2.hasNext()) {
                VDBDefn vdb = (VDBDefn)i2.next();
                if (vdb.getStatus() != 3) continue;
                otherBindings.addAll(vdb.getConnectorBindings().keySet());
            }
            i2 = otherBindings.iterator();
            while (i2.hasNext()) {
                Object connectorBindingName = null;
                try {
                    String bindingName = (String)i2.next();
                    this.startConnectorBinding(bindingName);
                }
                catch (ApplicationLifecycleException e2) {
                    DQPEmbeddedPlugin.logError(e2, "DataService.Connector_failed_start", new Object[]{connectorBindingName});
                }
                catch (MetaMatrixComponentException e3) {
                    DQPEmbeddedPlugin.logError(e3, "DataService.Connector_failed_start", new Object[]{connectorBindingName});
                }
            }
            DQPEmbeddedPlugin.logInfo("DataService.Started", null);
        }
        catch (MetaMatrixComponentException e4) {
            DQPEmbeddedPlugin.logError(e4, "DataService.Failed_To_Start", null);
            throw new ApplicationLifecycleException(e4);
        }
    }

    public void stopService() throws ApplicationLifecycleException {
        String[] connectorBindings = this.loadedConnectorBindingsMap.keySet().toArray(new String[this.loadedConnectorBindingsMap.keySet().size()]);
        for (int i2 = 0; i2 < connectorBindings.length; ++i2) {
            try {
                this.stopConnectorBinding(connectorBindings[i2]);
                continue;
            }
            catch (MetaMatrixComponentException e2) {
                throw new ApplicationLifecycleException(e2);
            }
        }
        this.connectorMgrs.clear();
        this.connectorIDs.clear();
        this.loadedConnectorBindingsMap.clear();
        DQPEmbeddedPlugin.logInfo("DataService.Stopped", null);
    }

    ConnectorManager getConnectorManager(String connectorName, boolean create) throws MetaMatrixComponentException {
        ConnectorID connectionId = (ConnectorID)this.connectorIDs.get(connectorName);
        if (connectionId == null && create) {
            ConnectorBinding binding = this.getConnectorBinding(connectorName);
            if (binding == null) {
                throw new MetaMatrixComponentException(DQPEmbeddedPlugin.Util.getString("DataService.failed_to_load_connector", new Object[]{connectorName}));
            }
            return this.createConnectorManger(connectorName, binding);
        }
        return (ConnectorManager)this.connectorMgrs.get(connectionId);
    }

    ConnectorManager getConnectorManager(String connectorName) throws MetaMatrixComponentException {
        return this.getConnectorManager(connectorName, true);
    }

    ConnectorManager getConnectorManager(ConnectorID connID) {
        if (connID != null) {
            return (ConnectorManager)this.connectorMgrs.get(connID);
        }
        return null;
    }

    public ConnectorBinding getConnectorBinding(String connectorName) throws MetaMatrixComponentException {
        ConnectorBinding binding = (ConnectorBinding)this.loadedConnectorBindingsMap.get(connectorName);
        if (binding == null) {
            binding = "SystemPhysical".equals(connectorName) ? this.getSystemModelBinding() : this.getConfigurationService().getConnectorBinding(connectorName);
        }
        return binding;
    }

    ConnectorManager createConnectorManger(String connectorBindingName, ConnectorBinding binding) throws MetaMatrixComponentException {
        Properties connectorProperties = this.getDecryptedProperties(binding);
        String connectorId = String.valueOf(this.counter++);
        connectorProperties.setProperty("ConnectorID", connectorId);
        connectorProperties.setProperty("ConnectorBindingName", connectorBindingName);
        boolean useExtensionClassPath = this.getConfigurationService().useExtensionClasspath();
        boolean useUnifiedClassLoader = this.getConfigurationService().useUnifiedClassLoader();
        if (useExtensionClassPath) {
            connectorProperties.setProperty("deregisterDriver", "deregisterByClassLoader");
        } else if (!useExtensionClassPath && !useUnifiedClassLoader) {
            connectorProperties.setProperty("deregisterDriver", "deregisterByClassName");
        }
        try {
            ConnectorManager mgr = this.initConnectorManager(binding, connectorProperties);
            mgr.initialize(connectorProperties);
            return mgr;
        }
        catch (Exception e2) {
            DQPEmbeddedPlugin.logError(e2, "DataService.Failed_Initialize_CM", new Object[]{binding.getName()});
            throw new MetaMatrixComponentException(e2);
        }
    }

    private void removeConnectorBinding(String connectorBindingName) throws MetaMatrixComponentException, ApplicationLifecycleException {
        ConnectorID id = this.selectConnector(connectorBindingName);
        this.connectorMgrs.remove(id);
        this.connectorIDs.remove(connectorBindingName);
        this.loadedConnectorBindingsMap.remove(connectorBindingName);
    }

    Properties getDecryptedProperties(ConnectorBinding binding) throws MetaMatrixComponentException {
        ConnectorBindingType defaultType;
        Properties bindingProperties = binding.getProperties();
        Properties decryptedProperties = new Properties();
        ComponentTypeID id = binding.getComponentTypeID();
        ConnectorBindingType type = this.getConfigurationService().getConnectorType(id.getName());
        Properties props = null;
        props = this.getConfigurationService().getDefaultProperties(binding);
        if ((props == null || props.isEmpty()) && (defaultType = this.getConfigurationService().getConnectorType("Connector")) != null) {
            props = defaultType.getDefaultPropertyValues();
        }
        if (props != null && !props.isEmpty()) {
            decryptedProperties.putAll((Map<?, ?>)props);
        }
        decryptedProperties.putAll((Map<?, ?>)bindingProperties);
        Iterator<Object> it = bindingProperties.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            if (!this.isMaskedProperty(name, type)) continue;
            try {
                String value = this.decryptProperty(bindingProperties.getProperty(name));
                decryptedProperties.setProperty(name, value);
            }
            catch (CryptoException e2) {
                DQPEmbeddedPlugin.logError(e2, "DataService.decryption_failed", new Object[]{binding.getName(), name});
            }
        }
        return decryptedProperties;
    }

    protected boolean isMaskedProperty(String propName, ComponentType type) {
        ComponentTypeDefn typeDef;
        return type != null && (typeDef = type.getComponentTypeDefinition(propName)) != null && typeDef.getPropertyDefinition().isMasked();
    }

    protected String decryptProperty(String value) throws CryptoException {
        if (value != null && value.length() > 0) {
            return new String(CryptoUtil.stringDecrypt(value.toCharArray()));
        }
        return value;
    }

    public void bindService() throws ApplicationLifecycleException {
    }

    public void unbindService() throws ApplicationLifecycleException {
    }

    ConnectorBinding getSystemModelBinding() throws MetaMatrixComponentException {
        try {
            Class<?> serviceClass = Class.forName(SYSTEM_PHYSICAL_MODEL_CONNECTOR_BINDING_CLASSNAME);
            return (ConnectorBinding)serviceClass.newInstance();
        }
        catch (Exception e2) {
            DQPEmbeddedPlugin.logError(e2, "DataService.Connector_failed_start", new Object[]{"SystemPhysical"});
            throw new MetaMatrixComponentException(e2);
        }
    }

    ConnectorManager initConnectorManager(ConnectorBinding binding, Properties connectorProperties) throws ApplicationLifecycleException {
        try {
            ConnectorManagerImpl mgr = null;
            boolean useExtensionClassPath = this.getConfigurationService().useExtensionClasspath();
            String classPath = connectorProperties.getProperty(CONNECTOR_CLASSPATH);
            if (classPath == null || classPath.length() == 0) {
                useExtensionClassPath = false;
            }
            if (useExtensionClassPath) {
                DQPEmbeddedPlugin.logInfo("DataService.useClassloader", new Object[]{classPath});
                URL context = this.getConfigurationService().getExtensionPath();
                URL[] urlPath = ExtensionModuleReader.resolveExtensionClasspath(classPath, context);
                NonDelegatingClassLoader classLoader = new NonDelegatingClassLoader(urlPath, Thread.currentThread().getContextClassLoader(), (URLStreamHandlerFactory)new MetaMatrixURLStreamHandlerFactory());
                Class<?> cmgrImplClass = classLoader.loadClass(CONNECTOR_MGR_IMPL);
                connectorProperties.put("ConnectorClassLoader", classLoader);
                return (ConnectorManager)cmgrImplClass.newInstance();
            }
            mgr = new ConnectorManagerImpl();
            return mgr;
        }
        catch (Exception e2) {
            throw new ApplicationLifecycleException(e2);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

