/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.embedded.services;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.application.ApplicationEnvironment;
import com.metamatrix.common.application.exception.ApplicationInitializationException;
import com.metamatrix.common.application.exception.ApplicationLifecycleException;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.ConnectorBindingType;
import com.metamatrix.common.vdb.api.ModelInfo;
import com.metamatrix.common.vdb.api.VDBDefn;
import com.metamatrix.common.vdb.api.VDBStream;
import com.metamatrix.dqp.embedded.DQPEmbeddedPlugin;
import com.metamatrix.dqp.embedded.services.EmbeddedBaseDQPService;
import com.metamatrix.dqp.service.DQPServiceRegistry;
import com.metamatrix.dqp.service.VDBService;
import com.metamatrix.license.LicenseChecker;
import com.metamatrix.modeler.core.metadata.runtime.MetadataConstants;
import com.metamatrix.vdb.internal.runtime.model.BasicModelInfo;
import com.metamatrix.vdb.internal.runtime.model.BasicVDBDefn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class EmbeddedVDBService
extends EmbeddedBaseDQPService
implements VDBService {
    static final String[] VDB_STATUS = new String[]{"INCOMPLETE", "INACTIVE", "ACTIVE", "DELETED"};

    public EmbeddedVDBService(DQPServiceRegistry svcRegistry) throws MetaMatrixComponentException {
        super("dqp.vdb", svcRegistry);
    }

    private VDBDefn getVDB(String vdbName, String vdbVersion) throws MetaMatrixComponentException {
        VDBDefn vdb = this.getConfigurationService().getVDB(vdbName, vdbVersion);
        if (vdb == null) {
            throw new MetaMatrixComponentException(DQPEmbeddedPlugin.Util.getString("VDBService.VDB_does_not_exist._2", new Object[]{vdbName, vdbVersion}));
        }
        return vdb;
    }

    private boolean isSystemModel(String modelName) {
        return modelName.equalsIgnoreCase("SystemPhysical");
    }

    private ModelInfo getModel(VDBDefn vdb, String modelName) {
        Collection c2 = vdb.getModels();
        Iterator it = c2.iterator();
        while (it.hasNext()) {
            ModelInfo model = (ModelInfo)it.next();
            if (!model.getName().equals(modelName)) continue;
            return model;
        }
        return null;
    }

    public List getConnectorBindingNames(String vdbName, String vdbVersion, String modelName) throws MetaMatrixComponentException {
        if (this.isSystemModel(modelName)) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("SystemPhysical");
            return list;
        }
        VDBDefn vdb = this.getVDB(vdbName, vdbVersion);
        ModelInfo m2 = vdb.getModel(modelName);
        if (m2 == null) {
            ArrayList<String> bindingList = new ArrayList<String>();
            bindingList.add(modelName);
            return bindingList;
        }
        List bindingList = m2.getConnectorBindingNames();
        if (bindingList != null && bindingList.size() > 0) {
            return bindingList;
        }
        throw new MetaMatrixComponentException(DQPEmbeddedPlugin.Util.getString("VDBService.VDB_does_not_exist._3", new Object[]{vdbName, vdbVersion, modelName}));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void mapConnectorBindings(String vdbName, String vdbVersion, String modelName, List connectorBindings) throws MetaMatrixComponentException {
        ConnectorBinding binding = (ConnectorBinding)connectorBindings.get(0);
        BasicVDBDefn vdb = (BasicVDBDefn)this.getVDB(vdbName, vdbVersion);
        if (binding == null || vdb == null) throw new MetaMatrixComponentException(DQPEmbeddedPlugin.Util.getString("VDBService.VDB_does_not_exist._2", new Object[]{vdbName, vdbVersion}));
        Map currentBindings = vdb.getConnectorBindings();
        if (!LicenseChecker.hasValidProductLicense("Sources", "5.0", currentBindings.size() + 1)) {
            throw new MetaMatrixComponentException(DQPEmbeddedPlugin.Util.getString("Admin.bindings_exceeded_limit"));
        }
        BasicModelInfo model = (BasicModelInfo)this.getModel(vdb, modelName);
        if (model == null) throw new MetaMatrixComponentException(DQPEmbeddedPlugin.Util.getString("VDBService.VDB_does_not_exist._3", new Object[]{vdbName, vdbVersion, modelName}));
        ArrayList<String> newBindingNames = new ArrayList<String>();
        for (int i2 = 0; i2 < connectorBindings.size(); ++i2) {
            ConnectorBinding tgtBinding = (ConnectorBinding)connectorBindings.get(i2);
            newBindingNames.add(tgtBinding.getFullName());
            ConnectorBindingType type = this.getConfigurationService().getConnectorType(tgtBinding.getComponentTypeID().getName());
            vdb.addConnectorType(type);
            vdb.addConnectorBinding(model.getName(), tgtBinding);
        }
        model.setConnectorBindingNames(newBindingNames);
        Iterator i3 = currentBindings.values().iterator();
        while (i3.hasNext()) {
            ConnectorBinding currentBinding = (ConnectorBinding)i3.next();
            if (vdb.isBindingInUse(currentBinding)) continue;
            vdb.removeConnectorBinding(currentBinding.getName());
        }
        this.getConfigurationService().saveVDB(vdb, vdb.getVersion());
        DQPEmbeddedPlugin.logInfo("VDBService.connector_binding_changed", new Object[]{vdbName, vdbVersion, modelName, newBindingNames});
    }

    public int getModelVisibility(String vdbName, String vdbVersion, String modelName) throws MetaMatrixComponentException {
        if (this.isSystemModel(modelName)) {
            return 1;
        }
        if (MetadataConstants.isSystemModelWithSystemTableType(modelName)) {
            return 0;
        }
        VDBDefn vdb = this.getVDB(vdbName, vdbVersion);
        ModelInfo model = this.getModel(vdb, modelName);
        if (model != null) {
            return model.getVisibility();
        }
        return 1;
    }

    public int getFileVisibility(String vdbName, String vdbVersion, String pathInVDB) throws MetaMatrixComponentException {
        Path filePath = new Path(pathInVDB);
        IPath updatedFilePath = filePath.removeFileExtension();
        String modelName = updatedFilePath.lastSegment();
        if (this.isSystemModel(modelName)) {
            return 1;
        }
        if (MetadataConstants.isSystemModelWithSystemTableType(modelName)) {
            return 0;
        }
        VDBDefn vdb = this.getVDB(vdbName, vdbVersion);
        ModelInfo model = this.getModel(vdb, modelName);
        if (model != null) {
            return model.getVisibility();
        }
        return vdb.isVisible(pathInVDB) ? 0 : 1;
    }

    public VDBStream getVDBResource(String vdbName, String vdbVersion) throws MetaMatrixComponentException {
        VDBDefn vdb = this.getVDB(vdbName, vdbVersion);
        return vdb.getVDBStream();
    }

    public List getMultiSourceModels(String vdbName, String vdbVersion) throws MetaMatrixComponentException {
        VDBDefn vdb = this.getVDB(vdbName, vdbVersion);
        ArrayList multiSourceModels = new ArrayList();
        Map mappings = vdb.getModelToBindingMappings();
        Iterator iter = mappings.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            List bindings = (List)entry.getValue();
            if (bindings == null || bindings.size() <= 1) continue;
            multiSourceModels.add(entry.getKey());
        }
        return multiSourceModels;
    }

    public List getAvailableVDBs() throws MetaMatrixComponentException {
        List fullList = this.getConfigurationService().getVDBs();
        ArrayList<VDBDefn> activeList = new ArrayList<VDBDefn>();
        Iterator i2 = fullList.iterator();
        while (i2.hasNext()) {
            VDBDefn vdb = (VDBDefn)i2.next();
            if (vdb.getStatus() == 4) continue;
            activeList.add(vdb);
        }
        return activeList;
    }

    public VDBDefn deployVDB(VDBDefn vdb) throws MetaMatrixComponentException {
        if (vdb != null) {
            boolean exists = false;
            try {
                VDBDefn existingVdb = this.getVDB(vdb.getName(), vdb.getVersion());
                exists = true;
                DQPEmbeddedPlugin.logWarning("VDBService.vdb_already_exists", new Object[]{existingVdb.getName(), existingVdb.getVersion()});
            }
            catch (MetaMatrixComponentException e2) {
                exists = false;
            }
            this.updateBindings(vdb);
            vdb = this.getConfigurationService().saveVDB(vdb, exists ? "NEXT_VDB_VERSION" : vdb.getVersion());
            if (!this.isValidVDB(vdb)) {
                ((BasicVDBDefn)vdb).setStatus((short)1);
            } else {
                ((BasicVDBDefn)vdb).setStatus((short)3);
                DQPEmbeddedPlugin.logInfo("VDBService.vdb_active", new Object[]{vdb.getName(), vdb.getVersion()});
            }
            DQPEmbeddedPlugin.logInfo("VDBService.vdb_deployed", new Object[]{vdb.getName(), vdb.getVersion()});
            return vdb;
        }
        throw new MetaMatrixComponentException(DQPEmbeddedPlugin.Util.getString("VDBService.failed_load"));
    }

    void updateBindings(VDBDefn vdbDefn) throws MetaMatrixComponentException {
        BasicVDBDefn vdb = (BasicVDBDefn)vdbDefn;
        ArrayList bindings = new ArrayList(vdb.getConnectorBindings().values());
        Iterator i2 = bindings.iterator();
        while (i2.hasNext()) {
            ConnectorBinding vdbbinding = (ConnectorBinding)i2.next();
            Collection models = this.getModelsUsingBinding(vdb, vdbbinding);
            if (models.isEmpty()) continue;
            vdb.removeConnectorBinding(vdbbinding.getName());
            vdb.removeConnectorType(vdbbinding.getComponentTypeID().getName());
            ConnectorBinding configbinding = this.getConfigurationService().getConnectorBinding(vdbbinding.getName());
            if (configbinding == null) continue;
            ConnectorBindingType type = this.getConfigurationService().getConnectorType(configbinding.getComponentTypeID().getName());
            vdb.addConnectorType(type);
            Iterator m2 = models.iterator();
            while (m2.hasNext()) {
                BasicModelInfo model = (BasicModelInfo)m2.next();
                vdb.addConnectorBinding(model.getName(), configbinding);
            }
        }
    }

    Collection getModelsUsingBinding(VDBDefn vdb, ConnectorBinding binding) {
        ArrayList<BasicModelInfo> modelsInUse = null;
        Collection models = vdb.getModels();
        Iterator i2 = models.iterator();
        while (i2.hasNext()) {
            BasicModelInfo model = (BasicModelInfo)i2.next();
            if (!model.isPhysical() || model.getConnectorBindingNames().isEmpty()) continue;
            if (modelsInUse == null) {
                modelsInUse = new ArrayList<BasicModelInfo>();
            }
            String name = (String)model.getConnectorBindingNames().get(0);
            if (!binding.getFullName().equals(name)) continue;
            modelsInUse.add(model);
        }
        if (modelsInUse == null) {
            return Collections.EMPTY_LIST;
        }
        return modelsInUse;
    }

    boolean isValidVDB(VDBDefn vdb) throws MetaMatrixComponentException {
        if (vdb.doesVDBHaveValidityError()) {
            String[] errors = vdb.getVDBValidityErrors();
            StringBuffer sb = new StringBuffer();
            for (int i2 = 0; i2 < errors.length; ++i2) {
                sb.append("-").append(errors[i2]).append(";");
            }
            DQPEmbeddedPlugin.logError("VDBService.validityErrors", new Object[]{vdb.getName(), sb});
            return false;
        }
        Collection models = vdb.getModels();
        Iterator i3 = models.iterator();
        while (i3.hasNext()) {
            ModelInfo model = (ModelInfo)i3.next();
            if (!model.isPhysical()) continue;
            if (model.getConnectorBindingNames().isEmpty()) {
                DQPEmbeddedPlugin.logWarning("VDBService.vdb_missing_bindings", new Object[]{vdb.getName(), vdb.getVersion()});
                return false;
            }
            String bindingName = (String)model.getConnectorBindingNames().get(0);
            if (this.getConfigurationService().getConnectorBinding(bindingName) != null) continue;
            DQPEmbeddedPlugin.logWarning("VDBService.vdb_missing_bindings", new Object[]{vdb.getName(), vdb.getVersion()});
            return false;
        }
        return true;
    }

    public int getVDBStatus(String vdbName, String vdbVersion) throws MetaMatrixComponentException {
        VDBDefn vdb = this.getVDB(vdbName, vdbVersion);
        return vdb.getStatus();
    }

    public VDBDefn changeVDBStatus(String vdbName, String vdbVersion, int status) throws MetaMatrixComponentException {
        VDBDefn vdb = this.getVDB(vdbName, vdbVersion);
        short currentStatus = vdb.getStatus();
        VDBDefn saved = vdb;
        if (status != currentStatus) {
            BasicVDBDefn sameVdb = (BasicVDBDefn)vdb;
            if (currentStatus != 3 && status == 3 && !this.isValidVDB(sameVdb)) {
                throw new MetaMatrixComponentException(DQPEmbeddedPlugin.Util.getString("VDBService.vdb_missing_bindings", new Object[]{vdb.getName(), vdb.getVersion()}));
            }
            sameVdb.setStatus((short)status);
            if (currentStatus == 1 && status == 4) {
                saved = this.getConfigurationService().deleteVDB(vdbName, vdb.getVersion());
            } else {
                if (status != sameVdb.getStatus()) {
                    throw new MetaMatrixComponentException(DQPEmbeddedPlugin.Util.getString("VDBService.vdb_change_status_failed", new Object[]{vdbName, vdbVersion, VDB_STATUS[currentStatus - 1], VDB_STATUS[status - 1]}));
                }
                saved = this.getConfigurationService().saveVDB(vdb, vdb.getVersion());
                DQPEmbeddedPlugin.logInfo("VDBService.vdb_change_status", new Object[]{vdbName, vdbVersion, VDB_STATUS[currentStatus - 1], VDB_STATUS[status - 1]});
            }
        }
        return saved;
    }

    public String getConnectorName(String connectorBindingID) {
        return connectorBindingID;
    }

    public void initializeService(Properties properties) throws ApplicationInitializationException {
    }

    public void startService(ApplicationEnvironment environment) throws ApplicationLifecycleException {
    }

    public void bindService() throws ApplicationLifecycleException {
    }

    public void unbindService() throws ApplicationLifecycleException {
    }

    public void stopService() throws ApplicationLifecycleException {
    }
}

