/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.datamgr.language;

import com.metamatrix.data.language.ICriteria;
import com.metamatrix.data.language.IFrom;
import com.metamatrix.data.language.IGroupBy;
import com.metamatrix.data.language.ILimit;
import com.metamatrix.data.language.IOrderBy;
import com.metamatrix.data.language.IQuery;
import com.metamatrix.data.language.ISelect;
import com.metamatrix.data.language.ISelectSymbol;
import com.metamatrix.data.visitor.framework.LanguageObjectVisitor;
import com.metamatrix.dqp.internal.datamgr.language.BaseLanguageObject;
import java.util.Iterator;
import java.util.List;

public class QueryImpl
extends BaseLanguageObject
implements IQuery {
    private ISelect select = null;
    private IFrom from = null;
    private ICriteria where = null;
    private IGroupBy groupBy = null;
    private ICriteria having = null;
    private IOrderBy orderBy = null;
    private ILimit limit = null;

    public QueryImpl(ISelect select, IFrom from, ICriteria where, IGroupBy groupBy, ICriteria having, IOrderBy orderBy) {
        this.select = select;
        this.from = from;
        this.where = where;
        this.groupBy = groupBy;
        this.having = having;
        this.orderBy = orderBy;
    }

    public ISelect getSelect() {
        return this.select;
    }

    public IFrom getFrom() {
        return this.from;
    }

    public ICriteria getWhere() {
        return this.where;
    }

    public IGroupBy getGroupBy() {
        return this.groupBy;
    }

    public ICriteria getHaving() {
        return this.having;
    }

    public IOrderBy getOrderBy() {
        return this.orderBy;
    }

    public ILimit getLimit() {
        return this.limit;
    }

    public String[] getColumnNames() {
        List selectSymbols = this.getSelect().getSelectSymbols();
        String[] columnNames = new String[selectSymbols.size()];
        int symbolIndex = 0;
        Iterator i2 = selectSymbols.iterator();
        while (i2.hasNext()) {
            columnNames[symbolIndex] = ((ISelectSymbol)i2.next()).getOutputName();
            ++symbolIndex;
        }
        return columnNames;
    }

    public Class[] getColumnTypes() {
        List selectSymbols = this.getSelect().getSelectSymbols();
        Class[] columnTypes = new Class[selectSymbols.size()];
        int symbolIndex = 0;
        Iterator i2 = selectSymbols.iterator();
        while (i2.hasNext()) {
            ISelectSymbol symbol = (ISelectSymbol)i2.next();
            columnTypes[symbolIndex] = symbol.getExpression() == null ? null : symbol.getExpression().getType();
            ++symbolIndex;
        }
        return columnTypes;
    }

    public void acceptVisitor(LanguageObjectVisitor visitor) {
        visitor.visit(this);
    }

    public void setSelect(ISelect select) {
        this.select = select;
    }

    public void setFrom(IFrom from) {
        this.from = from;
    }

    public void setWhere(ICriteria criteria) {
        this.where = criteria;
    }

    public void setGroupBy(IGroupBy groupBy) {
        this.groupBy = groupBy;
    }

    public void setHaving(ICriteria criteria) {
        this.having = criteria;
    }

    public void setOrderBy(IOrderBy orderBy) {
        this.orderBy = orderBy;
    }

    public void setLimit(ILimit limit) {
        this.limit = limit;
    }
}

