/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.process;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.buffer.BlockedException;
import com.metamatrix.common.buffer.TupleSource;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.dqp.internal.process.DataTierManager;
import com.metamatrix.dqp.message.AtomicRequestMessage;
import com.metamatrix.query.o.i.s;
import java.util.Iterator;
import java.util.List;

public class DataTierTupleSource
implements TupleSource {
    private List schema;
    private AtomicRequestMessage aqr;
    private DataTierManager dataMgr;
    private List[] currentBatch;
    private List[] nextBatch;
    private int currentBatchCount = 0;
    private int index = 0;
    private boolean nextBatchIsLast = false;
    private boolean isLast = false;
    private int rowsProcessed = 0;
    private boolean waitingForData = false;
    private boolean hasLOB;

    public DataTierTupleSource(List schema, AtomicRequestMessage aqr, DataTierManager dataMgr) {
        this.schema = schema;
        this.hasLOB = false;
        Iterator i2 = schema.iterator();
        while (i2.hasNext()) {
            s exp = (s)i2.next();
            if (!DataTypeManager.DefaultDataClasses.BLOB.equals(exp.ag()) && !DataTypeManager.DefaultDataClasses.CLOB.equals(exp.ag())) continue;
            this.hasLOB = true;
            break;
        }
        this.aqr = aqr;
        this.dataMgr = dataMgr;
    }

    public synchronized void addBatch(List[] results, boolean isLast) {
        this.nextBatch = results;
        this.nextBatchIsLast = isLast;
        this.rowsProcessed += results.length;
        this.waitingForData = false;
    }

    public List getSchema() {
        return this.schema;
    }

    public void openSource() throws MetaMatrixComponentException {
    }

    public List nextTuple() throws MetaMatrixComponentException {
        if (this.index < this.currentBatchCount) {
            return this.currentBatch[this.index++];
        }
        if (this.isLast) {
            return null;
        }
        this.switchBatch();
        if (this.currentBatchCount == 0) {
            if (this.isLast) {
                return null;
            }
            throw BlockedException.INSTANCE;
        }
        return this.currentBatch[this.index++];
    }

    private synchronized void requestBatch() throws MetaMatrixComponentException {
        if (!this.waitingForData) {
            int nextRow = this.rowsProcessed + 1;
            this.aqr.setNextRow(nextRow);
            this.dataMgr.registerRequest(this.aqr);
            this.waitingForData = true;
        }
    }

    private synchronized void switchBatch() throws MetaMatrixComponentException {
        if (this.nextBatch == null) {
            this.requestBatch();
            throw BlockedException.INSTANCE;
        }
        this.currentBatch = this.nextBatch;
        this.isLast = this.nextBatchIsLast;
        this.currentBatchCount = this.currentBatch.length;
        this.index = 0;
        this.nextBatch = null;
        if (!this.isLast) {
            this.requestBatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSource() throws MetaMatrixComponentException {
        DataTierTupleSource dataTierTupleSource = this;
        synchronized (dataTierTupleSource) {
            if (this.aqr != null && this.dataMgr != null && !this.hasLOB) {
                this.aqr.setType(3);
                this.dataMgr.registerRequest(this.aqr);
            }
        }
        this.aqr = null;
        this.dataMgr = null;
        this.isLast = true;
        this.currentBatchCount = 0;
        this.index = 0;
        this.currentBatch = null;
        this.nextBatch = null;
    }
}

