/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.process;

import com.metamatrix.common.buffer.BufferManager;
import com.metamatrix.common.queue.QueueWorker;
import com.metamatrix.common.queue.QueueWorkerFactory;
import com.metamatrix.common.queue.WorkerPool;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.dqp.internal.cache.ResultSetCache;
import com.metamatrix.dqp.internal.process.DataTierManager;
import com.metamatrix.dqp.internal.process.ProcessWorker;
import com.metamatrix.dqp.internal.process.RequestManager;
import com.metamatrix.dqp.service.TrackingService;

public class ProcessWorkerFactory
implements QueueWorkerFactory {
    private RequestManager requestMgr;
    private BufferManager bufferMgr;
    private WorkerPool processPool;
    private int processorTimeslice;
    private DataTierManager dataTierManager;
    private TrackingService tracker;
    private ResultSetCache rsCache;

    public ProcessWorkerFactory(RequestManager requestMgr, BufferManager bufferMgr, int processorTimeslice, TrackingService tracker, ResultSetCache rsCache) {
        Assertion.isNotNull(requestMgr);
        Assertion.isNotNull(bufferMgr);
        this.requestMgr = requestMgr;
        this.bufferMgr = bufferMgr;
        this.processorTimeslice = processorTimeslice;
        this.tracker = tracker;
        this.rsCache = rsCache;
    }

    public void setProcessPool(WorkerPool processPool) {
        this.processPool = processPool;
    }

    public QueueWorker createWorker() {
        return new ProcessWorker(this.requestMgr, this.bufferMgr, this.processPool, this.processorTimeslice, this.dataTierManager, this.tracker, this.rsCache);
    }

    public void setDataTierManager(DataTierManager dataTierManager) {
        this.dataTierManager = dataTierManager;
    }
}

