/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.process;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.queue.QueueSuspendedException;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.dqp.internal.process.WorkItem;
import com.metamatrix.dqp.internal.process.WorkQueue;
import java.util.LinkedList;

public class WorkItemState {
    static final int IDLE = 0;
    static final int WORKING = 1;
    static final int MORE_WORK = 2;
    static final int DONE = 3;
    static final int IDLE_SENDING = 4;
    static final int WORKING_SENDING = 5;
    static final int MORE_WORK_SENDING = 6;
    static final int DONE_SENDING = 7;
    private int state;
    private WorkQueue queue;
    private BoundedStringBuffer history = new BoundedStringBuffer();
    private BoundedStringBuffer eventHistory = new BoundedStringBuffer();

    public WorkItemState(WorkQueue queue, boolean clientExpectsResults) {
        this.queue = queue;
        if (clientExpectsResults) {
            this.gotoState(6);
        } else {
            this.gotoState(2);
        }
    }

    int getState() {
        return this.state;
    }

    public void startProcessing() {
        this.addEvent("Start");
        switch (this.state) {
            case 2: {
                this.gotoState(1);
                break;
            }
            case 6: {
                this.gotoState(5);
                break;
            }
            case 7: {
                this.gotoState(5);
                break;
            }
            default: {
                this.invalidEvent(this.getStateString() + " is not an allowable start state.");
            }
        }
    }

    public void endProcessing(WorkItem workItem) throws QueueSuspendedException, MetaMatrixComponentException {
        this.addEvent("End");
        switch (this.state) {
            case 2: {
                this.queue.add(workItem);
                break;
            }
            case 1: {
                this.gotoState(0);
                break;
            }
            case 6: {
                this.queue.add(workItem);
                break;
            }
            case 5: {
                this.gotoState(4);
                break;
            }
            default: {
                this.invalidEvent(this.getStateString() + " is not an allowable end state.");
            }
        }
    }

    public void doneProcessing(WorkItem workItem) throws QueueSuspendedException, MetaMatrixComponentException {
        this.addEvent("Done");
        switch (this.state) {
            case 2: {
                this.gotoState(3);
                break;
            }
            case 1: {
                this.gotoState(3);
                break;
            }
            case 6: {
                this.gotoState(7);
                this.queue.add(workItem);
                break;
            }
            case 5: {
                this.gotoState(4);
                break;
            }
            default: {
                this.invalidEvent(this.getStateString() + " is not an allowable done state.");
            }
        }
    }

    public void sentResults() {
        this.addEvent("SentResults");
        switch (this.state) {
            case 6: {
                this.gotoState(2);
                break;
            }
            case 5: {
                this.gotoState(1);
                break;
            }
            case 4: 
            case 7: {
                this.invalidEvent("Cannot send results without working");
            }
            default: {
                this.invalidEvent("Cannot resend results");
            }
        }
    }

    public void requestResults(WorkItem workItem) throws QueueSuspendedException {
        this.addEvent("RequestResults");
        switch (this.state) {
            case 1: {
                this.gotoState(6);
                break;
            }
            case 0: {
                this.gotoState(6);
                this.queue.add(workItem);
                break;
            }
            case 3: {
                this.gotoState(7);
                this.queue.add(workItem);
                break;
            }
            case 2: {
                this.gotoState(6);
                break;
            }
            default: {
                this.invalidEvent("Results not sent");
            }
        }
    }

    public void pollResults(WorkItem workItem) throws QueueSuspendedException {
        this.addEvent("PollResults");
        switch (this.state) {
            case 0: 
            case 4: {
                this.gotoState(6);
                this.queue.add(workItem);
                break;
            }
            case 3: 
            case 7: {
                this.gotoState(7);
                this.queue.add(workItem);
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                this.gotoState(6);
            }
        }
    }

    public void requestWork(WorkItem workItem) throws QueueSuspendedException {
        this.addEvent("Request");
        switch (this.state) {
            case 0: {
                this.gotoState(2);
                this.queue.add(workItem);
                break;
            }
            case 2: {
                break;
            }
            case 6: {
                break;
            }
            case 1: {
                this.gotoState(2);
                break;
            }
            case 5: {
                this.gotoState(6);
                break;
            }
            case 4: {
                this.gotoState(6);
                this.queue.add(workItem);
            }
        }
    }

    private void gotoState(int newState) {
        this.state = newState;
        this.history.append(this.getStateString());
    }

    private void addEvent(String event) {
        this.eventHistory.append(event);
    }

    public String getStateString() {
        switch (this.state) {
            case 0: {
                return "IDLE";
            }
            case 2: {
                return "MORE_WORK";
            }
            case 1: {
                return "WORKING";
            }
            case 3: {
                return "DONE";
            }
            case 5: {
                return "WORKING_SENDING";
            }
            case 6: {
                return "MORE_WORK_SENDING";
            }
            case 4: {
                return "IDLE_SENDING";
            }
            case 7: {
                return "DONE_SENDING";
            }
        }
        throw new RuntimeException();
    }

    private void invalidEvent(String message) {
        throw new MetaMatrixRuntimeException(message + " " + this.getHistoryString());
    }

    public String getHistoryString() {
        return "[" + this.history + " ] [" + this.eventHistory + " ].";
    }

    boolean needsResults() {
        return this.state == 5 || this.state == 6 || this.state == 4 || this.state == 7;
    }

    static class BoundedStringBuffer {
        final int SIZE = 5;
        LinkedList stringList = new LinkedList();

        BoundedStringBuffer() {
        }

        public void append(String str) {
            if (this.stringList.size() < 5) {
                this.stringList.add(str);
            } else {
                this.stringList.removeFirst();
                this.stringList.addLast(str);
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            for (int i2 = 0; i2 < this.stringList.size(); ++i2) {
                sb.append(this.stringList.get(i2)).append(" ");
            }
            return sb.toString();
        }
    }
}

