/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.message;

import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.common.batch.BatchSerializer;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.common.xa.TransactionContext;
import com.metamatrix.core.util.ExternalizeUtil;
import com.metamatrix.data.api.ValueChunk;
import com.metamatrix.dqp.message.AtomicRequestMessage;
import com.metamatrix.dqp.message.CursorRequestMessage;
import com.metamatrix.dqp.message.DQPMessage;
import com.metamatrix.dqp.message.RequestID;
import com.metamatrix.dqp.message.RequestMessage;
import com.metamatrix.query.i.e;
import com.metamatrix.query.o.i.j;
import com.metamatrix.query.o.j.l;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class ResultsMessage
extends DQPMessage
implements Externalizable {
    static final long serialVersionUID = 3546924172976187793L;
    private RequestID requestID;
    private List[] results = null;
    private String[] columnNames = null;
    private String[] dataTypes = null;
    private l command = null;
    private int planNodeID = -1;
    private Map planDescription;
    private MetaMatrixException exception;
    private List warnings;
    private Collection schemas;
    private int firstRow = 0;
    private int lastRow;
    private boolean partialResultsFlag;
    private int finalRow = -1;
    private List parameters;
    private Date processingTimestamp;
    private Date completedTimestamp;
    private ValueChunk valueChunk;
    private e valueID;
    private long streamLength;
    private int fetchSize;
    private int cursorType;
    private String messageKey;
    private boolean isLob = false;
    private String debugLog;
    private TransactionContext txnContext;
    private Collection annotations;

    public ResultsMessage() {
    }

    public ResultsMessage(RequestMessage requestMsg, boolean copyTransactionContext) {
        if (requestMsg != null) {
            this.setRequestID(requestMsg.getRequestID());
            this.processingTimestamp = requestMsg.getProcessingTimestamp();
            this.completedTimestamp = new Date();
            this.fetchSize = requestMsg.getFetchSize();
            this.cursorType = requestMsg.getCursorType();
            this.messageKey = requestMsg.getMessageKey();
            this.isLob = requestMsg.isLobRequest();
            this.valueID = requestMsg.getValueID();
            if (copyTransactionContext) {
                this.txnContext = requestMsg.getTransactionContext();
            }
            if (!requestMsg.isLobRequest() && requestMsg instanceof AtomicRequestMessage) {
                this.setPlanNodeID(((AtomicRequestMessage)requestMsg).getNodeID());
            }
        }
        this.results = new ArrayList[0];
    }

    public ResultsMessage(CursorRequestMessage requestMsg) {
        if (requestMsg != null) {
            this.setRequestID(requestMsg.getRequestID());
            this.setMessageKey(requestMsg.getMessageKey());
        }
        this.results = new ArrayList[0];
    }

    public ResultsMessage(RequestMessage requestMsg, List[] results, List outputColumns, boolean copyTransactionContext) {
        this(requestMsg, copyTransactionContext);
        this.setResults(results);
        this.setFirstRow(1);
        this.setLastRow(results.length);
        this.setPartialResults(false);
        this.setMessageKey(requestMsg.getMessageKey());
        if (requestMsg instanceof AtomicRequestMessage) {
            this.setCommand(requestMsg.getCommand());
            this.setPlanNodeID(((AtomicRequestMessage)requestMsg).getNodeID());
        }
        this.setColumns(outputColumns);
    }

    public List[] getResults() {
        return this.results;
    }

    public void setResults(List[] results) {
        this.results = results;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public void setColumns(List columnSymbols) {
        this.columnNames = new String[columnSymbols.size()];
        this.dataTypes = new String[columnSymbols.size()];
        for (int i2 = 0; i2 < columnSymbols.size(); ++i2) {
            j symbol = (j)columnSymbols.get(i2);
            this.columnNames[i2] = symbol.a3();
            this.dataTypes[i2] = DataTypeManager.getDataTypeName(symbol.ag());
        }
    }

    public String[] getDataTypes() {
        return this.dataTypes;
    }

    public RequestID getRequestID() {
        return this.requestID;
    }

    public void setRequestID(RequestID requestID) {
        this.requestID = requestID;
    }

    public MetaMatrixException getException() {
        return this.exception;
    }

    public int getFinalRow() {
        return this.finalRow;
    }

    public int getFirstRow() {
        return this.firstRow;
    }

    public int getLastRow() {
        return this.lastRow;
    }

    public boolean isPartialResults() {
        return this.partialResultsFlag;
    }

    public Map getPlanDescription() {
        return this.planDescription;
    }

    public int getPlanNodeID() {
        return this.planNodeID;
    }

    public Collection getSchemas() {
        return this.schemas;
    }

    public List getWarnings() {
        return this.warnings;
    }

    public void setException(Throwable e2) {
        this.exception = e2 instanceof MetaMatrixException ? (MetaMatrixException)e2 : new MetaMatrixException(e2, e2.getMessage());
    }

    public void setFinalRow(int i2) {
        this.finalRow = i2;
    }

    public void setFirstRow(int i2) {
        this.firstRow = i2;
    }

    public void setLastRow(int i2) {
        this.lastRow = i2;
    }

    public void setPartialResults(boolean b2) {
        this.partialResultsFlag = b2;
    }

    public void setPlanDescription(Map object) {
        this.planDescription = object;
    }

    public void setPlanNodeID(int i2) {
        this.planNodeID = i2;
    }

    public void setSchemas(Collection collection) {
        this.schemas = collection;
    }

    public void setWarnings(List list) {
        this.warnings = list;
    }

    public List getParameters() {
        return this.parameters;
    }

    public void setParameters(List list) {
        this.parameters = list;
    }

    public ValueChunk getValueChunk() {
        return this.valueChunk;
    }

    public e getValueID() {
        return this.valueID;
    }

    public void setValueChunk(ValueChunk valueChunk) {
        this.valueChunk = valueChunk;
    }

    public int getMessageType() {
        return 8;
    }

    public Date getProcessingTimestamp() {
        return this.processingTimestamp;
    }

    public Date getCompletedTimestamp() {
        return this.completedTimestamp;
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
    }

    public void setDataTypes(String[] dataTypes) {
        this.dataTypes = dataTypes;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public int getCursorType() {
        return this.cursorType;
    }

    public void setCursorType(int cursorType) {
        this.cursorType = cursorType;
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public void setMessageKey(String messageKey) {
        this.messageKey = messageKey;
    }

    public boolean isLob() {
        return this.isLob;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.requestID = (RequestID)in.readObject();
        this.columnNames = ExternalizeUtil.readStringArray(in);
        this.dataTypes = ExternalizeUtil.readStringArray(in);
        this.results = BatchSerializer.readBatch(in, this.dataTypes);
        this.planNodeID = in.readInt();
        this.planDescription = ExternalizeUtil.readMap(in);
        this.exception = (MetaMatrixException)ExternalizeUtil.readThrowable(in);
        this.warnings = ExternalizeUtil.readList(in);
        this.schemas = ExternalizeUtil.readList(in);
        this.firstRow = in.readInt();
        this.lastRow = in.readInt();
        this.partialResultsFlag = in.readBoolean();
        this.finalRow = in.readInt();
        this.parameters = ExternalizeUtil.readList(in);
        this.processingTimestamp = (Date)in.readObject();
        this.completedTimestamp = (Date)in.readObject();
        this.valueChunk = (ValueChunk)in.readObject();
        this.fetchSize = in.readInt();
        this.cursorType = in.readInt();
        this.messageKey = (String)in.readObject();
        this.command = (l)in.readObject();
        this.streamLength = in.readLong();
        this.debugLog = (String)in.readObject();
        this.annotations = (Collection)in.readObject();
        this.txnContext = (TransactionContext)in.readObject();
        this.isLob = in.readBoolean();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.requestID);
        ExternalizeUtil.writeArray(out, this.columnNames);
        ExternalizeUtil.writeArray(out, this.dataTypes);
        BatchSerializer.writeBatch(out, this.dataTypes, this.results);
        out.writeInt(this.planNodeID);
        ExternalizeUtil.writeMap(out, this.planDescription);
        ExternalizeUtil.writeThrowable(out, this.exception);
        ExternalizeUtil.writeList(out, this.warnings);
        ExternalizeUtil.writeCollection(out, this.schemas);
        out.writeInt(this.firstRow);
        out.writeInt(this.lastRow);
        out.writeBoolean(this.partialResultsFlag);
        out.writeInt(this.finalRow);
        ExternalizeUtil.writeList(out, this.parameters);
        out.writeObject(this.processingTimestamp);
        out.writeObject(this.completedTimestamp);
        out.writeObject(this.valueChunk);
        out.writeInt(this.fetchSize);
        out.writeInt(this.cursorType);
        out.writeObject(this.messageKey);
        out.writeObject(this.command);
        out.writeLong(this.streamLength);
        out.writeObject(this.debugLog);
        out.writeObject(this.annotations);
        out.writeObject(this.txnContext);
        out.writeBoolean(this.isLob);
    }

    public long getStreamLength() {
        return this.streamLength;
    }

    public void setStreamLength(long streamLength) {
        this.streamLength = streamLength;
    }

    public l getCommand() {
        return this.command;
    }

    public void setCommand(l command) {
        this.command = command;
    }

    public Collection getAnnotations() {
        return this.annotations;
    }

    public String getDebugLog() {
        return this.debugLog;
    }

    public void setAnnotations(Collection collection) {
        this.annotations = collection;
    }

    public void setDebugLog(String string) {
        this.debugLog = string;
    }

    public TransactionContext getTransactionContext() {
        return this.txnContext;
    }

    public void setTransactionContext(TransactionContext context) {
        this.txnContext = context;
    }

    public String toString() {
        return "ResultsMessage rowCount=" + (this.results == null ? 0 : this.results.length) + " finalRow=" + this.finalRow;
    }
}

