/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.internal.core.index;

import com.metamatrix.core.index.IDocument;
import com.metamatrix.internal.core.index.BlocksIndexOutput;
import com.metamatrix.internal.core.index.IndexOutput;
import com.metamatrix.internal.core.index.IndexedFile;
import com.metamatrix.internal.core.index.IndexedFileHashedArray;
import com.metamatrix.internal.core.index.Util;
import com.metamatrix.internal.core.index.WordEntry;
import com.metamatrix.internal.core.index.WordEntryHashedArray;
import java.io.File;
import java.io.IOException;

public class InMemoryIndex {
    protected WordEntryHashedArray words;
    protected IndexedFileHashedArray files;
    protected long footprint;
    private WordEntry[] sortedWordEntries;
    private IndexedFile[] sortedFiles;

    public InMemoryIndex() {
        this.init();
    }

    public IndexedFile addDocument(IDocument document) {
        IndexedFile indexedFile = this.files.add(document);
        this.footprint += (long)(indexedFile.footprint() + 4);
        this.sortedFiles = null;
        return indexedFile;
    }

    protected void addRef(char[] word, int[] references) {
        int size = references.length;
        for (int i2 = 0; i2 < size; ++i2) {
            if (references[i2] == 0) continue;
            this.addRef(word, references[i2]);
        }
    }

    protected void addRef(char[] word, int fileNum) {
        WordEntry entry = new WordEntry(word);
        entry.addRef(fileNum);
        this.words.add(entry);
        this.sortedWordEntries = null;
        this.footprint += (long)entry.footprint();
    }

    public void addRef(IndexedFile indexedFile, char[] word) {
        this.addRef(word, indexedFile.getFileNumber());
    }

    public void addRef(IndexedFile indexedFile, String word) {
        this.addRef(word.toCharArray(), indexedFile.getFileNumber());
    }

    public long getFootprint() {
        return this.footprint;
    }

    public IndexedFile getIndexedFile(String path) {
        return this.files.get(path);
    }

    public int getNumFiles() {
        return this.files.size();
    }

    public int getNumWords() {
        return this.words.elementSize;
    }

    protected IndexedFile[] getSortedFiles() {
        if (this.sortedFiles == null) {
            IndexedFile[] indexedFiles = this.files.asArray();
            Util.sort(indexedFiles);
            this.sortedFiles = indexedFiles;
        }
        return this.sortedFiles;
    }

    protected WordEntry[] getSortedWordEntries() {
        if (this.sortedWordEntries == null) {
            WordEntry[] words = this.words.asArray();
            Util.sort(words);
            this.sortedWordEntries = words;
        }
        return this.sortedWordEntries;
    }

    protected WordEntry getWordEntry(char[] word) {
        return this.words.get(word);
    }

    public void init() {
        this.words = new WordEntryHashedArray(501);
        this.files = new IndexedFileHashedArray(101);
        this.footprint = 0L;
        this.sortedWordEntries = null;
        this.sortedFiles = null;
    }

    public void save(File file) throws IOException {
        BlocksIndexOutput output = new BlocksIndexOutput(file);
        this.save(output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void save(IndexOutput output) throws IOException {
        boolean ok = false;
        try {
            int i2;
            output.open();
            IndexedFile[] indexedFiles = this.files.asArray();
            int length = indexedFiles.length;
            for (i2 = 0; i2 < length; ++i2) {
                output.addFile(indexedFiles[i2]);
            }
            this.getSortedWordEntries();
            int numWords = this.sortedWordEntries.length;
            for (i2 = 0; i2 < numWords; ++i2) {
                output.addWord(this.sortedWordEntries[i2]);
            }
            output.flush();
            output.close();
            return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (ok || output == null) throw throwable;
            output.close();
            throw throwable;
        }
    }
}

