/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.internal.core.index;

import com.metamatrix.core.index.IDocument;
import com.metamatrix.internal.core.index.IndexedFile;
import java.util.ArrayList;

public final class IndexedFileHashedArray {
    private IndexedFile[] elements;
    private int elementSize;
    private int threshold;
    private int lastId;
    private ArrayList replacedElements;

    public IndexedFileHashedArray(int size) {
        if (size < 7) {
            size = 7;
        }
        this.elements = new IndexedFile[2 * size + 1];
        this.elementSize = 0;
        this.threshold = size + 1;
        this.lastId = 0;
        this.replacedElements = null;
    }

    public IndexedFile add(IDocument document) {
        return this.add(new IndexedFile(document, ++this.lastId));
    }

    private IndexedFile add(IndexedFile file) {
        IndexedFile current;
        int length = this.elements.length;
        String path = file.getPath();
        int index = (path.hashCode() & Integer.MAX_VALUE) % length;
        while ((current = this.elements[index]) != null) {
            if (current.getPath().equals(path)) {
                if (this.replacedElements == null) {
                    this.replacedElements = new ArrayList(5);
                }
                this.replacedElements.add(current);
                this.elements[index] = file;
                return this.elements[index];
            }
            if (++index != length) continue;
            index = 0;
        }
        this.elements[index] = file;
        if (++this.elementSize > this.threshold) {
            this.grow();
        }
        return file;
    }

    public IndexedFile[] asArray() {
        IndexedFile current;
        int i2;
        IndexedFile[] array = new IndexedFile[this.lastId];
        int length = this.elements.length;
        for (i2 = 0; i2 < length; ++i2) {
            current = this.elements[i2];
            if (current == null) continue;
            array[current.fileNumber - 1] = current;
        }
        if (this.replacedElements != null) {
            length = this.replacedElements.size();
            for (i2 = 0; i2 < length; ++i2) {
                array[current.fileNumber - 1] = current = (IndexedFile)this.replacedElements.get(i2);
            }
        }
        return array;
    }

    public IndexedFile get(String path) {
        IndexedFile current;
        int length = this.elements.length;
        int index = (path.hashCode() & Integer.MAX_VALUE) % length;
        while ((current = this.elements[index]) != null) {
            if (current.getPath().equals(path)) {
                return current;
            }
            if (++index != length) continue;
            index = 0;
        }
        return null;
    }

    private void grow() {
        IndexedFileHashedArray newArray = new IndexedFileHashedArray(this.elementSize * 2);
        int length = this.elements.length;
        for (int i2 = 0; i2 < length; ++i2) {
            if (this.elements[i2] == null) continue;
            newArray.add(this.elements[i2]);
        }
        this.elements = newArray.elements;
        this.elementSize = newArray.elementSize;
        this.threshold = newArray.threshold;
    }

    public int size() {
        return this.elementSize + (this.replacedElements == null ? 0 : this.replacedElements.size());
    }

    public String toString() {
        String s2 = "";
        IndexedFile[] files = this.asArray();
        int length = files.length;
        for (int i2 = 0; i2 < length; ++i2) {
            s2 = s2 + files[i2].toString() + "\n";
        }
        return s2;
    }
}

